/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Grouplet;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.symmetric.service.IParameterService;

public class GroupletCache {
    private IParameterService parameterService;
    private IGroupletService groupletService;
    private ISymmetricEngine engine;
    private volatile List<Grouplet> groupletCache;
    private volatile long groupletCacheTime = 0L;
    private volatile Object groupletCacheLock = new Object();

    public GroupletCache(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
        this.groupletService = engine.getGroupletService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Grouplet> getGrouplets(boolean refreshCache) {
        if (!this.engine.getParameterService().is("grouplet.enable")) {
            return new ArrayList<Grouplet>();
        }
        long maxCacheTime = this.parameterService.getLong("cache.grouplets.time.ms");
        if (this.groupletCache == null || System.currentTimeMillis() - this.groupletCacheTime >= maxCacheTime || this.groupletCacheTime == 0L || refreshCache) {
            Object object = this.groupletCacheLock;
            synchronized (object) {
                if (this.groupletCache == null || System.currentTimeMillis() - this.groupletCacheTime >= maxCacheTime || this.groupletCacheTime == 0L || refreshCache) {
                    this.groupletCache = this.groupletService.getGroupletsFromDb();
                    this.groupletCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.groupletCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushGrouplets() {
        Object object = this.groupletCacheLock;
        synchronized (object) {
            this.groupletCacheTime = 0L;
        }
    }
}

