/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.log;

import com.ibm.as400.access.AS400PackedDecimal;
import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.console.impl.hm;
import com.jumpmind.symmetric.console.impl.hp;
import com.jumpmind.symmetric.console.impl.hu;
import com.jumpmind.symmetric.console.impl.hv;
import com.jumpmind.symmetric.console.impl.hw;
import com.jumpmind.symmetric.log.d;
import com.jumpmind.symmetric.log.g;
import com.jumpmind.symmetric.log.l;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.util.Arrays;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class c
implements g {
    private final Logger r = LoggerFactory.getLogger((String)new hh(new long[]{-2551471713779896240L, -4066725443669494390L, -4284816461577091695L, 4020321807734670777L, -2952473824541314309L, -3201259330774836281L, -6500790322396559572L}).toString());
    private ISymmetricEngine s;
    protected ISqlTemplate a;
    private hu t;
    private long u;
    protected ISqlReadCursor<Row> b;
    protected hw c;
    protected Map<String, l> d;
    protected static final String e = "PT";
    protected static final String f = "PX";
    protected static final String g = "UB";
    protected static final String h = "UP";
    protected static final String i = "DL";
    protected static final String j = "DR";
    protected static final String k = "RB";
    protected static final String l = "CM";
    protected static final Charset m = Charset.forName("cp1140");
    protected static final Charset n = Charset.forName("UTF-16");
    String o = null;
    String p = null;
    boolean q = true;

    public c() {
    }

    public c(ISymmetricEngine engine, IDatabasePlatform platform, hu options) {
        this.s = engine;
        this.a = engine.getTargetDialect().getPlatform().getSqlTemplate();
        this.t = options;
    }

    @Override
    public void a() {
        long startId = this.t.d();
        this.u = this.t.e();
        try {
            this.o = this.s.getParameterService().getString("as400.journal.library", "SYM");
            this.p = this.s.getParameterService().getString("as400.journal.name", "QSQJRN");
            this.q = this.s.getParameterService().is("include.rowidentifier.as.column", true);
            String sql = "select journal_code, journal_entry_type, substr(object,1,10) as table, substr(object,11,10) AS library, commit_cycle, entry_timestamp, sequence_number,entry_data, count_or_rrn from table (qsys2.display_journal( '" + this.o + "', '" + this.p + "'))  where journal_entry_type in ('PT', 'PX', 'DL', 'DR', 'UP', 'UB', 'CM', 'RB') and sequence_number >= ? and sequence_number <= ?";
            this.b = this.a.queryForCursor(sql, (ISqlRowMapper)new RowMapper(), new Object[]{startId, this.u}, new int[]{3, 3});
        }
        catch (Exception e2) {
            String msg = String.format("Failed to init AS400 log miner with options=%s", this.t);
            throw new d(msg, e2);
        }
    }

    @Override
    public hm b() {
        hm dataObject = null;
        while (this.b != null) {
            Row row = (Row)this.b.next();
            if (row != null) {
                l logTrigger;
                if (this.r.isDebugEnabled()) {
                    this.r.debug("Row: {}", (Object)row);
                }
                String rawEventType = row.getString("journal_entry_type");
                boolean isUpdateOld = false;
                if (g.equals(rawEventType)) {
                    isUpdateOld = true;
                }
                dataObject = new hm();
                dataObject.a(this.a(rawEventType));
                if (dataObject.b() < 0 && !isUpdateOld) {
                    this.r.info("Journal entry type not being tracked, skipping (" + rawEventType + ")");
                    continue;
                }
                dataObject.c(row.getString("commit_cycle"));
                if (dataObject.f() != null && dataObject.f().equals("0")) {
                    dataObject.a(true);
                }
                dataObject.a(row.getLong("sequence_number"));
                if (dataObject.b() == 7 || dataObject.b() == 36) continue;
                dataObject.b(row.getString("table") != null ? row.getString("table").trim() : null);
                String schemaName = row.getString("library");
                Table table = this.s.getTargetDialect().getPlatform().getTableFromCache(null, schemaName.trim(), dataObject.e().trim(), false);
                if (table.getPrimaryKeyColumnCount() == 0) {
                    table = this.s.getTargetDialect().getPlatform().makeAllColumnsPrimaryKeys(table);
                }
                if (!((logTrigger = this.d.get(table.getSchema() + "." + table.getName())) != null && logTrigger.a(dataObject.b()) || rawEventType != null && rawEventType.equals(g))) {
                    dataObject = null;
                    continue;
                }
                dataObject.a(this.a(dataObject.b(), table, row, isUpdateOld));
                if (!isUpdateOld) break;
                continue;
            }
            this.b.close();
            this.b = null;
        }
        return dataObject;
    }

    protected hw a(int eventType, Table table, Row row, boolean isUpdateOld) {
        hw data = new hw();
        data.a("schema", row.getString("library").trim());
        this.a(data, table, row, eventType, isUpdateOld);
        return data;
    }

    protected void a(hw data, Table table, Row row, int eventType, boolean isUpdateOld) {
        byte[] entryData = (byte[])row.get((Object)"entry_data");
        hw rowData = new hw();
        hw pkData = new hw();
        this.a(table, entryData, rowData, pkData);
        if (isUpdateOld) {
            this.c = rowData;
        }
        data.a("rowData", rowData);
        data.a("idData", pkData);
        if (eventType == 2) {
            data.a("oldData", rowData);
        } else if (eventType == 3) {
            if (this.c == null) {
                this.r.debug("UB events not being captured, UB entry is present only if IMAGES(*BOTH) is specified on the STRJRNPF command");
            }
            data.a("oldData", this.c == null ? rowData : this.c);
        } else {
            if (this.q) {
                row.getBigDecimal("count_or_rrn");
                hv numberValue = new hv(Long.valueOf(row.getLong("count_or_rrn")).toString());
                rowData.a("RRN", numberValue);
            }
            data.a("rowData", rowData);
        }
    }

    public void a(Table table, byte[] entry, hw rowData, hw pkData) {
        if (this.r.isDebugEnabled()) {
            this.r.debug("journal entry:" + Hex.encodeHexString((byte[])entry));
        }
        int position = 0;
        PlatformColumn platformColumn = null;
        Column logColumn = null;
        try {
            for (Column column : table.getColumns()) {
                if (column.getName().equals("RRN")) continue;
                platformColumn = (PlatformColumn)column.getPlatformColumns().get("db2as400");
                logColumn = column;
                if (platformColumn.getType().equals("INTEGER")) {
                    position = this.a(entry, rowData, pkData, column, position);
                    continue;
                }
                if (platformColumn.getType().equals("SMALLINT")) {
                    position = this.b(entry, rowData, pkData, column, position);
                    continue;
                }
                if (platformColumn.getType().equals("BIGINT")) {
                    position = this.c(entry, rowData, pkData, column, position);
                    continue;
                }
                if (platformColumn.getType().equals("VARCHAR")) {
                    position = this.a(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("CHAR")) {
                    position = this.a(entry, rowData, pkData, column, position, platformColumn, m);
                    continue;
                }
                if (platformColumn.getType().equals("NCHAR") || platformColumn.getType().equals("NVARCHAR")) {
                    position = this.a(entry, rowData, pkData, column, position, platformColumn, n);
                    continue;
                }
                if (platformColumn.getType().equals("TIME")) {
                    position = this.b(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("DATE")) {
                    position = this.c(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("TIMESTAMP")) {
                    position = this.d(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("BOOLEAN")) {
                    position = this.e(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("DECIMAL")) {
                    position = this.f(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (platformColumn.getType().equals("NUMERIC")) {
                    position = this.g(entry, rowData, pkData, column, position, platformColumn);
                    continue;
                }
                if (!platformColumn.getType().equals("CLOB") && !platformColumn.getType().equals("BLOB") && !platformColumn.getType().equals("DCLOB")) continue;
                position = this.h(entry, rowData, pkData, column, position, platformColumn);
            }
        }
        catch (Exception e2) {
            if (this.r.isInfoEnabled()) {
                this.r.info("Journal entry failed to read: " + Hex.encodeHexString((byte[])entry));
                this.r.info("Last position recorded: " + position);
                this.r.info("Platform column: " + logColumn.getName() + ", type: " + platformColumn.getType());
                for (hp element : pkData.c().values()) {
                    this.r.info("PK " + String.valueOf((Object)element.a()) + ", " + element.e());
                }
                for (hp element : rowData.c().values()) {
                    this.r.info("Element " + String.valueOf((Object)element.a()) + ", " + element.e());
                }
            }
            throw new RuntimeException("Unable to read DB2 AS400 journal for table " + table.getFullyQualifiedTableName(), e2);
        }
    }

    public int a(byte[] entry, hw value, hw pkData, Column column, int startPosition) throws SQLException {
        hv numberValue = new hv(Integer.valueOf(ByteBuffer.wrap(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + 4))).getInt()).toString());
        value.a(column.getName(), numberValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), numberValue);
        }
        return startPosition + 4;
    }

    public int b(byte[] entry, hw value, hw pkData, Column column, int startPosition) throws SQLException {
        hv numberValue = new hv(Short.valueOf(ByteBuffer.wrap(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + 2))).getShort()).toString());
        value.a(column.getName(), numberValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), numberValue);
        }
        return startPosition + 2;
    }

    public int c(byte[] entry, hw value, hw pkData, Column column, int startPosition) throws SQLException {
        hv numberValue = new hv(Long.valueOf(ByteBuffer.wrap(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + 8))).getLong()).toString());
        value.a(column.getName(), numberValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), numberValue);
        }
        return startPosition + 8;
    }

    public int a(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        short actualSize = ByteBuffer.wrap(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + 2))).getShort();
        String stringValue = this.a(entry, startPosition += 2, startPosition + actualSize);
        value.a(column.getName(), stringValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), stringValue);
        }
        return startPosition + platformColumn.getSize();
    }

    public int a(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn, Charset charset) throws SQLException {
        int size = platformColumn.getSize();
        if (charset.equals(n)) {
            size *= 2;
        }
        String stringValue = this.a(entry, startPosition, startPosition + size, charset);
        value.a(column.getName(), stringValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), stringValue);
        }
        return startPosition + size;
    }

    public int b(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        String time = this.a(entry, startPosition, startPosition + 8).replaceAll("\\.", ":");
        value.a(column.getName(), time);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), time);
        }
        return startPosition + 8;
    }

    public int c(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        String stringValue = this.a(entry, startPosition + 1, startPosition + 11);
        value.a(column.getName(), stringValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), stringValue);
        }
        return startPosition + 11;
    }

    public int d(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        Object stringValue = this.a(entry, startPosition, startPosition + 25).replaceAll("\\.", ":");
        stringValue = ((String)stringValue).substring(0, 10) + " " + ((String)stringValue).substring(11, 19) + "." + ((String)stringValue).substring(20);
        value.a(column.getName(), (String)stringValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), (String)stringValue);
        }
        return startPosition + 25;
    }

    public int e(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        String stringValue = this.a(entry, startPosition, startPosition + 1);
        value.a(column.getName(), stringValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), stringValue);
        }
        return startPosition + 1;
    }

    public int f(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        int packedSize = (int)Math.floor((double)column.getSizeAsInt() / 2.0) + 1;
        byte[] tempArray = Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + packedSize));
        if (tempArray.length == 1 && tempArray[0] == 0) {
            hp emptyElement = null;
            value.a(column.getName(), emptyElement);
            if (column.isPrimaryKey()) {
                pkData.a(column.getName(), emptyElement);
            }
            return startPosition + packedSize;
        }
        double decimalValue = new AS400PackedDecimal(column.getSizeAsInt(), column.getScale()).toDouble(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + packedSize)));
        hv numberValue = null;
        numberValue = column.getScale() == 0 ? new hv(String.valueOf(Double.valueOf(decimalValue).intValue())) : new hv(String.valueOf(decimalValue));
        value.a(column.getName(), numberValue);
        if (column.isPrimaryKey()) {
            pkData.a(column.getName(), numberValue);
        }
        return startPosition + packedSize;
    }

    public int g(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        int lastPostion = startPosition + column.getSizeAsInt() - 1;
        boolean isNegative = false;
        boolean isNull = false;
        byte lastChar = entry[lastPostion];
        if (lastChar == 64) {
            isNull = true;
        } else if ((lastChar & 0x20) == 0) {
            entry[lastPostion] = lastChar = (byte)(lastChar | 0x20);
            isNegative = true;
        }
        if (isNull) {
            value.a(column.getName(), new hv(null));
        } else {
            Object stringValue = new String(Arrays.copyOfRange((byte[])entry, (int)startPosition, (int)(startPosition + column.getSizeAsInt())), m).replaceAll("\\.", ":");
            if (column.getScale() > 0) {
                stringValue = ((String)stringValue).substring(0, column.getSizeAsInt() - column.getScale()) + "." + ((String)stringValue).substring(column.getSizeAsInt() - column.getScale());
            }
            BigDecimal bigDecimalValue = new BigDecimal((String)stringValue);
            if (isNegative) {
                bigDecimalValue = bigDecimalValue.negate();
            }
            stringValue = bigDecimalValue.stripTrailingZeros().toPlainString();
            hv numberValue = new hv((String)stringValue);
            value.a(column.getName(), numberValue);
            if (column.isPrimaryKey()) {
                pkData.a(column.getName(), numberValue);
            }
        }
        return startPosition + column.getSizeAsInt();
    }

    public int h(byte[] entry, hw value, hw pkData, Column column, int startPosition, PlatformColumn platformColumn) throws SQLException {
        value.a(column.getName(), "\b");
        return startPosition + 44;
    }

    protected String a(byte[] original, int from, int to) {
        return this.a(original, from, to, m);
    }

    protected String a(byte[] original, int from, int to, Charset charset) {
        String str = new String(Arrays.copyOfRange((byte[])original, (int)from, (int)to), charset);
        return str.replaceAll("\u0000", "");
    }

    protected int a(String eventType) {
        if (e.equals(eventType) || f.equals(eventType)) {
            return 1;
        }
        if (h.equals(eventType)) {
            return 3;
        }
        if (i.equals(eventType)) {
            return 2;
        }
        if (l.equals(eventType)) {
            return 7;
        }
        if (k.equals(eventType)) {
            return 36;
        }
        return -1;
    }

    @Override
    public long c() {
        this.o = this.s.getParameterService().getString("as400.journal.library", "SYM");
        this.p = this.s.getParameterService().getString("as400.journal.name", "QSQJRN");
        return this.a.queryForLong("select max(sequence_number) as sequence_number from table (qsys2.display_journal( '" + this.o + "', '" + this.p + "'))", new Object[0]);
    }

    @Override
    public void d() {
        if (this.b != null) {
            this.b.close();
            this.b = null;
        }
    }

    @Override
    public void e() {
        if (this.b != null) {
            this.b.close();
            this.b = null;
        }
    }

    @Override
    public void a(Map<String, l> logTriggerMap) {
        this.d = logTriggerMap;
    }
}

