/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.snowflake;

import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class e
extends DmlStatement {
    public e(DmlStatementOptions options) {
        super(options);
    }

    public String buildInsertSql(String tableName, Column[] keyColumns, Column[] columns) {
        if (keyColumns != null && keyColumns.length > 0 && keyColumns[0] != null) {
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(tableName);
            sql.append("(");
            this.appendColumns(sql, columns, false);
            sql.append(") (select ");
            this.appendColumnParameters(sql, columns);
            sql.append(" where not exists(select ");
            this.appendColumns(sql, keyColumns, false);
            sql.append(" from ");
            sql.append(tableName);
            sql.append(" where ");
            if (keyColumns == null || keyColumns.length == 0) {
                sql.append("1 != 1");
            } else {
                this.appendColumnsEquals(sql, keyColumns, " and ");
            }
            sql.append("))");
            return sql.toString();
        }
        return super.buildInsertSql(tableName, keyColumns, columns);
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
            int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
            return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
        }
        return super.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }

    public Column[] getMetaData() {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return this.getColumnKeyMetaData();
        }
        return super.getMetaData();
    }

    protected void appendColumnParameter(StringBuilder sql, Column column) {
        if (column.isOfBinaryType()) {
            sql.append("to_binary(hex_encode(?), 'HEX')").append(",");
        } else if (column.getJdbcTypeName().equals("VARIANT")) {
            sql.append("to_variant(?)").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    protected void appendColumnEquals(StringBuilder sql, Column column) {
        String columnName = column.getName();
        if (column.isOfBinaryType()) {
            sql.append(this.quote).append(columnName).append(this.quote).append(" = to_binary(hex_encode(?), 'HEX') ");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }

    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        if (select && column.isOfBinaryType()) {
            sql.append("hex_decode_string(to_varchar(").append(this.quote).append(columnName).append(this.quote).append(")) as ").append(columnName);
        } else {
            super.appendColumnNameForSql(sql, column, select);
        }
    }
}

