/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.mongo;

import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.db.mongo.a;
import java.util.List;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterErrorHandler;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.io.data.writer.ResolvedData;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.jumpmind.symmetric.load.AbstractDataLoaderFactory;
import org.jumpmind.symmetric.load.IDataLoaderFactory;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDataLoaderFactory
extends AbstractDataLoaderFactory
implements IDataLoaderFactory {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ISymmetricEngine engine;

    public MongoDataLoaderFactory(ISymmetricEngine engine) {
        this.engine = engine;
        this.parameterService = engine.getParameterService();
    }

    public String getTypeName() {
        return "mongo_bulk";
    }

    public IDataWriter getDataWriter(String sourceNodeId, Channel channel, ISymmetricDialect symmetricDialect, TransformWriter transformWriter, List<IDatabaseWriterFilter> filters, List<IDatabaseWriterErrorHandler> errorHandlers, List<? extends Conflict> conflictSettings, List<ResolvedData> resolvedData) {
        INodeService nodeService = this.engine.getNodeService();
        Node sourceNode = nodeService.findNode(sourceNodeId);
        String sourceNodeGroupId = "";
        if (sourceNode != null) {
            sourceNodeGroupId = sourceNode.getNodeGroupId();
        }
        Node targetNode = nodeService.findIdentity();
        String targetNodeGroupId = "";
        if (targetNode != null) {
            targetNodeGroupId = targetNode.getNodeGroupId();
        }
        return new a(symmetricDialect.getPlatform(), symmetricDialect.getTargetPlatform(), symmetricDialect.getTablePrefix(), ((ITableGroupService)this.engine.getExtensionService().getExtensionPoint(ITableGroupService.class)).getTableGroupHierByTableName(sourceNodeGroupId, targetNodeGroupId, TableGroup.WriterType.JSON, true), this.parameterService, filters);
    }

    public boolean isPlatformSupported(IDatabasePlatform platform) {
        return "mongo".equals(platform.getName());
    }
}

