/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.elasticsearch;

import com.jumpmind.symmetric.db.elasticsearch.e;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.transport.http.SelfSignedX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPlatformFactory {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchPlatformFactory.class);
    Exception exception;

    public e createDatabasePlatform(SqlTemplateSettings settings, String contactPoint) {
        return new e(settings, contactPoint);
    }

    public void canConnectToElastic(String url, String pass, String userName) {
        RestHighLevelClient testClient = null;
        URL testUrl = null;
        this.exception = null;
        try {
            testUrl = new URL(url);
        }
        catch (MalformedURLException e2) {
            log.error("Error forming Elasticsearch Test URL: ", (Throwable)e2);
        }
        if (testUrl.getProtocol().contains("https")) {
            if (!userName.isEmpty()) {
                ISecurityService securityService = SecurityServiceFactory.create();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                try {
                    SSLContext context = this.generateSSLContext(securityService);
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, pass));
                    RestClientBuilder testBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(testUrl.getHost(), testUrl.getPort(), testUrl.getProtocol())}).setHttpClientConfigCallback(arg_0 -> ElasticSearchPlatformFactory.lambda$canConnectToElastic$0((CredentialsProvider)credentialsProvider, context, arg_0));
                    testClient = new RestHighLevelClient(testBuilder);
                    this.testCon(testClient);
                }
                catch (Exception e3) {
                    if (this.exception != null) {
                        throw new RuntimeException(this.exception);
                    }
                    log.warn("No trust store found: " + e3.getMessage());
                }
            } else {
                ISecurityService securityService = SecurityServiceFactory.create();
                try {
                    SSLContext context = this.generateSSLContext(securityService);
                    RestClientBuilder testBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(testUrl.getHost(), testUrl.getPort(), testUrl.getProtocol())}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE));
                    testClient = new RestHighLevelClient(testBuilder);
                    this.testCon(testClient);
                }
                catch (Exception e4) {
                    if (this.exception != null) {
                        throw new RuntimeException(this.exception);
                    }
                    log.warn("No trust store found: " + e4.getMessage());
                }
            }
        } else if (!userName.isEmpty()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, pass));
            RestClientBuilder testBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(testUrl.getHost(), testUrl.getPort(), testUrl.getProtocol())}).setHttpClientConfigCallback(arg_0 -> ElasticSearchPlatformFactory.lambda$canConnectToElastic$2((CredentialsProvider)credentialsProvider, arg_0));
            testClient = new RestHighLevelClient(testBuilder);
            this.testCon(testClient);
        } else {
            RestClientBuilder testBuilder = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)url)});
            testClient = new RestHighLevelClient(testBuilder);
            this.testCon(testClient);
        }
    }

    protected void testCon(RestHighLevelClient testClient) {
        Request checkConnectionRequest = new Request("GET", "/_cat/indices?h=i");
        try {
            InputStream inputStream = testClient.getLowLevelClient().performRequest(checkConnectionRequest).getEntity().getContent();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException | UnsupportedOperationException e2) {
            this.exception = e2;
            throw new RuntimeException(e2);
        }
    }

    protected SSLContext generateSSLContext(ISecurityService securityService) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyStore trustStore = null;
            trustStore = securityService.getTrustStore();
            SelfSignedX509TrustManager trustManager = new SelfSignedX509TrustManager(trustStore);
            KeyManager[] keyManagers = null;
            try {
                keyManagers = securityService.getKeyManagerFactory().getKeyManagers();
            }
            catch (Exception e2) {
                log.warn("No key managers found: " + e2.getMessage());
            }
            context.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            return context;
        }
        catch (Exception e3) {
            log.warn("No trust store found: " + e3.getMessage());
            return null;
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$canConnectToElastic$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$canConnectToElastic$0(CredentialsProvider credentialsProvider, SSLContext context, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(context).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }
}

