/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.db.bulk.r;
import com.jumpmind.symmetric.db.bulk.t;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.AbstractBulkDatabaseWriter;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class v
extends AbstractBulkDatabaseWriter {
    private static final Logger f = LoggerFactory.getLogger((String)new hh(new long[]{-7757275590349791570L, 637490877648274938L, 9064822622502664320L, 8572551411952572651L, 5308848564015974984L, -33960846234236604L, 3492479970408452769L, 970641382693907524L, -1737528388022275849L}).toString());
    protected final long a = 10L;
    protected int b;
    protected boolean c;
    protected boolean d;
    protected t e = null;

    public v(IDatabasePlatform symmetricPlatform, IDatabasePlatform targetPlatform, String tablePrefix, DatabaseWriterSettings settings, int maxRowsBeforeFlush, List<IDatabaseWriterFilter> filters, boolean binaryCopyModeEnabled) {
        super(symmetricPlatform, targetPlatform, tablePrefix, settings);
        this.b = maxRowsBeforeFlush;
        this.writerSettings.setDatabaseWriterFilters(filters);
        this.d = binaryCopyModeEnabled;
    }

    protected long a() {
        if (this.e == null) {
            return 0L;
        }
        return this.e.e();
    }

    public void start(Batch batch) {
        super.start(batch);
        Statistics batchStats = batch.getStatistics();
        long totalRowCount = -1L;
        long insertRowCount = -1L;
        String batchInfo = "batch=" + batch.getBatchId();
        if (batchStats != null) {
            totalRowCount = batch.getStatistics().get("DATA_ROW_COUNT");
            insertRowCount = batch.getStatistics().get("DATA_INSERT_ROW_COUNT");
            if (insertRowCount < 10L) {
                this.context.put("bulkWriterToUse", (Object)"default");
                f.debug("Switching from bulk to default mode, because batch contains too few rows to allocate resources to PGCOPY stream. InsertRowCount={}, Minimum={}, {}", new Object[]{insertRowCount, 10L, batchInfo});
            } else if (!this.isFallBackToDefault()) {
                this.context.put("bulkWriterToUse", (Object)"bulk");
                f.debug("Operating in bulk mode. InsertRowCount={}, Minimum={}, {}", new Object[]{insertRowCount, 10L, batchInfo});
            }
        }
        this.c = this.a(batch);
        if (f.isDebugEnabled()) {
            f.debug("Starting import of batch. DataRowCount={}; InsertRowCount={}; UnwrapBinaryEncoding={}; BinaryCopyModeEnabled={}, {}", new Object[]{totalRowCount, insertRowCount, this.c, this.d, batchInfo});
        }
    }

    public boolean start(Table table) {
        return super.start(table);
    }

    public void end(Table table) {
        try {
            this.c();
        }
        catch (Exception ex2) {
            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
        }
        finally {
            super.end(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Batch batch, boolean inError) {
        if (inError) {
            f.debug("Ending load of batch {}, inError={}", (Object)batch.getBatchId(), (Object)inError);
            ((Statistics)this.statistics.get(batch)).set("STATEMENTCOUNT", 0L);
            ((Statistics)this.statistics.get(batch)).set("LINENUMBER", 0L);
            try {
                if (this.e != null) {
                    this.e.d();
                }
            }
            catch (SQLException ex2) {
                f.error("Ignoring secondary error while terminating failed batch " + batch.getBatchId(), (Throwable)ex2);
            }
            finally {
                this.e = null;
            }
        }
        super.end(batch, inError);
    }

    protected boolean a(Batch batch) {
        if (batch.getBinaryEncoding() != BinaryEncoding.NONE && this.targetTable != null) {
            for (Column column : this.targetTable.getColumns()) {
                if (!column.isOfBinaryType()) continue;
                return true;
            }
        }
        return false;
    }

    protected void bulkWrite(CsvData data) {
        if (this.filterBefore(data)) {
            ((Statistics)this.statistics.get(this.batch)).startTimer("LOADMILLIS");
            DataEventType dataEventType = data.getDataEventType();
            if (this.targetTable != null || dataEventType == DataEventType.CREATE || dataEventType == DataEventType.SQL) {
                switch (dataEventType) {
                    case INSERT: {
                        try {
                            long loadedRows = this.b(data);
                            if (loadedRows < (long)this.b) break;
                            f.trace("Flushing PGCOPY stream. Row={}, MaxRows={}", (Object)loadedRows, (Object)this.b);
                            this.c();
                            break;
                        }
                        catch (Exception e2) {
                            f.error("Failed to write row to PGCOPY for batch=" + this.getBatch().getBatchId(), (Throwable)e2);
                            Throwable t2 = e2.getCause();
                            if (null != t2) {
                                throw new r(t2);
                            }
                            throw new r(e2);
                        }
                    }
                    default: {
                        try {
                            this.c();
                        }
                        catch (Exception ex2) {
                            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                        }
                        f.info("Switching from bulk to default mode, because DELETE-type rows were detected. batch=" + this.getBatch().getBatchId());
                        this.context.put("bulkWriterToUse", (Object)"default");
                        super.write(data);
                    }
                }
            }
            ((Statistics)this.statistics.get(this.batch)).stopTimer("LOADMILLIS");
            ((Statistics)this.statistics.get(this.batch)).increment("STATEMENTCOUNT");
            ((Statistics)this.statistics.get(this.batch)).increment("LINENUMBER");
            this.filterAfter(data);
        }
    }

    protected String[] a(CsvData data) {
        try {
            String[] parsedData = this.getRowData(data, "rowData");
            if (this.c) {
                Column[] columns = this.targetTable.getColumns();
                for (int i2 = 0; i2 < columns.length; ++i2) {
                    if (!columns[i2].isOfBinaryType() || parsedData[i2] == null) continue;
                    if (this.batch.getBinaryEncoding() == BinaryEncoding.HEX) {
                        parsedData[i2] = this.a(Hex.decodeHex((char[])parsedData[i2].toCharArray()));
                        continue;
                    }
                    if (this.batch.getBinaryEncoding() != BinaryEncoding.BASE64) continue;
                    parsedData[i2] = this.a(Base64.decodeBase64((byte[])parsedData[i2].getBytes(Charset.defaultCharset())));
                }
            }
            return parsedData;
        }
        catch (Exception ex2) {
            f.error("parseRowData - Failed to parse incoming data for batch " + this.batch.getBatchId(), (Throwable)ex2);
            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long b(CsvData data) {
        try {
            String[] parsedData = this.a(data);
            if (parsedData == null) {
                f.warn("parseAndStreamRow - Data for incoming batch did not get parsed (null). Batch={}; Table={}", (Object)this.batch.getBatchId(), (Object)this.targetTable.getName());
                return this.a();
            }
            Column[] columns = this.targetTable.getColumns();
            if (columns.length != parsedData.length) {
                f.error(String.format("parseAndStreamRow - Data for incoming batch %d has wrong number of columns (%d) as compared to (%d) the target table (%s.%s) ", this.batch.getBatchId(), parsedData.length, columns.length, this.targetTable.getSchema(), this.targetTable.getName()));
            }
            if (this.e == null) {
                this.b();
            }
            return this.e.a(columns, parsedData);
        }
        catch (Exception ex2) {
            long currentRowNo = 0L;
            if (this.e != null) {
                currentRowNo = this.e.e();
            }
            String batchInfo = String.format("incoming batch=%d, table=%s, rowNo=%d", this.batch.getBatchId(), this.targetTable.getFullyQualifiedTableName(), currentRowNo);
            if (this.d && ex2 instanceof r && ex2.getMessage().startsWith("Unsupported PostgreSQL column type")) {
                f.warn("Binary PGCOPY mode does not support a column type found in " + batchInfo + ", Details=" + ex2.getMessage());
            } else {
                f.error("PGCOPY had failed for " + batchInfo, (Throwable)ex2);
            }
            try {
                if (this.e != null) {
                    this.e.d();
                }
            }
            catch (SQLException e2) {
                f.error("Detected SQLException while cancelling PGCOPY for " + batchInfo, (Throwable)e2);
                if (this.d) {
                    f.warn("Skipping binary mode downgrade due to new SQLException while cancelling binary data stream for " + batchInfo);
                    throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
                }
            }
            finally {
                this.e = null;
            }
            if (this.d) {
                boolean switchToTextMode = false;
                if (ex2 instanceof r && ex2.getMessage().contains("Unsupported PostgreSQL timestamp value")) {
                    f.info("Switching PGCOPY mode from binary to text (and re-trying this batch) due to unsupported timestamp value in " + batchInfo + ", Details=" + ex2.getMessage());
                    switchToTextMode = true;
                } else if (currentRowNo <= 1L) {
                    if (ex2 instanceof r && ex2.getMessage().startsWith("Unsupported PostgreSQL column type")) {
                        f.info("Switching PGCOPY mode from binary to text (and re-trying this batch) due to unsupported column type in " + batchInfo + ", Details=" + ex2.getMessage());
                    } else {
                        f.warn("Downgrading PGCOPY mode from binary to text (and re-trying this batch) due to exception for the first row in " + batchInfo, (Throwable)ex2);
                    }
                    switchToTextMode = true;
                }
                if (switchToTextMode) {
                    this.d = false;
                    return this.b(data);
                }
            }
            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
        }
    }

    public void open(DataContext context) {
        super.open(context);
    }

    protected void b() {
        JdbcSqlTransaction currentTransaction = (JdbcSqlTransaction)this.getTargetTransaction();
        Object batchInfo = String.format("batch=%d, BinaryMode=%b, Table=%s", this.batch.getBatchId(), this.d, this.targetTable.getFullyQualifiedTableName());
        try {
            String savePointName = String.format("sym_pgcopyin_%s_%d", this.d ? "bin" : "csv", this.batch.getBatchId());
            batchInfo = (String)batchInfo + ", Savepoint=" + savePointName;
            f.debug("Setting up PGCOPY stream for " + (String)batchInfo);
            currentTransaction.commit();
            DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
            this.e = new t(currentTransaction, this.targetTable, dbInfo, this.d, savePointName);
            f.info("Initalized PGCOPY stream for " + (String)batchInfo);
        }
        catch (Exception ex2) {
            f.error("startCopyCommand - error for " + (String)batchInfo, (Throwable)ex2);
            this.e = null;
            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
        }
    }

    protected void c() {
        if (this.e == null) {
            return;
        }
        String batchInfo = String.format("batch=%d, BinaryMode=%b, Table=%s, Rows=%d, Rows per second=%.1f", this.batch.getBatchId(), this.d, this.targetTable.getName(), this.e.e(), this.e.b());
        try {
            f.trace("Closing PGCOPY stream for {}", (Object)batchInfo);
            this.e.close();
            f.info("Closed PGCOPY stream and committed data for {}", (Object)batchInfo);
        }
        catch (Exception ex2) {
            f.error("Error while closing PGCOPY and committing data for " + batchInfo, (Throwable)ex2);
            ((Statistics)this.statistics.get(this.batch)).set("STATEMENTCOUNT", 0L);
            ((Statistics)this.statistics.get(this.batch)).set("LINENUMBER", 0L);
            throw this.getPlatform().getSqlTemplate().translate((Throwable)ex2);
        }
        finally {
            this.e = null;
        }
    }

    protected String a(byte[] byteData) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : byteData) {
            int i2 = b2 & 0xFF;
            if (i2 >= 0 && i2 <= 7) {
                sb.append("\\00").append(Integer.toString(i2, 8));
                continue;
            }
            if (i2 >= 8 && i2 <= 31) {
                sb.append("\\0").append(Integer.toString(i2, 8));
                continue;
            }
            if (i2 == 92 || i2 >= 127) {
                sb.append("\\").append(Integer.toString(i2, 8));
                continue;
            }
            sb.append(Character.toChars(i2));
        }
        return sb.toString();
    }
}

