/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.db.bulk;

import com.jumpmind.symmetric.console.impl.hh;
import com.jumpmind.symmetric.db.bulk.q;
import com.jumpmind.symmetric.db.bulk.r;
import com.jumpmind.symmetric.db.bulk.s;
import com.jumpmind.symmetric.db.bulk.u;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class t
implements AutoCloseable {
    private static final Logger j = LoggerFactory.getLogger((String)new hh(new long[]{7629626168067822750L, 2898884396115344083L, 7304595917969517255L, -3909606313850973759L, -4435369658792549291L, 4585975259294667062L, -2532973317261900846L, -4205191722432087439L}).toString());
    public static final String a = "Unsupported PostgreSQL column type";
    public static final String b = "Unsupported PostgreSQL timestamp value";
    private s k;
    protected final boolean c;
    protected final int d;
    private long l;
    protected CopyIn e;
    protected CopyManager f;
    private final byte[] m = this.l();
    private final long n = System.currentTimeMillis();
    private long o;
    private JdbcSqlTransaction p;
    private String q;
    private boolean r = false;
    public static final String g = "savepoint ";
    public static final String h = "rollback to savepoint ";
    public static final String i = "release savepoint ";

    public t(JdbcSqlTransaction copyTransaction, Table targetTable, DatabaseInfo dbInfo, boolean binaryCopyModeOn, String savePointName) throws SQLException, IOException {
        this.a(copyTransaction);
        this.p = copyTransaction;
        this.c = binaryCopyModeOn;
        this.d = 21845;
        this.o = 0L;
        this.l = 0L;
        this.q = savePointName == null ? "symcopyin" : savePointName;
        Connection connection = copyTransaction.getConnection();
        this.r = connection.getAutoCommit();
        if (this.r) {
            j.info("Switching current connection's AutoCommit mode to false because PostgreSQL does not support SAVEPOINTs on auto-committed transactions. SavePoint=" + this.q);
            connection.setAutoCommit(false);
        }
        PgConnection pgConnection = connection.unwrap(PgConnection.class);
        this.f = new CopyManager((BaseConnection)pgConnection);
        this.g();
        String sql = t.a(targetTable, dbInfo, this.c);
        this.e = this.f.copyIn(sql);
        u passthroughStream = new u(this.e);
        if (binaryCopyModeOn) {
            this.k = new s(passthroughStream, this.d);
            this.k.c();
        } else {
            this.k = null;
        }
        j.debug(String.format("Initialized PGCOPY command and data stream. BinaryMode=%b, SavePoint=%s, MemoryBufferSize=%d, SQL=%s", this.c, this.q, this.d, sql));
    }

    public t(OutputStream debugOutputStream, boolean binaryCopyModeOn) throws FileNotFoundException, SQLException {
        this.c = true;
        this.d = 21845;
        this.o = 0L;
        this.l = 0L;
        this.e = null;
        this.f = null;
        String sql = "COPY TEST!";
        if (binaryCopyModeOn) {
            this.k = new s(debugOutputStream, this.d);
            this.k.c();
        } else {
            this.k = null;
        }
        j.warn(String.format("Initialized IN DEBUG mode PGCOPY command and data stream. BinaryMode=%b, MemoryBufferSize=%d, SQL=%s", this.c, this.d, sql));
    }

    private void g() {
        if (this.f == null) {
            return;
        }
        this.a(this.p);
        this.p.execute(g + this.q);
        j.debug("Created savepoint for PGCOPY. SavePoint={}", (Object)this.q);
    }

    private void h() throws SQLException {
        if (this.f == null) {
            return;
        }
        this.a(this.p);
        this.p.execute(i + this.q);
        this.p.commit();
        this.j();
        this.p = null;
        j.debug("Committed PGCOPY command and released savepoint={}", (Object)this.q);
    }

    private void i() throws SQLException {
        if (this.f == null) {
            return;
        }
        this.a(this.p);
        this.p.execute(h + this.q);
        this.p.rollback();
        this.j();
        this.p = null;
        j.debug("Rolledback PGCOPY command and savepoint={}", (Object)this.q);
    }

    private void j() throws SQLException {
        if (this.f == null || this.r) {
            return;
        }
        this.a(this.p);
        this.p.getConnection().setAutoCommit(this.r);
    }

    protected void a(JdbcSqlTransaction someTransaction) {
        if (someTransaction != null) {
            return;
        }
        throw new r("Encountered a null jdbcTransaction instance!");
    }

    public static String a(Table targetTable, DatabaseInfo dbInfo, boolean binaryCopyModeOn) {
        String quote = dbInfo.getDelimiterToken();
        String catalogSeparator = dbInfo.getCatalogSeparator();
        String schemaSeparator = dbInfo.getSchemaSeparator();
        Column[] columns = targetTable.getColumns();
        String qualifiedTableName = targetTable.getQualifiedTableName(quote, catalogSeparator, schemaSeparator);
        StringBuilder sql = new StringBuilder(qualifiedTableName.length() + columns.length * 20);
        sql.append("COPY ");
        sql.append(qualifiedTableName);
        sql.append("(");
        for (int columnNo = 0; columnNo < columns.length; ++columnNo) {
            Column column = columns[columnNo];
            String columnName = column.getName();
            if (StringUtils.isWhitespace((CharSequence)columnName)) {
                throw new r("generateCopyStament - Error: Column #" + columnNo + " has blank name (or whitespace)! Table=" + qualifiedTableName);
            }
            if (columnNo > 0) {
                sql.append(",");
            }
            sql.append(quote);
            sql.append(columnName);
            sql.append(quote);
            if (!j.isDebugEnabled()) continue;
            j.debug("generateCopyStament - Table=" + qualifiedTableName + ", Column #" + columnNo + " [" + column.getName() + "] , MappedTypeCode=" + column.getMappedTypeCode() + " , MappedType=" + column.getMappedType() + " , JdbcTypeCode=" + column.getJdbcTypeCode() + " , JdbcTypeName=" + column.getJdbcTypeName() + " , Size=" + column.getSize() + " , SizeAsInt=" + column.getSizeAsInt() + " , Scale=" + column.getScale() + " , PrecisionRadix=" + column.getPrecisionRadix());
        }
        sql.append(")");
        if (binaryCopyModeOn) {
            sql.append("FROM STDIN BINARY");
        } else {
            sql.append("FROM STDIN with delimiter ',' csv quote ''''");
        }
        return sql.toString();
    }

    public long a() {
        return this.o;
    }

    public double b() {
        long rowCount = this.l;
        long durationMillis = this.a();
        double rowsPerSecond = rowCount;
        if (durationMillis > 0L) {
            rowsPerSecond = (double)Math.round((double)rowCount * 10000.0 / (double)durationMillis) / 10.0;
        }
        return rowsPerSecond;
    }

    public long c() {
        return this.o / 1000L;
    }

    @Override
    public void close() throws SQLException {
        this.o = System.currentTimeMillis() - this.n;
        this.k();
    }

    private void k() {
        try {
            if (this.e != null) {
                if (this.e.isActive()) {
                    if (this.l > 0L) {
                        if (this.k != null) {
                            this.k.close();
                        }
                        this.e.endCopy();
                        this.e = null;
                        this.h();
                        j.trace("Closed PGCOPY stream and committed {} rows", (Object)this.l);
                    } else {
                        if (this.k != null) {
                            this.k.d();
                        }
                        this.e.cancelCopy();
                        this.e = null;
                        this.h();
                        j.warn("Cancelled PGCOPY operation, because there were zero data rows to send!");
                    }
                }
            } else if (this.k != null) {
                this.k.close();
            }
        }
        catch (Exception ex2) {
            Throwable t2 = ex2.getCause();
            this.b(false);
            if (null != t2) {
                throw new r(t2);
            }
            throw new r(ex2);
        }
        finally {
            this.k = null;
            this.e = null;
            this.l = -1L;
            this.f = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(boolean throwErrors) {
        try {
            if (this.k != null) {
                this.k.d();
                this.k = null;
            }
            if (this.e != null) {
                if (this.e.isActive()) {
                    this.e.cancelCopy();
                }
                this.e = null;
                this.i();
            }
        }
        catch (Exception ex2) {
            j.error("Error while cancelling PGCOPY operation", (Throwable)ex2);
            if (throwErrors) {
                Throwable t2 = ex2.getCause();
                if (null != t2) {
                    throw new r(t2);
                }
                throw new r(ex2);
            }
        }
        finally {
            this.k = null;
            this.e = null;
            this.l = -1L;
            this.f = null;
        }
    }

    public long d() throws SQLException {
        long rowNo = this.l;
        this.b(true);
        return rowNo;
    }

    public long e() {
        return this.l;
    }

    public long a(int columnCount) {
        ++this.l;
        if (this.c) {
            this.k.a(columnCount);
        }
        this.o = System.currentTimeMillis() - this.n;
        if (this.c && j.isTraceEnabled()) {
            long byteCount = this.k.a() + 4L;
            j.trace(String.format("Wrote header for data row number %d with %d columns, Stream.size=%d, BinaryMode=%b, TotalDuration.ms=%d", this.l, columnCount, byteCount, this.c, this.o));
        }
        return this.l;
    }

    public void f() {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.e();
    }

    protected Boolean a(String strValue, Column column) {
        if (!this.c) {
            j.debug("Received request to check column {}, but copy mode is not Binary!", (Object)column.getName());
            throw new r("Unsupported when BinaryMode is OFF");
        }
        if (strValue == null || strValue.length() < 1) {
            if (column.isRequired()) {
                j.warn("There was no value provided for column {}, but this column does not allow NULLs!", (Object)column.getName());
                throw new r("Empty value (NULL) is not allowed for column " + column.getName());
            }
            this.k.e();
            return true;
        }
        return false;
    }

    public void b(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        long value = Long.parseLong(strValue);
        this.k.a(value);
    }

    public void a(long value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(value);
    }

    private byte[] l() {
        byte[] bitValues = new byte[]{0, 0, 0, 1, 0};
        return bitValues;
    }

    public void c(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        this.a(strValue, column.getSizeAsInt());
    }

    public void a(String values, int numBits) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        if (numBits > 1 || numBits < 0) {
            throw new r("Too many bits in the column. Unsupported BIT(N) column size (" + numBits + ") fow row #" + this.l);
        }
        if (values == null || values.length() != numBits) {
            throw new r("Empty or invalid number of character-bit values. Expected, per column size " + numBits + " fow row #" + this.l);
        }
        int valueByte = values.charAt(0) == '1' ? 1 : 0;
        this.m[4] = (byte)((valueByte & 1) << 7);
        this.k.a(this.m);
    }

    public void d(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        Boolean bValue = "1".equals(strValue) || Boolean.parseBoolean(strValue);
        this.k.a(bValue);
    }

    public void a(boolean value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(value);
    }

    public void e(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        int maxLength = column.getSizeAsInt();
        if (maxLength < 0) {
            throw new r("Invalid max length provided for VARCHAR (" + maxLength + ") fow row #" + this.l);
        }
        int valueLength = strValue.length();
        if (valueLength > maxLength) {
            throw new r("Length of provided value exceeds column size (" + valueLength + "> CHAR " + maxLength + ") fow row #" + this.l);
        }
        if (valueLength == maxLength) {
            this.k.a(strValue);
        } else {
            String paddedValue = strValue + " ".repeat(maxLength - valueLength);
            this.k.a(paddedValue);
        }
    }

    public void f(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        int maxLength = column.getSizeAsInt();
        if (maxLength < 0) {
            throw new r("Invalid max length provided for VARCHAR (" + maxLength + ") fow row #" + this.l);
        }
        int valueLength = strValue.length();
        if (maxLength > 0 && valueLength > maxLength) {
            throw new r("Length of provided value exceeds column size (" + valueLength + "> VARCHAR " + maxLength + ") fow row #" + this.l);
        }
        this.k.a(strValue);
    }

    public void g(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        this.k.a(strValue);
    }

    public void h(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        LocalDateTime value = com.jumpmind.symmetric.db.bulk.q.b(strValue);
        this.a(value);
    }

    public void a(LocalDateTime value) {
        int postgresDays = com.jumpmind.symmetric.db.bulk.q.a(value);
        this.b(postgresDays);
    }

    public void b(int postgresDays) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.d(postgresDays);
    }

    public void a(LocalDate value) {
        this.a(value.atStartOfDay());
    }

    public void i(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        int value = Integer.parseInt(strValue);
        this.k.d(value);
    }

    public void c(int value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.d(value);
    }

    public void j(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        this.k.a(strValue);
    }

    public void a(String strValue, byte jsonVersion, Column column) {
        int valueLength;
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        int n2 = valueLength = strValue == null ? 0 : strValue.length();
        if (valueLength < 1) {
            this.k.e();
            return;
        }
        byte[] jsonBytes = com.jumpmind.symmetric.db.bulk.q.a(strValue, jsonVersion);
        this.k.a(jsonBytes);
    }

    public void k(String strValue, Column column) throws IOException {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        BigDecimal value = new BigDecimal(strValue);
        this.a(value, column.getSizeAsInt(), column.getScale());
    }

    public void a(BigDecimal value, int colPrecision, int colScale) throws IOException {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        int valPrecision = value.precision();
        int valScale = value.scale();
        if (colPrecision > 1 && valPrecision > colPrecision) {
            throw new r("Precision of provided value exceeds column precision (" + valPrecision + " > " + colPrecision + ") for value " + String.valueOf(value) + " in row #" + this.l);
        }
        if (colScale > 1 && valScale > colScale) {
            throw new r("Scale of provided value exceeds column scale (" + valScale + " > " + colScale + ") for value " + String.valueOf(value) + " in row #" + this.l);
        }
        this.k.a(value);
    }

    public void a(double value, int colPrecision, int colScale) throws IOException {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        BigDecimal decimalValue = BigDecimal.valueOf(value);
        int valPrecision = decimalValue.precision();
        int valScale = decimalValue.scale();
        if (colPrecision > 0 && valPrecision > colPrecision) {
            throw new r("Precision of provided value exceeds column precision (" + valPrecision + " > " + colPrecision + ") for value " + value + " (in decimal=" + String.valueOf(decimalValue) + ") in row #" + this.l);
        }
        if (valScale > colScale) {
            throw new r("Scale of provided value exceeds column scale (" + valScale + " > " + colScale + ") for value " + value + " (in decimal=" + String.valueOf(decimalValue) + ") in row #" + this.l);
        }
        this.k.a(decimalValue);
    }

    public void l(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        float value = Float.valueOf(strValue).floatValue();
        this.k.a(value);
    }

    public void a(float value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(value);
    }

    public void m(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        int value = Integer.parseInt(strValue);
        this.d(value);
    }

    public void d(int value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        if (value < Short.MIN_VALUE) {
            throw new r("Incoming value is too small for a SMALLINT column (" + value + "<-32768)");
        }
        if (value > Short.MAX_VALUE) {
            throw new r("Incoming value is too large for a SMALLINT column (" + value + ">32767)");
        }
        this.k.c(value);
    }

    public void a(String value) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(value);
    }

    public void n(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        try {
            LocalDateTime value = com.jumpmind.symmetric.db.bulk.q.c(strValue);
            this.b(value);
        }
        catch (Exception ex2) {
            j.error("writeTime - Failed to parse LocalDateTime text=" + strValue, (Throwable)ex2);
            Throwable t2 = ex2.getCause();
            if (null != t2) {
                throw new r(t2);
            }
            throw new r(ex2);
        }
    }

    public void b(LocalDateTime value) {
        long postgresMicroSeconds = com.jumpmind.symmetric.db.bulk.q.b(value);
        this.b(postgresMicroSeconds);
    }

    public void b(long postgresMicroSeconds) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(postgresMicroSeconds);
    }

    public void o(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        try {
            LocalDateTime value = com.jumpmind.symmetric.db.bulk.q.d(strValue);
            this.c(value);
        }
        catch (Exception ex2) {
            j.error("writeTimestamp - Failed to parse LocalDateTime text=" + strValue, (Throwable)ex2);
            Throwable t2 = ex2.getCause();
            if (null != t2) {
                throw new r(t2);
            }
            throw new r(ex2);
        }
    }

    public void c(LocalDateTime value) {
        long postgresMicroSeconds = com.jumpmind.symmetric.db.bulk.q.b(value);
        this.c(postgresMicroSeconds);
    }

    public void c(long postgresMicroSeconds) {
        if (!this.c) {
            throw new r("Unsupported when BinaryMode is OFF");
        }
        this.k.a(postgresMicroSeconds);
    }

    public void p(String strValue, Column column) {
        if (this.a(strValue, column).booleanValue()) {
            return;
        }
        try {
            ZonedDateTime value = com.jumpmind.symmetric.db.bulk.q.e(strValue);
            this.a(value);
        }
        catch (Exception ex2) {
            j.error("writeTimestampWithTimeZone - Failed to parse ZonedDateTime text=" + strValue, (Throwable)ex2);
            Throwable t2 = ex2.getCause();
            if (null != t2) {
                throw new r(t2);
            }
            throw new r(ex2);
        }
    }

    public void a(ZonedDateTime value) {
        long postgresMicroSeconds = com.jumpmind.symmetric.db.bulk.q.a(value);
        this.c(postgresMicroSeconds);
    }

    private long b(Column[] columns, String[] parsedData) throws IOException {
        if (columns.length != parsedData.length || columns.length < 1) {
            throw new r("Incoming data has wrong number of columns (" + parsedData.length + ") compared to the target table (" + columns.length + ")!");
        }
        long currRowNumber = this.a(columns.length);
        for (int i2 = 0; i2 < columns.length; ++i2) {
            Column column = columns[i2];
            String strValue = parsedData[i2];
            this.a(column, strValue);
        }
        if (j.isTraceEnabled()) {
            j.trace("Done writing row of binary data. RowNumber={}, Column.count={}, Stream.size={}", new Object[]{currRowNumber, columns.length, this.k.b()});
        }
        return currRowNumber;
    }

    private void a(Column column, String strValue) throws IOException {
        String jdbcTypeName = column.getJdbcTypeName();
        int mappedTypeCode = column.getMappedTypeCode();
        switch (mappedTypeCode) {
            case -5: {
                this.b(strValue, column);
                break;
            }
            case -1: {
                if (jdbcTypeName.equals("jsonb")) {
                    this.a(strValue, (byte)1, column);
                    break;
                }
                if (jdbcTypeName.equals("json")) {
                    this.j(strValue, column);
                    break;
                }
                this.g(strValue, column);
                break;
            }
            case 1: {
                this.e(strValue, column);
                break;
            }
            case 2: {
                this.k(strValue, column);
                break;
            }
            case 4: {
                this.i(strValue, column);
                break;
            }
            case 5: {
                this.m(strValue, column);
                break;
            }
            case 12: {
                if (column.getJdbcTypeCode() == -7) {
                    this.c(strValue, column);
                    break;
                }
                this.f(strValue, column);
                break;
            }
            case 7: {
                this.l(strValue, column);
                break;
            }
            case 16: {
                this.d(strValue, column);
                break;
            }
            case 91: {
                this.h(strValue, column);
                break;
            }
            case 92: {
                this.n(strValue, column);
                break;
            }
            case 93: {
                this.o(strValue, column);
                break;
            }
            case -101: {
                this.p(strValue, column);
                break;
            }
            default: {
                String err = String.format("%s! Column=%s, MappedTypeCode=%d, MappedType=%s, JdbcTypeName=%s, Value=%s", a, column.getName(), column.getMappedTypeCode(), column.getMappedType(), jdbcTypeName, strValue);
                throw new r(err);
            }
        }
    }

    private long c(Column[] columns, String[] parsedData) throws SQLException {
        long currRowNumber = this.a(columns.length);
        String formattedRowData = CsvUtils.escapeCsvData((String[])parsedData, (char)'\n', (char)'\'', (int)1);
        formattedRowData = this.b(formattedRowData);
        byte[] textDataToLoad = com.jumpmind.symmetric.db.bulk.q.a(formattedRowData);
        if (this.k == null) {
            this.e.writeToCopy(textDataToLoad, 0, textDataToLoad.length);
        } else {
            this.k.a(textDataToLoad);
        }
        if (j.isTraceEnabled()) {
            j.trace("Done writing row of csv data. RowNumber={}, ColumnCount={}", (Object)currRowNumber, (Object)columns.length);
        }
        return currRowNumber;
    }

    protected String b(String formattedData) {
        StringBuilder buff = new StringBuilder(formattedData.length());
        for (char c2 : formattedData.toCharArray()) {
            if (c2 <= '\u0000') continue;
            buff.append(c2);
        }
        return buff.toString();
    }

    public long a(Column[] columns, String[] parsedData) throws SQLException, IOException {
        if (this.c) {
            return this.b(columns, parsedData);
        }
        return this.c(columns, parsedData);
    }
}

