/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.c;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.service.FilterCriterion;
import org.jumpmind.vaadin.ui.common.Label;

public class t
extends c {
    private static final long serialVersionUID = 1L;
    private I controller;
    private Select<FilterCriterion.FilterOption> options;
    private DateTimePicker startDateTimePicker;
    private DateTimePicker endDateTimePicker;
    private Date startDate;
    private Date endDate;
    private Binder<LocalDateTime> startBinder;
    private boolean startBinderValid = false;
    private Binder<LocalDateTime> endBinder;
    private boolean endBinderValid = false;

    public t(I controller, String propertyId) {
        this.setSpacing(true);
        this.controller = controller;
        this.propertyId = propertyId;
        this.title = StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)propertyId), (String)" "));
        this.titleLabel = new Label("<b>" + this.title + "</b>");
        this.titleLabel.setWidth("100px");
        this.titleLabel.getStyle().set("margin-top", "8px");
        this.add(new Component[]{this.titleLabel});
        ArrayList<FilterCriterion.FilterOption> optionList = new ArrayList<FilterCriterion.FilterOption>();
        optionList.add(FilterCriterion.FilterOption.GREATER);
        optionList.add(FilterCriterion.FilterOption.GREATER_EQUAL);
        optionList.add(FilterCriterion.FilterOption.LESS);
        optionList.add(FilterCriterion.FilterOption.LESS_EQUAL);
        optionList.add(FilterCriterion.FilterOption.BETWEEN);
        this.options = new Select();
        this.options.setItems(optionList);
        this.options.setEmptySelectionAllowed(false);
        this.options.setValue((Object)FilterCriterion.FilterOption.GREATER);
        this.options.setWidth("200px");
        this.add(new Component[]{this.options});
        this.startBinder = new Binder();
        this.startDateTimePicker = new DateTimePicker();
        this.startDateTimePicker.setDatePlaceholder("Date");
        this.startDateTimePicker.setTimePlaceholder("Time");
        this.startDateTimePicker.setStep(Duration.ofMinutes(1L));
        this.startDateTimePicker.setLocale(new Locale("sv", "AX"));
        this.startDateTimePicker.setWidth("400px");
        this.startBinder.forField((HasValue)this.startDateTimePicker).asRequired("Please Enter a Date").withValidator((SerializablePredicate & Serializable)value -> {
            if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                if (this.startDateTimePicker.getValue() != null && this.endDateTimePicker.getValue() != null) {
                    this.updateDate();
                    this.startBinderValid = this.startDate.compareTo(this.endDate) < 0;
                } else {
                    this.startBinderValid = true;
                }
            } else {
                this.startBinderValid = true;
            }
            if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN) && this.startBinderValid != this.endBinderValid) {
                this.endBinder.validate();
            }
            return this.startBinderValid;
        }, "Please Enter a Valid Date Range").bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
            value = newValue;
        });
        this.startDateTimePicker.setRequiredIndicatorVisible(false);
        ArrayList<Integer> hours = new ArrayList<Integer>();
        ArrayList<Integer> minutes = new ArrayList<Integer>();
        for (int h2 = 0; h2 < 24; ++h2) {
            hours.add(h2);
        }
        for (int m2 = 0; m2 < 60; ++m2) {
            minutes.add(m2);
        }
        this.endBinder = new Binder();
        this.endDateTimePicker = new DateTimePicker();
        this.endDateTimePicker.setDatePlaceholder("End Date");
        this.endDateTimePicker.setTimePlaceholder("End Time");
        this.endDateTimePicker.setStep(Duration.ofMinutes(1L));
        this.endDateTimePicker.setVisible(false);
        this.endDateTimePicker.setLocale(new Locale("sv", "AX"));
        this.endDateTimePicker.setWidth("400px");
        this.endBinder.forField((HasValue)this.endDateTimePicker).asRequired("Please Enter a Date").withValidator((SerializablePredicate & Serializable)value -> {
            if (this.startDateTimePicker.getValue() != null && this.endDateTimePicker.getValue() != null) {
                this.updateDate();
                this.endBinderValid = this.startDate.compareTo(this.endDate) < 0;
            } else {
                this.endBinderValid = true;
            }
            if (this.startBinderValid != this.endBinderValid) {
                this.startBinder.validate();
            }
            return this.endBinderValid;
        }, "Please Enter a Valid Date Range").bind((ValueProvider & Serializable)value -> value, (Setter & Serializable)(value, newValue) -> {
            value = newValue;
        });
        this.endDateTimePicker.setRequiredIndicatorVisible(false);
        this.endDateTimePicker.setVisible(false);
        VerticalLayout pickerLayout = new VerticalLayout(new Component[]{this.startDateTimePicker, this.endDateTimePicker});
        pickerLayout.setWidth(null);
        pickerLayout.setPadding(false);
        this.add(new Component[]{pickerLayout});
        this.options.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((FilterCriterion.FilterOption)event.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                this.endDateTimePicker.setVisible(true);
                this.startDateTimePicker.setDatePlaceholder("Start Date");
                this.startDateTimePicker.setTimePlaceholder("Start Time");
                if (this.endDateTimePicker.getValue() != null) {
                    this.endBinder.validate();
                }
            } else {
                this.endDateTimePicker.setVisible(false);
                this.startDateTimePicker.setDatePlaceholder("Date");
                this.startDateTimePicker.setTimePlaceholder("Time");
                if (this.startDateTimePicker.getValue() != null) {
                    this.startBinder.validate();
                }
            }
            this.startDateTimePicker.setRequiredIndicatorVisible(false);
        });
        this.add(new Component[]{this.applyButton});
    }

    @Override
    public void onFilterApplied() {
        if (this.startDateTimePicker.getValue() == null) {
            this.startDateTimePicker.setRequiredIndicatorVisible(true);
        }
        if (this.endDateTimePicker.getValue() == null) {
            this.endDateTimePicker.setRequiredIndicatorVisible(true);
        }
        if (this.startBinder.validate().isOk() & (!((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN) || this.endBinder.validate().isOk())) {
            FilterCriterion filterCriterion = new FilterCriterion();
            filterCriterion.setPropertyId(this.propertyId);
            ArrayList<Date> values = new ArrayList<Date>();
            this.startDate = as.convertInputDateToUTC(this.controller, (LocalDateTime)this.startDateTimePicker.getValue());
            values.add(this.startDate);
            if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
                this.endDate = as.convertInputDateToUTC(this.controller, (LocalDateTime)this.endDateTimePicker.getValue());
                values.add(this.endDate);
            }
            filterCriterion.setValues(values);
            filterCriterion.setOption((FilterCriterion.FilterOption)this.options.getValue());
            this.window.applyFilter(filterCriterion);
        }
        this.startDateTimePicker.setRequiredIndicatorVisible(false);
        this.endDateTimePicker.setRequiredIndicatorVisible(false);
    }

    private void updateDate() {
        this.startDate = Date.from(((LocalDateTime)this.startDateTimePicker.getValue()).atZone(ZoneId.systemDefault()).toInstant());
        if (((FilterCriterion.FilterOption)this.options.getValue()).equals((Object)FilterCriterion.FilterOption.BETWEEN)) {
            this.endDate = Date.from(((LocalDateTime)this.endDateTimePicker.getValue()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }
}

