/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.B;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.jumpmind.vaadin.ui.common.CustomSplitLayout;
import org.jumpmind.vaadin.ui.common.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ao
extends VerticalLayout
implements B {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected I controller;
    protected String descriptionKey;
    protected VerticalLayout content;
    protected FlexLayout buttonLayout;
    protected CustomSplitLayout hsplit;
    protected Label helpTextLabel;
    protected Button helpButton;
    protected double lastSplitPosition;

    public ao(I controller, String titleKey, String descriptionKey) {
        this.controller = controller;
        this.descriptionKey = descriptionKey;
        this.setSizeFull();
        this.setSpacing(true);
        if (titleKey != null) {
            this.add(new Component[]{as.createSubHeader(controller, titleKey)});
        }
        this.buttonLayout = new FlexLayout();
        this.buttonLayout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        this.buttonLayout.getElement().setAttribute("theme", "spacing");
        this.buttonLayout.setWidthFull();
        this.addButtonsLeft(this.buttonLayout);
        Span spacer = new Span();
        this.buttonLayout.add(new Component[]{spacer});
        this.buttonLayout.expand(new Component[]{spacer});
        this.addButtonsRight(this.buttonLayout);
        this.add(new Component[]{this.buttonLayout});
        this.hsplit = new CustomSplitLayout();
        this.addAndExpand(new Component[]{this.hsplit});
        String caption = StringUtils.isBlank((CharSequence)this.getTitleKey()) ? "" : controller.getMessage(this.getTitleKey(), new Object[0]);
        Scroller leftPanel = new Scroller();
        leftPanel.setClassName("form");
        leftPanel.setHeight("95%");
        VerticalLayout leftVert = new VerticalLayout();
        this.content = new VerticalLayout();
        leftVert.add(new Component[]{this.content});
        leftPanel.setContent((Component)this.content);
        this.hsplit.addToPrimary(new Component[]{new Span(caption), leftPanel});
        Scroller rightPanel = new Scroller();
        rightPanel.setHeight("95%");
        rightPanel.setClassName("help");
        VerticalLayout rightVert = new VerticalLayout();
        rightPanel.setContent((Component)rightVert);
        this.hsplit.addToSecondary(new Component[]{new Span("Help"), rightPanel});
        this.helpTextLabel = new Label();
        this.updateHelpTextLabel();
        rightVert.add(new Component[]{this.helpTextLabel});
    }

    public String getTitleKey() {
        return null;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getHelpSectionName() {
        return null;
    }

    protected void addButtonsLeft(FlexLayout buttonLayout) {
    }

    protected void addButtonsMiddle(FlexLayout buttonLayout) {
    }

    protected void addButtonsRight(FlexLayout buttonLayout) {
    }

    public void hideHelp() {
        this.lastSplitPosition = this.hsplit.getSplitterPosition();
        this.hsplit.setSplitterPosition(100.0);
        this.hsplit.setPrimaryStyle("min-width", "100%");
        if (this.helpButton != null) {
            this.helpButton.setText("Show Help");
        }
    }

    public void showHelp() {
        this.hsplit.setSplitterPosition(this.lastSplitPosition);
        this.hsplit.setPrimaryStyle("min-width", "0%");
        if (this.helpButton != null) {
            this.helpButton.setText("Hide Help");
        }
    }

    protected void updateHelpTextLabel() {
        as.passHelpHtmlToConsumer(this.getHelpSectionName(), html -> {
            this.helpTextLabel.setText(html);
            this.helpTextLabel.setWidthFull();
            if (StringUtils.isBlank((CharSequence)html) || this.controller.getSymmetricEngine() != null && !this.controller.getSymmetricEngine().getParameterService().is("console.help.show")) {
                this.hideHelp();
            }
            if (StringUtils.isNotBlank((CharSequence)html) && this.helpButton == null) {
                this.helpButton = as.createLinkButton("Hide Help", (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
                    if ("Hide Help".equals(this.helpButton.getText())) {
                        this.hideHelp();
                    } else {
                        this.showHelp();
                    }
                });
                this.buttonLayout.add(new Component[]{this.helpButton});
            }
        }, true);
    }

    protected void notification(String messageKey, Object ... args) {
        CommonUiUtils.notify((String)this.controller.getMessage(messageKey, args));
    }

    protected String message(String messageKey, Object ... args) {
        return this.controller.getMessage(messageKey, args);
    }

    public void applicationClosing() {
    }
}

