/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.an;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.job.IJob;

public class ah
extends an {
    private static final long serialVersionUID = 1L;
    private HasValue<?, String> runPeriodField;
    private Binder<String> binder;
    private TextField days;
    private Select<String> hours;
    private Select<String> minutes;
    private Select<String> seconds;
    private Span runPeriodSpan;

    public ah(I controller, HasValue<?, String> runPeriodField) {
        super(controller, "Run Period", new Object[0]);
        String runPeriod;
        this.runPeriodField = runPeriodField;
        this.setHeight("370px");
        this.setWidth("500px");
        this.setResizable(true);
        this.setCloseOnEsc(true);
        this.setCloseOnOutsideClick(true);
        this.cancelButton.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        String daysValue = "0";
        String hoursValue = "0";
        String minutesValue = "0";
        String secondsValue = "0";
        if (runPeriodField.getValue() != null && (runPeriod = ((String)runPeriodField.getValue()).replace(",", "")) != null && !StringUtils.isEmpty((CharSequence)runPeriod)) {
            long sec = Long.parseLong(runPeriod);
            daysValue = String.valueOf(sec / 86400L);
            hoursValue = String.valueOf((sec %= 86400L) / 3600L);
            minutesValue = String.valueOf((sec %= 3600L) / 60L);
            secondsValue = String.valueOf(sec %= 60L);
        }
        this.days.setValue(daysValue);
        this.hours.setValue((Object)hoursValue);
        this.minutes.setValue((Object)minutesValue);
        this.seconds.setValue((Object)secondsValue);
    }

    @Override
    protected void addComponentsToLayout(VerticalLayout layout) {
        layout.setSpacing(false);
        layout.getStyle().set("padding-top", "0");
        FormLayout formLayout = new FormLayout();
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        this.binder = new Binder(String.class);
        this.days = new TextField();
        this.days.setWidthFull();
        this.binder.forField((HasValue)this.days).asRequired(this.controller.getMessage("%s is required.", "Days")).withConverter((Converter)new StringToIntegerConverter(this.message("Days must be an integer."))).bind((ValueProvider & Serializable)value -> Integer.parseInt(value), (Setter & Serializable)(value, newValue) -> {
            value = String.valueOf(newValue);
        });
        this.days.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateSpan());
        NativeLabel daysLabel = new NativeLabel("Days");
        daysLabel.setClassName("required");
        formLayout.addFormItem((Component)this.days, (Component)daysLabel);
        ArrayList<String> hoursList = new ArrayList<String>();
        ArrayList<String> minutesSecondsList = new ArrayList<String>();
        for (int h2 = 0; h2 < 24; ++h2) {
            hoursList.add(String.valueOf(h2));
        }
        for (int ms = 0; ms < 60; ++ms) {
            minutesSecondsList.add(String.valueOf(ms));
        }
        this.hours = new Select();
        this.hours.setItems(hoursList);
        this.hours.setWidthFull();
        this.hours.setEmptySelectionAllowed(false);
        this.hours.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateSpan());
        NativeLabel hoursLabel = new NativeLabel("Hours");
        hoursLabel.setClassName("required");
        formLayout.addFormItem(this.hours, (Component)hoursLabel);
        this.minutes = new Select();
        this.minutes.setItems(minutesSecondsList);
        this.minutes.setWidthFull();
        this.minutes.setEmptySelectionAllowed(false);
        this.minutes.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateSpan());
        NativeLabel minutesLabel = new NativeLabel("Minutes");
        minutesLabel.setClassName("required");
        formLayout.addFormItem(this.minutes, (Component)minutesLabel);
        this.seconds = new Select();
        this.seconds.setItems(minutesSecondsList);
        this.seconds.setWidthFull();
        this.seconds.setEmptySelectionAllowed(false);
        this.seconds.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateSpan());
        NativeLabel secondsLabel = new NativeLabel("Seconds");
        secondsLabel.setClassName("required");
        formLayout.addFormItem(this.seconds, (Component)secondsLabel);
        layout.add(new Component[]{formLayout});
        this.runPeriodSpan = new Span();
        this.runPeriodSpan.setWidth("400px");
        layout.add(new Component[]{this.runPeriodSpan});
        layout.addAndExpand(new Component[]{new Span()});
    }

    @Override
    protected boolean apply() {
        if (this.binder.validate().isOk()) {
            Long runPeriod = Long.parseLong(this.days.getValue()) * 86400L + Long.parseLong((String)this.hours.getValue()) * 3600L + Long.parseLong((String)this.minutes.getValue()) * 60L + Long.parseLong((String)this.seconds.getValue());
            this.runPeriodField.setValue((Object)String.valueOf(runPeriod));
            this.applied = true;
            return true;
        }
        this.applied = false;
        return false;
    }

    protected void updateSpan() {
        if (this.binder.isValid() && !StringUtils.isEmpty((CharSequence)((CharSequence)this.hours.getValue())) && !StringUtils.isEmpty((CharSequence)((CharSequence)this.minutes.getValue())) && !StringUtils.isEmpty((CharSequence)((CharSequence)this.seconds.getValue()))) {
            IJob monitorJob = this.controller.getSymmetricEngine().getJobManager().getJob("Monitor");
            int jobPeriod = Integer.parseInt(monitorJob.getSchedule());
            Long monitorPeriod = Long.parseLong(this.days.getValue()) * 86400000L + Long.parseLong((String)this.hours.getValue()) * 3600000L + Long.parseLong((String)this.minutes.getValue()) * 60000L + Long.parseLong((String)this.seconds.getValue()) * 1000L;
            if (monitorPeriod <= (long)jobPeriod) {
                this.runPeriodSpan.setText("Runs every " + as.formatDurationFull(jobPeriod) + " with monitor job");
            } else {
                this.runPeriodSpan.setText("Runs every " + as.formatDurationFull((long)Math.ceil((double)monitorPeriod.longValue() / (double)jobPeriod) * (long)jobPeriod));
            }
        }
    }
}

