/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.common;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.ak;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ag
extends ak {
    private static final long serialVersionUID = 1L;
    private String routerId;
    private boolean showColumnNames;

    public ag(String title, String description, HasValue<?, String> formField, I controller, String routerId, boolean showColumnNames) {
        super(title, description, formField, controller);
        this.setCloseOnOutsideClick(false);
        this.routerId = routerId;
        this.showColumnNames = showColumnNames;
        this.fieldLayout.addComponentAsFirst((Component)this.generateMenuLayout());
    }

    protected HorizontalLayout generateMenuLayout() {
        HorizontalLayout menuLayout = new HorizontalLayout();
        MenuBar builtInVariableMenu = new MenuBar();
        MenuItem builtInVariables = builtInVariableMenu.addItem(this.controller.getMessage("Built-in Variables", new Object[0]));
        builtInVariables.add(new Component[]{as.getDropdownIcon()});
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(this.controller.getMessage(":DATA_EVENT_TYPE - String", new Object[0]));
        variables.add(this.controller.getMessage(":EXTERNAL_DATA - String", new Object[0]));
        variables.add(this.controller.getMessage(":NODE_GROUP_ID - String", new Object[0]));
        variables.add(this.controller.getMessage(":TABLE_NAME - String", new Object[0]));
        for (String variable : variables) {
            ((SubMenu)builtInVariables.getSubMenu()).addItem(variable, (ComponentEventListener & Serializable)event -> {
                String text = this.textField.getValue();
                MenuItem item = (MenuItem)event.getSource();
                String var = item.getText().substring(0, item.getText().indexOf(" "));
                if (text != null) {
                    this.textField.replaceTextAtCurrentSelection(var);
                } else {
                    this.textField.setValue(var);
                }
            });
        }
        menuLayout.add(new Component[]{builtInVariableMenu});
        if (this.showColumnNames) {
            MenuBar dataVariableMenu = new MenuBar();
            List<Object> commonColumnNames = new ArrayList();
            for (Object triggerRouter : this.controller.getSymmetricEngine().getTriggerRouterService().getTriggerRouters(true)) {
                if (!triggerRouter.getRouterId().equals(this.routerId)) continue;
                Trigger trigger = triggerRouter.getTrigger();
                Table table = this.controller.getSymmetricEngine().getDatabasePlatform().getDdlReader().readTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName());
                if (table != null) {
                    if (commonColumnNames.isEmpty()) {
                        commonColumnNames.addAll(Arrays.asList(table.getColumnNames()));
                        continue;
                    }
                    commonColumnNames.retainAll(Arrays.asList(table.getColumnNames()));
                    if (!commonColumnNames.isEmpty()) continue;
                    break;
                }
                commonColumnNames.clear();
                break;
            }
            ArrayList<CallSite> oldColumnNames = new ArrayList<CallSite>();
            for (String string : commonColumnNames) {
                oldColumnNames.add((CallSite)((Object)("OLD_" + string)));
            }
            commonColumnNames.addAll(oldColumnNames);
            commonColumnNames = commonColumnNames.stream().map(name -> ":" + name.toUpperCase()).collect(Collectors.toList());
            Collections.sort(commonColumnNames);
            MenuItem dataVariables = dataVariableMenu.addItem(this.controller.getMessage("Data Variables", new Object[0]));
            dataVariables.add(new Component[]{as.getDropdownIcon()});
            for (String string : commonColumnNames) {
                ((SubMenu)dataVariables.getSubMenu()).addItem(string.toUpperCase(), (ComponentEventListener & Serializable)event -> {
                    String text = this.textField.getValue();
                    MenuItem item = (MenuItem)event.getSource();
                    if (text != null) {
                        this.textField.replaceTextAtCurrentSelection(item.getText());
                    } else {
                        this.textField.setValue(item.getText());
                    }
                });
            }
            if (!commonColumnNames.isEmpty()) {
                menuLayout.add(new Component[]{dataVariableMenu});
            }
        }
        return menuLayout;
    }

    @Override
    protected void addButtonsToRightOfCancel() {
        Button validateButton = new Button(this.controller.getMessage("Validate", new Object[0]), (ComponentEventListener & Serializable)event -> {
            try {
                CCJSqlParserUtil.parse((String)(this.controller.getMessage("select c.node_id from sym_node c where c.node_group_id = :NODE_GROUP_ID and c.enabled = 1 and", new Object[0]) + " " + this.textField.getValue()));
                CommonUiUtils.notify((String)"", (String)"Valid SQL Script");
            }
            catch (JSQLParserException e2) {
                String message = e2.getCause().getMessage();
                if (message != null) {
                    CommonUiUtils.notify((String)"", (String)message);
                }
                CommonUiUtils.notify((String)"", (String)"Invalid SQL Script");
            }
        });
        this.getFooter().add(new Component[]{validateButton});
    }
}

