/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui.canvas;

import com.jumpmind.symmetric.console.ui.canvas.ConfigCanvas;
import com.jumpmind.symmetric.console.ui.canvas.ISidebarScreen;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.Command;

public abstract class AbstractSidebarScreen
extends VerticalLayout
implements ISidebarScreen {
    private static final long serialVersionUID = 1L;
    protected I controller;
    protected ConfigCanvas canvas;
    protected Span descriptionSpan;
    protected boolean readOnly;
    protected boolean errorMessageVisible;

    public AbstractSidebarScreen(I controller, ConfigCanvas canvas, String header, String description) {
        this.controller = controller;
        this.canvas = canvas;
        this.setHeight("0");
        this.setSpacing(false);
        if (header != null) {
            H5 headerComponent = new H5(header);
            headerComponent.setWidthFull();
            headerComponent.addClassName("less-contrast");
            headerComponent.getStyle().set("font-weight", "700");
            this.add(new Component[]{headerComponent});
        }
        if (description != null) {
            this.descriptionSpan = new Span(description);
            this.descriptionSpan.setWidthFull();
            this.descriptionSpan.addClassName("less-contrast");
            this.add(new Component[]{this.descriptionSpan});
        }
        this.readOnly = controller.getSymmetricEngine() != null && !controller.getConsoleUser().hasPrivilegeWrite("Create/Edit/Delete Configuration");
        this.errorMessageVisible = canvas.isSidebarErrorMessageVisible();
    }

    public void onAttach(AttachEvent event) {
        super.onAttach(event);
        this.canvas.getProgressStepper().setStepActive(this.getProgressStepperIndex());
    }

    @Override
    public boolean isPreviousVisible() {
        return true;
    }

    @Override
    public boolean isFinishVisible() {
        return false;
    }

    @Override
    public void addComponentsToFooter(HorizontalLayout footer) {
    }

    @Override
    public boolean last() {
        return true;
    }

    @Override
    public void onCloseIconClick() {
        this.canvas.closeSidebarAndClearSelection(false, true);
    }

    @Override
    public void onClose(boolean endpointDeleted, Command callback) {
        if (callback != null) {
            callback.execute();
        }
        this.canvas.redrawDiagram();
    }

    @Override
    public String getNextButtonTooltip() {
        return this.controller.getMessage("Proceed to the next screen", new Object[0]);
    }

    @Override
    public String getPreviousButtonTooltip() {
        return this.controller.getMessage("Go back to the previous screen", new Object[0]);
    }

    @Override
    public String getCloseIconTooltip() {
        return this.controller.getMessage("Close the sidebar", new Object[0]);
    }
}

