/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.ui;

import com.jumpmind.symmetric.console.impl.G;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class c {
    protected final Logger a = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine b;
    protected I c;
    protected Future<?> d;
    private transient ThreadPoolTaskScheduler h;
    protected Set<G<Object>> e = new HashSet<G<Object>>();
    protected Lock f = new ReentrantLock();
    protected int g = 10000;

    public c(I controller) {
        this.c = controller;
    }

    public void a(int interval) {
        this.g = interval;
        this.c();
    }

    public boolean a() {
        return this.h != null && this.d != null;
    }

    protected void b() {
        if (this.d != null) {
            this.d.cancel(false);
            this.d = null;
        }
    }

    protected void c() {
        this.b();
        if (this.h == null) {
            String suffix = this.c.getConsoleUser() != null ? this.c.getConsoleUser().getUserId() + "-" : "";
            suffix.replaceAll("\\s", "-");
            this.h = new ThreadPoolTaskScheduler();
            this.h.setThreadNamePrefix("background-refresher-" + suffix);
            this.h.setPoolSize(5);
            this.h.setWaitForTasksToCompleteOnShutdown(true);
            this.h.initialize();
        }
        if (this.h != null) {
            this.d = this.h.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    HashSet<G<Object>> refreshingCopy = null;
                    try {
                        c.this.f.lock();
                        refreshingCopy = new HashSet<G<Object>>(c.this.e);
                    }
                    finally {
                        c.this.f.unlock();
                    }
                    for (G g2 : refreshingCopy) {
                        c.this.a(g2);
                    }
                }
            }, Duration.ofMillis(this.g));
        }
    }

    protected void a(G<Object> refreshing) {
        try {
            UI ui;
            String engineName = "not available";
            if (this.b != null) {
                engineName = this.b.getEngineName();
            }
            MDC.put((String)"engineName", (String)engineName);
            long ts = System.currentTimeMillis();
            Object data = refreshing.onBackgroundDataRefresh(this.b);
            long timeItTookInMs = System.currentTimeMillis() - ts;
            if (timeItTookInMs > 10000L) {
                this.a.info("refreshing data for {} for engine: {} took {}ms", new Object[]{refreshing.getClass().getSimpleName(), engineName, timeItTookInMs});
            }
            if ((ui = (UI)this.c.getUI().orElse(null)) != null && ui.getElement().getNode().isAttached()) {
                ui.access((Command & Serializable)() -> {
                    try {
                        long currentTime = System.currentTimeMillis();
                        refreshing.onBackgroundUIRefresh(data);
                        long timeItTookInMillis = System.currentTimeMillis() - currentTime;
                        if (timeItTookInMillis > 10000L) {
                            this.a.info("refreshing ui for {} took {}ms", (Object)refreshing.getClass().getSimpleName(), (Object)timeItTookInMillis);
                        }
                    }
                    catch (Throwable ex2) {
                        refreshing.onUIError(ex2);
                        this.a.warn("Error during background refresh of " + String.valueOf(refreshing.getClass()), ex2);
                    }
                });
            }
        }
        catch (Throwable e2) {
            this.a.error("Exception while refreshing " + String.valueOf(refreshing.getClass()), e2);
        }
    }

    public void a(ISymmetricEngine engine) {
        this.b = engine;
        this.a(engine.getParameterService().getInt("dashboard.refresh.rate.ms", 10000));
    }

    public ScheduledFuture<?> b(final G<? extends Object> refreshing) {
        if (this.h == null) {
            this.c();
        }
        if (this.h != null) {
            return this.h.getScheduledExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    c.this.a(refreshing);
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
        this.a.error("Failed to queue work because the background refresher service has been shut down");
        return null;
    }

    public void c(G<? extends Object> refreshing) {
        this.a.debug("registered background refresher " + refreshing.getClass().getSimpleName());
        try {
            this.f.lock();
            this.e.add(refreshing);
        }
        finally {
            this.f.unlock();
        }
    }

    public void d(G<? extends Object> refreshing) {
        this.a.debug("unregistered background refresher " + refreshing.getClass().getSimpleName());
        try {
            this.f.lock();
            this.e.remove(refreshing);
        }
        finally {
            this.f.unlock();
        }
    }

    public void d() {
        this.a.debug("unregisterAll refreshers");
        try {
            this.f.lock();
            this.e.clear();
        }
        finally {
            this.f.unlock();
        }
    }

    protected void e() {
        this.a.debug("The background refresher service is shutting down");
        if (this.h != null) {
            this.h.shutdown();
            this.h = null;
        }
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$refresh$1a9ceefc$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/BackgroundRefresherService") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/common/IBackgroundRefreshable;Ljava/lang/Object;)V")) break;
                return () -> ((c)lambda.getCapturedArg(0)).a((G)lambda.getCapturedArg(1), lambda.getCapturedArg(2));
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

