/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jumpmind.symmetric.console.authentication.ConsoleAuthenticationException;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserAuthentication;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.vaadin.flow.server.VaadinSession;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class UserAuthenticationOAUTH2
implements IConsoleUserAuthentication {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private String oAuth2ClientID;

    @Override
    public IConsoleUserAuthentication.AuthenticationStatus authenticate(String user, String password, ISymmetricEngine engine) {
        IParameterService parameterService = engine.getParameterService();
        this.oAuth2ClientID = parameterService.getString("console.auth.oauth2.client.id");
        if (this.oAuth2ClientID != null && this.oAuth2ClientID.startsWith("enc:")) {
            this.oAuth2ClientID = engine.getSecurityService().decrypt(this.oAuth2ClientID.substring("enc:".length()));
        }
        this.checkParameters(parameterService.getString("console.auth.oauth2.client.id"), parameterService.getString("console.auth.oauth2.client.secret"), parameterService.getString("console.auth.oauth2.authorization.endpoint"), parameterService.getString("console.auth.oauth2.token.endpoint"), parameterService.getString("console.auth.oauth2.discovery.jwks.uri"), parameterService.getString("console.auth.oauth2.issuer"));
        IConsoleUserService userService = (IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        ConsoleUser currUser = userService.findConsoleUser(user);
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return null;
        }
        IConsoleUserAuthentication.AuthenticationStatus tokenValidity = this.validateToken(this.oAuth2ClientID, parameterService.getString("console.auth.oauth2.discovery.jwks.uri"), session.getSession().getAttribute("id_token").toString());
        if (!tokenValidity.equals((Object)IConsoleUserAuthentication.AuthenticationStatus.VALID)) {
            return tokenValidity;
        }
        String iss = session.getSession().getAttribute("iss").toString();
        if (!iss.equalsIgnoreCase(parameterService.getString("console.auth.oauth2.issuer"))) {
            this.log.warn("OIDC token's issuer does not match configured issuer.");
            return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
        }
        String aud = session.getSession().getAttribute("aud").toString();
        if (!aud.equalsIgnoreCase(this.oAuth2ClientID)) {
            this.log.warn("OIDC token's audience does not match configured client ID.");
            return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
        }
        long exp = Long.valueOf(session.getSession().getAttribute("exp").toString());
        if (System.currentTimeMillis() / 1000L >= exp) {
            this.log.warn("OIDC token is expired.");
            return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
        }
        if (!currUser.isEnabled()) {
            return IConsoleUserAuthentication.AuthenticationStatus.DISABLED;
        }
        return IConsoleUserAuthentication.AuthenticationStatus.VALID;
    }

    private IConsoleUserAuthentication.AuthenticationStatus validateToken(String clientID, String jwksURI, String idToken) {
        try {
            String[] jwtParts = idToken.split("\\.");
            if (jwtParts.length != 3) {
                throw new IllegalArgumentException("Invalid JWT format");
            }
            String headerJson = new String(Base64.getUrlDecoder().decode(jwtParts[0]));
            byte[] signature = Base64.getUrlDecoder().decode(jwtParts[2]);
            JsonObject header = JsonParser.parseString((String)headerJson).getAsJsonObject();
            String kid = header.get("kid").getAsString();
            String alg = header.get("alg").getAsString();
            if (!"RS256".equals(alg)) {
                throw new IllegalArgumentException("Unsupported algorithm: " + alg);
            }
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity jwksResponse = restTemplate.getForEntity(jwksURI, String.class, new Object[0]);
            JsonObject jwks = JsonParser.parseString((String)((String)jwksResponse.getBody())).getAsJsonObject();
            JsonObject jwk = null;
            JsonArray keys = jwks.getAsJsonArray("keys");
            for (JsonElement keyElement : keys) {
                JsonObject key = keyElement.getAsJsonObject();
                if (!kid.equals(key.get("kid").getAsString())) continue;
                jwk = key;
                break;
            }
            if (jwk == null) {
                throw new IllegalArgumentException("Key with kid " + kid + " not found");
            }
            String n2 = jwk.get("n").getAsString();
            String e2 = jwk.get("e").getAsString();
            BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(n2));
            BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(e2));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(spec);
            Signature rsa = Signature.getInstance("SHA256withRSA");
            rsa.initVerify(publicKey);
            rsa.update((jwtParts[0] + "." + jwtParts[1]).getBytes());
            if (!rsa.verify(signature)) {
                throw new SecurityException("Invalid JWT signature");
            }
            return IConsoleUserAuthentication.AuthenticationStatus.VALID;
        }
        catch (Exception e3) {
            this.log.error(e3.toString());
            return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
        }
    }

    private void checkParameters(String clientId, String clientSecret, String authEndpoint, String tokenEndpoint, String jwksURI, String issuer) {
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC client ID is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC client secret is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)authEndpoint)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC authorization endpoint is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)tokenEndpoint)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC token endpoint is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)jwksURI)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC jwks URI is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)issuer)) {
            throw new ConsoleAuthenticationException("OAuth 2.0/OIDC issuer is not configured.", new Object[0]);
        }
    }

    public String getRole(ISymmetricEngine engine) {
        return this.getRole(engine, null);
    }

    public String getRole(ISymmetricEngine engine, Map<String, List<String>> attributeMap) {
        IParameterService parameterService = engine.getParameterService();
        TypedProperties allProperties = parameterService.getAllParameters();
        String roleMapString = allProperties.getProperty("console.auth.oauth2.role.map");
        if (StringUtils.isBlank((CharSequence)roleMapString)) {
            return null;
        }
        LinkedHashMap<String, String> roleGroupMap = new LinkedHashMap<String, String>();
        for (String roleGroupEntryString : CsvUtils.tokenizeCsvData((String)roleMapString)) {
            String[] roleGroup = roleGroupEntryString.split("==");
            if (roleGroup.length != 2) continue;
            roleGroupMap.put(roleGroup[0], roleGroup[1]);
        }
        if (roleGroupMap.isEmpty()) {
            return null;
        }
        String[] roles = new String[]{};
        String roleClaimAttribute = allProperties.getProperty("console.auth.oauth2.role.claim.attribute");
        if (roleClaimAttribute.isBlank()) {
            roleClaimAttribute = "roles";
        }
        if (attributeMap == null) {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                return null;
            }
            roles = (String[])session.getSession().getAttribute(roleClaimAttribute);
        }
        for (String groupName : roleGroupMap.keySet()) {
            if (roles == null) continue;
            for (String role : roles) {
                if (!role.equals(groupName)) continue;
                return (String)roleGroupMap.get(groupName);
            }
        }
        return null;
    }
}

