/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import com.jumpmind.symmetric.console.authentication.ConsoleAuthenticationConnectionException;
import com.jumpmind.symmetric.console.authentication.ConsoleAuthenticationCredentialException;
import com.jumpmind.symmetric.console.authentication.ConsoleAuthenticationException;
import com.jumpmind.symmetric.console.service.IConsoleUserAuthentication;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticationLDAP
implements IConsoleUserAuthentication {
    final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public IConsoleUserAuthentication.AuthenticationStatus authenticate(String user, String password, ISymmetricEngine engine) throws ConsoleAuthenticationException {
        String securityPrincipal;
        String searchAtr;
        String baseDN;
        boolean result;
        IConsoleUserService userService = (IConsoleUserService)engine.getExtensionService().getExtensionPoint(IConsoleUserService.class);
        if (!userService.findConsoleUser(user).isEnabled()) {
            return IConsoleUserAuthentication.AuthenticationStatus.DISABLED;
        }
        IParameterService parameterService = engine.getParameterService();
        TypedProperties allProperties = parameterService.getAllParameters();
        String hostName = allProperties.getProperty("console.auth.ldap.host");
        boolean bl2 = result = this.doAuthenticate(user, password, hostName, baseDN = allProperties.getProperty("console.auth.ldap.baseDN"), searchAtr = allProperties.getProperty("console.auth.ldap.searchAttribute"), securityPrincipal = allProperties.getProperty("console.auth.ldap.securityPrincipal"), engine) != null;
        if (result) {
            return IConsoleUserAuthentication.AuthenticationStatus.VALID;
        }
        return IConsoleUserAuthentication.AuthenticationStatus.INVALID;
    }

    public boolean authenticate(String user, String password, String hostName, String baseDN, String searchAtr, String securityPrincipal, ISymmetricEngine engine) {
        return this.doAuthenticate(user, password, hostName, baseDN, searchAtr, securityPrincipal, engine) != null;
    }

    private String doAuthenticate(String user, String password, String hostName, String baseDNParameter, String searchAtr, String securityPrincipal, ISymmetricEngine engine) {
        this.checkParameters(hostName, baseDNParameter, searchAtr, password);
        String ret = null;
        ConsoleAuthenticationException throwit = null;
        String originalSecurityPrincipal = securityPrincipal;
        List<String> baseDNList = Arrays.asList(baseDNParameter.split("\\|"));
        for (String baseDN : baseDNList) {
            securityPrincipal = this.getSecurityPrincipal(originalSecurityPrincipal, searchAtr, user, baseDN);
            try {
                boolean result;
                DirContext ctx = this.getDirContext(hostName, securityPrincipal, password);
                boolean bl2 = result = ctx != null;
                if (result) {
                    ctx.close();
                    ret = securityPrincipal;
                }
                throwit = null;
                if (ret == null) continue;
                break;
            }
            catch (AuthenticationException ex2) {
                this.logException(ex2, user, hostName, baseDN, searchAtr, securityPrincipal, false);
                throwit = new ConsoleAuthenticationCredentialException(ex2, false);
            }
            catch (CommunicationException ex3) {
                this.logException(ex3, user, hostName, baseDN, searchAtr, securityPrincipal, false);
                throwit = new ConsoleAuthenticationConnectionException(ex3);
            }
            catch (NamingException ex4) {
                this.logException(ex4, user, hostName, baseDN, searchAtr, securityPrincipal, false);
                throwit = new ConsoleAuthenticationException(ex4);
            }
        }
        if (throwit != null) {
            throw throwit;
        }
        return ret;
    }

    private void checkParameters(String hostName, String baseDNParameter, String searchAtr, String password) {
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            throw new ConsoleAuthenticationException("LDAP hostName is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)baseDNParameter)) {
            throw new ConsoleAuthenticationException("LDAP baseDN is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)searchAtr)) {
            throw new ConsoleAuthenticationException("LDAP searchAtr is not configured.", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new ConsoleAuthenticationCredentialException("No Password Provided.", new Object[0]);
        }
    }

    private String getSecurityPrincipal(String securityPrincipal, String searchAtr, String user, String baseDN) {
        if (StringUtils.isEmpty((CharSequence)securityPrincipal)) {
            securityPrincipal = String.format("%s=%s,%s", searchAtr, user, baseDN);
        } else {
            securityPrincipal = Strings.CS.replace(securityPrincipal, "${baseDN}", baseDN);
            securityPrincipal = Strings.CS.replace(securityPrincipal, "${searchAttribute}", searchAtr);
            securityPrincipal = Strings.CS.replace(securityPrincipal, "${username}", user);
        }
        return securityPrincipal;
    }

    private DirContext getDirContext(String hostName, String securityPrincipal, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", hostName);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", securityPrincipal);
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    public boolean authenticate(String user, String password, String hostName, String baseDN, String searchAtr, ISymmetricEngine engine) throws ConsoleAuthenticationException {
        return this.doAuthenticate(user, password, hostName, baseDN, searchAtr, null, engine) != null;
    }

    public String getRole(String user, String password, ISymmetricEngine engine) {
        IParameterService parameterService = engine.getParameterService();
        TypedProperties allProperties = parameterService.getAllParameters();
        String roleGroupMapString = allProperties.getProperty("console.auth.ldap.role.group.map");
        if (StringUtils.isBlank((CharSequence)roleGroupMapString)) {
            return null;
        }
        LinkedHashMap<String, String> roleGroupMap = new LinkedHashMap<String, String>();
        for (String roleGroupEntryString : CsvUtils.tokenizeCsvData((String)roleGroupMapString)) {
            String[] roleGroup = roleGroupEntryString.split("==");
            if (roleGroup.length != 2) continue;
            roleGroupMap.put(roleGroup[0], roleGroup[1]);
        }
        if (roleGroupMap.isEmpty()) {
            return null;
        }
        String hostName = allProperties.getProperty("console.auth.ldap.host");
        String baseDNParameter = allProperties.getProperty("console.auth.ldap.baseDN");
        String searchAtr = allProperties.getProperty("console.auth.ldap.searchAttribute");
        this.checkParameters(hostName, baseDNParameter, searchAtr, password);
        String securityPrincipal = allProperties.getProperty("console.auth.ldap.securityPrincipal");
        String adminDN = allProperties.getProperty("console.auth.ldap.adminDN");
        boolean useAdmin = StringUtils.isNotBlank((CharSequence)adminDN);
        String adminPassword = null;
        String userDN = null;
        if (useAdmin) {
            userDN = this.doAuthenticate(user, password, hostName, baseDNParameter, searchAtr, securityPrincipal, engine);
            if (userDN == null) {
                return null;
            }
            adminPassword = allProperties.getProperty("console.auth.ldap.admin.password");
            if (adminPassword != null && adminPassword.startsWith("enc:")) {
                adminPassword = engine.getSecurityService().decrypt(adminPassword.substring("enc:".length()));
            }
        }
        boolean useMemberOf = allProperties.is("console.auth.ldap.use.memberOf");
        String memberAttributeParameter = allProperties.get("console.auth.ldap.memberAttribute");
        ConsoleAuthenticationException throwit = null;
        String originalSecurityPrincipal = securityPrincipal;
        List<String> baseDNList = Arrays.asList(baseDNParameter.split("\\|"));
        for (String baseDN : baseDNList) {
            securityPrincipal = useAdmin ? adminDN : this.getSecurityPrincipal(originalSecurityPrincipal, searchAtr, user, baseDN);
            DirContext ctx = null;
            try {
                ctx = this.getDirContext(hostName, securityPrincipal, useAdmin ? adminPassword : password);
                if (ctx != null) {
                    if (useMemberOf) {
                        Attribute memberOfAttribute = ctx.getAttributes(useAdmin ? userDN : securityPrincipal, new String[]{"memberOf"}).get("memberOf");
                        if (memberOfAttribute != null) {
                            NamingEnumeration<?> memberOfEnum = memberOfAttribute.getAll();
                            while (memberOfEnum.hasMore()) {
                                Object memberOf = memberOfEnum.next();
                                if (memberOf == null || !roleGroupMap.containsKey(memberOf)) continue;
                                memberOfEnum.close();
                                ctx.close();
                                return (String)roleGroupMap.get(memberOf);
                            }
                            memberOfEnum.close();
                        }
                    } else {
                        for (String group : roleGroupMap.keySet()) {
                            Attributes attributes = ctx.getAttributes(group);
                            Attribute memberAttribute = attributes.get(memberAttributeParameter);
                            if (memberAttribute == null) continue;
                            NamingEnumeration<?> memberEnum = memberAttribute.getAll();
                            while (memberEnum.hasMore()) {
                                Object member = memberEnum.next();
                                if (member == null || !member.equals(useAdmin ? userDN : securityPrincipal)) continue;
                                memberEnum.close();
                                ctx.close();
                                return (String)roleGroupMap.get(group);
                            }
                            memberEnum.close();
                        }
                    }
                    ctx.close();
                }
                throwit = null;
            }
            catch (AuthenticationException ex2) {
                this.logException(ex2, user, hostName, baseDN, searchAtr, securityPrincipal, useAdmin);
                throwit = new ConsoleAuthenticationCredentialException(ex2, useAdmin);
            }
            catch (CommunicationException ex3) {
                this.logException(ex3, user, hostName, baseDN, searchAtr, securityPrincipal, useAdmin);
                throwit = new ConsoleAuthenticationConnectionException(ex3);
            }
            catch (NamingException ex4) {
                this.logException(ex4, user, hostName, baseDN, searchAtr, securityPrincipal, useAdmin);
                throwit = new ConsoleAuthenticationException(ex4);
            }
            if (!useAdmin) continue;
            break;
        }
        if (throwit != null) {
            throw throwit;
        }
        return null;
    }

    protected void logException(Exception ex2, String user, String hostName, String baseDN, String searchAtr, String securityPrincipal, boolean useAdmin) {
        if (useAdmin) {
            this.log.warn("LDAP AuthenticationException as admin (adminDN= '" + securityPrincipal + "', hostname= '" + hostName + "')", (Throwable)ex2);
        } else {
            this.log.warn("LDAP AuthenticationException (securityPrincipal= '" + securityPrincipal + "', hostname= '" + hostName + "',searchAtr= '" + searchAtr + "', baseDN='" + baseDN + "', user='" + user + "')", (Throwable)ex2);
        }
    }
}

