/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.service.impl;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.service.impl.AbstractSqlMap;

public class CompareServiceSqlMap
extends AbstractSqlMap {
    public CompareServiceSqlMap(IDatabasePlatform platform, String tablePrefix) {
        super(platform, tablePrefix);
        this.putSql("selectCompareRequestsToProcessSql", "select * from $(compare_request) where (processed = 0 and source_node_id = ? and (not_before is null or not_before < ? or cancelled = 1)) or (processed = 1 and completed = 0 and (source_node_id = ? or target_node_id = ?))");
        this.putSql("selectCompareRequestSql", "select * from $(compare_request) where source_node_id = ? and compare_id = ?");
        this.putSql("selectUnprocessedCompareRequestSql", "select * from $(compare_request) where processed = 0");
        this.putSql("selectActiveCompareStatusSql", "select * from $(compare_status) where completed = 0 and cancelled = 0");
        this.putSql("selectAllCompareStatusSql", "select * from $(compare_status)");
        this.putSql("selectCompareStatusByCompareIdSql", "select * from $(compare_status) where source_node_id = ? and compare_id = ?");
        this.putSql("selectCompareTableStatusSql", "select * from $(compare_table_status) where source_node_id = ? and compare_id = ? and step_num = ?");
        this.putSql("selectCompareTableStatusByCompareIdSql", "select * from $(compare_table_status) where source_node_id = ? and compare_id = ?");
        this.putSql("selectCompareTableStatusByCompareIdStatusSql", "select * from $(compare_table_status) where source_node_id = ? and compare_id = ? and status != ? order by step_num");
        this.putSql("countCompareTableStatusByCompareIdStatusSql", "select count(*) from $(compare_table_status) where source_node_id = ? and compare_id = ? and status != ?");
        this.putSql("inflightMinBatchId", "select min(batch_id) from $(outgoing_batch) where status != 'OK' and node_id = ? and channel_id = ?");
        this.putSql("inflightMinDataId", "select min(data_id) from $(data_event) where batch_id = ?");
        this.putSql("inflightData", "select row_data, pk_data, old_data from $(data) where event_type in ('I','U','D') and data_id >= ? and table_name = ?");
        this.putSql("selectDataUnrouted", "select d.row_data, d.pk_data, d.old_data from $(data) d where d.data_id not in (select e.data_id from $(data_event) e) and is_prerouted = 0 and d.event_type in ('I','U','D') and d.table_name = ? and d.data_id >= ?");
        this.putSql("selectDataUnroutedNotExists", "select d.row_data, d.pk_data, d.old_data from $(data) d where not exists (select 1 from $(data_event) e where e.data_id = d.data_id) and event_type in ('I','U','D') and is_prerouted = 0 and d.table_name = ? and d.data_id >= ?");
        this.putSql("insertCompareRequestSql", "insert into $(compare_request) (source_node_id, target_node_id, trigger_id, router_id, create_time, use_table_checksum, use_inflight, use_row_level, use_chunking, use_script, use_repair, checksum_algorithm, decimal_scale, timestamp_scale, real_scale, exclude_surrogate, not_before, processed, completed, cancelled, compare_id, last_update_by, last_update_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.putSql("updateCompareRequestSql", "update $(compare_request) set use_table_checksum = ?, use_inflight = ?, use_row_level = ?, use_chunking = ?, use_script = ?, use_repair = ?, checksum_algorithm = ?, decimal_scale = ?, timestamp_scale = ?, real_scale = ?, exclude_surrogate = ?, not_before = ?, processed = ?, completed = ?, cancelled = ?, compare_id = ?, last_update_by = ?, last_update_time = ? where source_node_id = ? and target_node_id = ? and trigger_id = ? and router_id = ? and create_time = ?");
        this.putSql("insertCompareStatusSql", "insert into $(compare_status) (compare_id, source_node_id, target_node_id, start_time, end_time, tables_requested, tables_compared, completed, cancelled, error_flag, create_time, last_update_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.putSql("updateCompareStatusSql", "update $(compare_status) set target_node_id = ?, start_time = ?, end_time = ? tables_requested = ?, tables_compared = ?, completed = ?, cancelled = ?, error_flag = ?, last_update_time = ? where source_node_id = ? and compare_id = ?");
        this.putSql("updateCompareStatusComparedSql", "update $(compare_status) set last_update_time = ?, tables_compared = tables_compared + 1 where source_node_id = ? and compare_id = ?");
        this.putSql("insertCompareTableStatusSql", "insert into $(compare_table_status) (compare_id, source_node_id, step_num, target_node_id, current_level, status, source_catalog_name, source_schema_name, source_table_name, source_row_count, source_row_count_millis, source_row_extract_millis, source_row_extract_size, source_row_sort_millis, source_row_checksum_millis, source_row_filter_millis, source_table_checksum_millis, source_inflight_count, source_inflight_millis, source_chunk_millis, target_catalog_name, target_schema_name, target_table_name, target_row_count, target_row_count_millis, target_row_extract_millis, target_row_extract_size, target_row_sort_millis, target_row_checksum_millis, target_row_filter_millis, target_table_checksum_millis, target_inflight_count, target_inflight_millis, target_chunk_millis, chunk_match_count, chunk_diff_count, chunk_diff_list, chunk_compare_millis, repair_query_millis, repair_load_millis, repair_reject_count, row_match_count, row_diff_count, row_missing_count, row_extra_count, row_compare_millis, match_flag, ignore_flag, error_flag, error_message, start_time, end_time, last_update_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.putSql("updateCompareTableStatusSql", "update $(compare_table_status) set target_node_id = ?, current_level = ?, status = ?, source_catalog_name = ?, source_schema_name = ?, source_table_name = ?, source_row_count = ?, source_row_count_millis = ?, source_row_extract_millis = ?, source_row_extract_size = ?, source_row_sort_millis = ?, source_row_checksum_millis = ?, source_row_filter_millis = ?, source_table_checksum_millis = ?, source_inflight_count = ?, source_inflight_millis = ?, source_chunk_millis = ?, target_catalog_name = ?, target_schema_name = ?, target_table_name = ?, target_row_count = ?, target_row_count_millis = ?, target_row_extract_millis = ?, target_row_extract_size = ?, target_row_sort_millis = ?, target_row_checksum_millis = ?, target_row_filter_millis = ?, target_table_checksum_millis = ?, target_inflight_count = ?, target_inflight_millis = ?, target_chunk_millis = ?, chunk_match_count = ?, chunk_diff_count = ?, chunk_diff_list = ?, chunk_compare_millis = ?, row_match_count = ?, row_diff_count = ?, row_missing_count = ?, row_extra_count = ?, row_compare_millis = ?, repair_query_millis = ?, repair_load_millis = ?, repair_reject_count = ?, match_flag = ?, ignore_flag = ?, error_flag = ?, error_message = ?, start_time = ?, end_time = ?, last_update_time = ? where compare_id = ? and source_node_id = ? and step_num = ?");
        this.putSql("completeCompareRequest", "update $(compare_request) set completed = 1, last_update_time = ? where source_node_id = ? and compare_id = ?");
        this.putSql("completeCompareStatus", "update $(compare_status) set completed = 1, end_time = ?, last_update_time = ? where source_node_id = ? and compare_id = ?");
        this.putSql("cancelCompareRequest", "update $(compare_request) set cancelled = 1, last_update_by = ?, last_update_time = ? where source_node_id = ? and compare_id = ? and cancelled = 0");
        this.putSql("cancelCompareStatus", "update $(compare_status) set cancelled = 1, end_time = ?, last_update_time = ? where source_node_id = ? and compare_id = ?");
        this.putSql("cancelCompareTableStatus", "update $(compare_table_status) set status = ?, ignore_flag = 1, start_time = ?, end_time = ?, last_update_time = ? where source_node_id = ? and compare_id = ? and status != ?");
    }
}

