/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.remote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jumpmind.symmetric.console.remote.IRemoteStatusService;
import com.jumpmind.symmetric.console.remote.MessageContext;
import com.jumpmind.symmetric.console.remote.MessageDirection;
import com.jumpmind.symmetric.console.remote.RemoteStatusCommand;
import com.jumpmind.symmetric.console.remote.SessionEndpoint;
import jakarta.websocket.MessageHandler;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WsMessageHandler
implements MessageHandler.Whole<String> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new GsonBuilder().create();
    private Gson gsonPrettyPrint = new GsonBuilder().setPrettyPrinting().create();
    private IRemoteStatusService remoteStatusService;
    ISymmetricEngine engine;
    private String sourceNodeId;
    private String targetNodeId;
    private WebSocketSession session;

    public WsMessageHandler(ISymmetricEngine engine, IRemoteStatusService remoteStatusService, String sourceNodeId, String targetNodeId, WebSocketSession session) {
        this.engine = engine;
        this.remoteStatusService = remoteStatusService;
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.session = session;
    }

    public void onMessage(String message) {
        block19: {
            JsonObject json = (JsonObject)this.gson.fromJson(message, JsonObject.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Receiving message on node {}:\n {}", (Object)this.gsonPrettyPrint.toJson((JsonElement)json), (Object)this.engine.getNodeId());
            }
            String messageId = json.get("id").getAsString();
            MessageDirection direction = MessageDirection.valueOf(json.get("dir").getAsString());
            String payload = json.get("payload").getAsString();
            JsonElement errorFlagJson = json.get("error");
            int errorFlag = 0;
            if (errorFlagJson != null) {
                errorFlag = json.get("error").getAsInt();
            }
            String remoteNodeId = this.getRemoteNodeId();
            if (direction == MessageDirection.REQUEST) {
                SessionEndpoint endpoint = this.remoteStatusService.getSessions().get(remoteNodeId);
                if (endpoint == null) {
                    this.logger.debug("No SessionEndpoint found for " + this.getRemoteNodeId() + " available sessions: " + String.valueOf(this.remoteStatusService.getSessions()));
                }
                RemoteStatusCommand command = new RemoteStatusCommand(this.engine, remoteNodeId, payload);
                String resultJson = null;
                try {
                    String result = command.execute();
                    resultJson = this.remoteStatusService.getMessageJson(messageId, MessageDirection.RESPONSE, result);
                    if (endpoint == null) break block19;
                    if (this.session == null && !endpoint.checkStatus()) {
                        this.logger.debug("Endpoint session is no longer active. Cannot reply to request " + payload + " response: " + resultJson);
                        this.remoteStatusService.getSessions().remove(remoteNodeId);
                        return;
                    }
                    if (this.session == null && endpoint.getSession().getAsyncRemote() == null) {
                        this.logger.debug("endpoint.getSession().getAsyncRemote() is unexpectedly null. Cannot reply to request " + payload + " response: " + resultJson);
                        this.remoteStatusService.getSessions().remove(remoteNodeId);
                        return;
                    }
                    if (this.session == null) {
                        endpoint.getSession().getAsyncRemote().sendText(resultJson);
                        break block19;
                    }
                    this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)resultJson));
                }
                catch (Exception ex2) {
                    try {
                        String errorJson = this.remoteStatusService.getMessageJson(messageId, MessageDirection.RESPONSE, ex2.toString(), false, true);
                        if (this.session == null && endpoint != null) {
                            endpoint.getSession().getBasicRemote().sendText(errorJson);
                        } else if (this.session != null) {
                            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)errorJson));
                        }
                    }
                    catch (Exception ex1) {
                        this.logger.debug("Failed to send response for request " + payload + " response: " + resultJson, (Throwable)ex2);
                        this.remoteStatusService.getSessions().remove(remoteNodeId);
                    }
                }
            } else {
                MessageContext context = this.remoteStatusService.getAndRemoveMessageContext(messageId);
                if (context != null && context.getMessageHandler() != null) {
                    if (errorFlag == 1) {
                        context.getMessageHandler().onError(new Exception(payload));
                    } else {
                        context.getMessageHandler().onMessage(payload);
                    }
                } else {
                    this.logger.debug("No message handler found for message id {}.  Discarding message: {}", (Object)messageId, (Object)payload);
                }
            }
        }
    }

    protected String getRemoteNodeId() {
        String me = this.engine.getNodeId();
        if (this.sourceNodeId.equals(me)) {
            return this.targetNodeId;
        }
        return this.sourceNodeId;
    }
}

