/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.model;

import com.jumpmind.symmetric.console.model.TableGroup;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.exception.ParseException;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.TriggerHistory;

public class TableGroupHier
implements Cloneable,
IModelObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String tableGroupId;
    private String sourceCatalogName;
    private String sourceSchemaName;
    private String sourceTableName;
    private String parentId;
    private RelationType relationType;
    private String primaryColumnNames;
    private String parentColumnNames;
    private String localColumnNames;
    private Date createTime;
    private String createBy;
    private Date lastUpdateTime;
    private String lastUpdateBy;
    private transient String[] parsedPrimaryColumnNames;
    private transient String[] parsedParentColumnNames;
    private transient String[] parsedLocalColumnNames;
    private transient TableGroup tableGroup;
    private transient TableGroupHier parent;
    private transient TableGroupHier root;
    private transient int rootPathLength = -1;
    private transient Table table;
    private transient TriggerHistory triggerHistory;
    private transient String groupSql;
    private transient String tableAlias;
    private transient Map<String, TableGroupHier> tableAliasMap;

    public boolean equals(Object obj) {
        if (obj instanceof TableGroupHier && this.id != null) {
            return this.id.equals(((TableGroupHier)obj).id);
        }
        return false;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        return super.toString();
    }

    public TableGroupHier getRootParent() {
        if (this.root == null) {
            this.root = this;
            while (this.root.getParent() != null) {
                this.root = this.root.getParent();
            }
        }
        return this.root;
    }

    public int getRootParentPathLength() {
        if (this.rootPathLength == -1) {
            TableGroupHier parent = this;
            this.rootPathLength = 0;
            while (parent.getParent() != null) {
                ++this.rootPathLength;
                parent = parent.getParent();
            }
        }
        return this.rootPathLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] parseColumnNames(String argColumnNames) {
        if (StringUtils.isBlank((CharSequence)argColumnNames)) {
            return null;
        }
        if (argColumnNames.indexOf(34) == -1) {
            return argColumnNames.split("\\s*,\\s*");
        }
        try (CsvReader reader = new CsvReader((Reader)new StringReader(argColumnNames), ',');){
            if (!reader.readRecord()) throw new ParseException("Failed to read a record from CsvReader.");
            String[] stringArray = reader.getValues();
            return stringArray;
        }
        catch (Exception ex2) {
            throw new ParseException("Failed to parse columns [" + argColumnNames + "]", (Throwable)ex2);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTableGroupId() {
        return this.tableGroupId;
    }

    public void setTableGroupId(String tableGroupId) {
        this.tableGroupId = tableGroupId;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public void setRelationType(RelationType relationType) {
        this.relationType = relationType;
    }

    public String getPrimaryColumnNames() {
        return this.primaryColumnNames;
    }

    public String[] getParsedPrimaryColumnNames() {
        return this.parsedPrimaryColumnNames;
    }

    public void setPrimaryColumnNames(String primaryColumnNames) {
        this.primaryColumnNames = primaryColumnNames;
        this.parsedPrimaryColumnNames = this.parseColumnNames(primaryColumnNames);
    }

    public String getParentColumnNames() {
        return this.parentColumnNames;
    }

    public String[] getParsedParentColumnNames() {
        return this.parsedParentColumnNames;
    }

    public void setParentColumnNames(String parentColumnNames) {
        this.parentColumnNames = parentColumnNames;
        this.parsedParentColumnNames = this.parseColumnNames(parentColumnNames);
    }

    public String getLocalColumnNames() {
        return this.localColumnNames;
    }

    public String[] getParsedLocalColumnNames() {
        return this.parsedLocalColumnNames;
    }

    public void setLocalColumnNames(String localColumnNames) {
        this.localColumnNames = localColumnNames;
        this.parsedLocalColumnNames = this.parseColumnNames(localColumnNames);
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public TableGroup getTableGroup() {
        return this.tableGroup;
    }

    public void setTableGroup(TableGroup tableGroup) {
        this.tableGroup = tableGroup;
    }

    public TableGroupHier getParent() {
        return this.parent;
    }

    public void setParent(TableGroupHier parent) {
        this.parent = parent;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public TriggerHistory getTriggerHistory() {
        return this.triggerHistory;
    }

    public void setTriggerHistory(TriggerHistory triggerHistory) {
        this.triggerHistory = triggerHistory;
    }

    public String getGroupSql() {
        return this.groupSql;
    }

    public void setGroupSql(String groupSql) {
        this.groupSql = groupSql;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public Map<String, TableGroupHier> getTableAliasMap() {
        return this.tableAliasMap;
    }

    public void setTableAliasMap(Map<String, TableGroupHier> tableAliasMap) {
        this.tableAliasMap = tableAliasMap;
    }

    public static enum RelationType {
        OBJECT("O"),
        ARRAY("A");

        private String code;

        private RelationType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static RelationType getRelationType(String s2) {
            if (OBJECT.getCode().equals(s2)) {
                return OBJECT;
            }
            if (ARRAY.getCode().equals(s2)) {
                return ARRAY;
            }
            return null;
        }

        public String toString() {
            if (this.equals((Object)OBJECT)) {
                return "Object";
            }
            if (this.equals((Object)ARRAY)) {
                return "Array";
            }
            return "";
        }
    }
}

