/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.impl.v;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.Checksum;
import org.jumpmind.db.model.Table;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class x
extends e {
    protected final Logger a = LoggerFactory.getLogger(x.class);
    protected v b;

    public x(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
        this.b = new v(engine, compareService);
    }

    public void a(CompareTableStatus status, boolean isSource, ProcessInfo processInfo) {
        long count = 0L;
        long countMillis = 0L;
        long checksum = 0L;
        long checksumMillis = 0L;
        Table table = this.getTable(status, isSource);
        if (status.getCompareRequest().isUseTableChecksum()) {
            IStagedResource resourceRow = this.findResource(status, "row");
            if (resourceRow == null || !resourceRow.exists() || resourceRow.getState() != IStagedResource.State.DONE) {
                this.b.a(status, isSource, processInfo);
                resourceRow = this.findResource(status, "row");
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
            this.a.info("Calculating checksum for compare request {} for table {}", (Object)status.getNodeCompareIdStep(), (Object)(isSource ? status.getSourceTableName() : status.getTargetTableName()));
            long ts = System.currentTimeMillis();
            checksum = this.a(status, resourceRow);
            checksumMillis = System.currentTimeMillis() - ts;
            if (isSource) {
                status.setSourceTableChecksumMillis(checksumMillis);
            } else {
                status.setTargetTableChecksumMillis(checksumMillis);
            }
        } else {
            processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
            ISymmetricDialect dialect = this.engine.getTargetDialect();
            boolean useQuote = this.engine.getParameterService().is("db.delimited.identifier.mode");
            String quote = useQuote ? dialect.getPlatform().getDatabaseInfo().getDelimiterToken() : null;
            String sql = "select count(*) from " + table.getFullyQualifiedTableName(quote) + " t where " + this.getInitialLoadSelect(status, isSource, table);
            this.a.info("Querying row count for compare request {} for table {}: {}", new Object[]{status.getNodeCompareIdStep(), table.getName(), sql});
            long ts = System.currentTimeMillis();
            count = checksum = dialect.getPlatform().getSqlTemplateDirty().queryForLong(sql, new Object[0]);
            countMillis = System.currentTimeMillis() - ts;
            if (isSource) {
                status.setSourceRowCount(count);
                status.setSourceRowCountMillis(countMillis);
            } else {
                status.setTargetRowCount(count);
                status.setTargetRowCountMillis(countMillis);
            }
        }
        IStagedResource resourceTableChecksum = this.createResource(status, "table");
        try (CsvWriter writer = new CsvWriter(resourceTableChecksum.getOutputStream(), ',', Charset.defaultCharset());){
            writer.write("stats_columns");
            if (isSource) {
                writer.writeRecord(new String[]{"sourceRowCount", "sourceRowCountMillis", "sourceRowExtractMillis", "sourceRowChecksumMillis", "sourceRowExtractSize", "sourceRowSortMillis"});
            } else {
                writer.writeRecord(new String[]{"targetRowCount", "targetRowCountMillis", "targetRowExtractMillis", "targetRowChecksumMillis", "targetRowExtractSize", "targetRowSortMillis", "targetCatalogName", "targetSchemaName", "targetTableName"});
            }
            writer.write("stats");
            if (isSource) {
                writer.writeRecord(new String[]{String.valueOf(status.getSourceRowCount()), String.valueOf(status.getSourceRowCountMillis()), String.valueOf(status.getSourceRowExtractMillis()), String.valueOf(status.getSourceRowChecksumMillis()), String.valueOf(status.getSourceRowExtractSize()), String.valueOf(status.getSourceRowSortMillis())});
            } else {
                writer.writeRecord(new String[]{String.valueOf(status.getTargetRowCount()), String.valueOf(status.getTargetRowCountMillis()), String.valueOf(status.getTargetRowExtractMillis()), String.valueOf(status.getTargetRowChecksumMillis()), String.valueOf(status.getTargetRowExtractSize()), String.valueOf(status.getTargetRowSortMillis()), status.getTargetCatalogName(), status.getTargetSchemaName(), status.getTargetTableName()});
            }
            writer.write("cs");
            writer.write(String.valueOf(checksum));
            writer.endRecord();
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        resourceTableChecksum.setState(IStagedResource.State.DONE);
    }

    protected long a(CompareTableStatus status, IStagedResource resourceRow) {
        long checksum = 0L;
        Checksum checksumAlgo = this.getChecksumAlgo(status.getCompareRequest());
        try (CsvReader reader = CsvUtils.getCsvReaderDquote((Reader)new InputStreamReader(resourceRow.getInputStream()));){
            while (reader.readRecord()) {
                String[] tokens = reader.getValues();
                if (!tokens[0].equals("cs") || tokens.length <= 1) continue;
                this.updateChecksum(checksumAlgo, tokens[1]);
            }
            checksum = checksumAlgo.getValue();
        }
        catch (IOException e2) {
            throw new IoException((Exception)e2);
        }
        finally {
            resourceRow.close();
        }
        return checksum;
    }

    @Override
    protected Table getTable(CompareTableStatus status, boolean isSource) {
        if (!isSource) {
            TransformService.TransformTableNodeGroupLink transform;
            Node sourceNode = this.findNode(status.getSourceNodeId(), status.getCompareRequest());
            Node targetNode = this.findNode(status.getTargetNodeId(), status.getCompareRequest());
            List transforms = this.engine.getTransformService().findTransformsFor(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), status.getSourceTableName());
            if (transforms != null && transforms.size() > 0 && (transform = (TransformService.TransformTableNodeGroupLink)transforms.get(0)).getTransformPoint() == TransformPoint.LOAD) {
                status.setTargetCatalogName(SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetCatalogName()));
                status.setTargetSchemaName(SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetSchemaName()));
                status.setTargetTableName(SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)transform.getTargetTableName()));
            }
        }
        Table table = super.getTable(status, isSource);
        if (!isSource) {
            status.setTargetCatalogName(table.getCatalog());
            status.setTargetSchemaName(table.getSchema());
            status.setTargetTableName(table.getName());
        }
        return table;
    }
}

