/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.e;
import com.jumpmind.symmetric.console.model.CompareTableStatus;
import com.jumpmind.symmetric.console.service.ICompareService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.ServiceNotReadyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class r
extends e {
    protected final Logger a = LoggerFactory.getLogger(r.class);

    public r(ISymmetricEngine engine, ICompareService compareService) {
        this.engine = engine;
        this.compareService = compareService;
    }

    public void a(CompareTableStatus status) {
        String localNodeId = this.engine.getNodeId();
        String remoteNodeId = this.isSource(status) ? status.getTargetNodeId() : status.getSourceNodeId();
        Node localNode = this.findNode(localNodeId, status.getCompareRequest());
        Node remoteNode = this.findNode(remoteNodeId, status.getCompareRequest());
        NodeSecurity nodeSecurity = this.engine.getNodeService().findNodeSecurity(localNodeId);
        Map<String, String> param = this.b(status);
        try (IIncomingTransport transport = null;){
            transport = this.engine.getTransportManager().getComparePullTransport(remoteNode, localNode, nodeSecurity.getNodePassword(), this.engine.getParameterService().getRegistrationUrl(), param);
            transport.openStream();
        }
    }

    public void a(CompareTableStatus status, String resourceName, String sourceNodeId, String targetNodeId) {
        Node sourceNode = this.findNode(sourceNodeId, status.getCompareRequest());
        Node targetNode = this.findNode(targetNodeId, status.getCompareRequest());
        NodeGroupLink link = this.engine.getConfigurationService().getNodeGroupLinkFor(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), false);
        if (link != null) {
            IStagedResource resource;
            if (sourceNodeId.equals(this.engine.getNodeId()) && link.getDataEventAction() == NodeGroupLinkAction.P && status.getStatus().equals("NE")) {
                IStagedResource resource2 = this.findResource(status, resourceName);
                if (resource2 != null && resource2.exists() && resource2.getState() == IStagedResource.State.DONE) {
                    this.a(status, resource2, sourceNode, targetNode);
                }
            } else if (targetNodeId.equals(this.engine.getNodeId()) && link.getDataEventAction() == NodeGroupLinkAction.W && ((resource = this.findResource(status, resourceName + "-remote")) == null || !resource.exists() || resource.getState() != IStagedResource.State.DONE)) {
                this.a(status, resourceName, targetNode, sourceNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void a(CompareTableStatus status, IStagedResource resource, Node localNode, Node remoteNode) {
        NodeSecurity nodeSecurity = this.engine.getNodeService().findNodeSecurity(localNode.getNodeId());
        Map<String, String> param = this.b(status);
        IOutgoingWithResponseTransport transport = null;
        String queue = "";
        try {
            this.a.info("Pushing resource {} to node {}", (Object)resource.getFile().getName(), (Object)remoteNode);
            transport = this.engine.getTransportManager().getComparePushTransport(remoteNode, localNode, nodeSecurity.getNodePassword(), this.engine.getParameterService().getRegistrationUrl(), param);
            queue = this.buildKey(status.getNodeCompareId(), status.getStepNumber());
            transport.getSuspendIgnoreChannelLists(this.engine.getConfigurationService(), queue, remoteNode);
            try (OutputStream out = transport.openStream();
                 InputStream in = resource.getInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                transport.readResponse();
            }
            finally {
                resource.close();
            }
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                try {
                    transport.close();
                    throw throwable;
                }
                catch (Exception ex3) {
                    this.a.warn(String.format("Exception while closing a push transport for resource=%s, node=%s, queue=%s. Converted to ServiceNotReady (to retry later).", resource.getFile().getName(), remoteNode, queue), (Throwable)ex3);
                    throw new ServiceNotReadyException();
                }
            }
        }
        try {
            transport.close();
        }
        catch (Exception ex2) {
            this.a.warn(String.format("Exception while closing a push transport for resource=%s, node=%s, queue=%s. Converted to ServiceNotReady (to retry later).", resource.getFile().getName(), remoteNode, queue), (Throwable)ex2);
            throw new ServiceNotReadyException();
        }
        status.setStatus("SE");
        if (!this.isSource(status)) return;
        this.compareService.updateCompareTableStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void a(CompareTableStatus status, String resourceName, Node localNode, Node remoteNode) {
        NodeSecurity nodeSecurity = this.engine.getNodeService().findNodeSecurity(localNode.getNodeId());
        Map<String, String> param = this.b(status);
        param.put("download", Boolean.TRUE.toString());
        IStagedResource resource = this.createResource(status, resourceName + "-remote");
        IIncomingTransport transport = null;
        try {
            this.a.info("Pulling resource {} from node {}", (Object)resource.getFile().getName(), (Object)remoteNode);
            transport = this.engine.getTransportManager().getComparePullTransport(remoteNode, localNode, nodeSecurity.getNodePassword(), this.engine.getParameterService().getRegistrationUrl(), param);
            try (InputStream in = transport.openStream();
                 OutputStream out = resource.getOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                resource.close();
            }
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                try {
                    transport.close();
                    throw throwable;
                }
                catch (Exception ex3) {
                    this.a.warn(String.format("Exception while closing a pull transport for resource=%s, node=%s. Converted to ServiceNotReady (to retry later).", resource.getFile().getName(), remoteNode), (Throwable)ex3);
                    throw new ServiceNotReadyException();
                }
            }
        }
        try {
            transport.close();
        }
        catch (Exception ex2) {
            this.a.warn(String.format("Exception while closing a pull transport for resource=%s, node=%s. Converted to ServiceNotReady (to retry later).", resource.getFile().getName(), remoteNode), (Throwable)ex2);
            throw new ServiceNotReadyException();
        }
        status.setStatus("SE");
        if (this.isSource(status)) {
            this.compareService.updateCompareTableStatus(status);
        }
        resource.setState(IStagedResource.State.DONE);
    }

    protected Map<String, String> b(CompareTableStatus status) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sourceNodeId", status.getSourceNodeId());
        param.put("compareId", String.valueOf(status.getCompareId()));
        param.put("stepNum", String.valueOf(status.getStepNumber()));
        param.put("level", status.getLevel());
        param.put("sourceNodeId", status.getSourceNodeId());
        String queue = this.buildKey(status.getNodeCompareId(), status.getStepNumber());
        param.put("threadChannel", queue);
        return param;
    }
}

