/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Strings;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LogSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class gx
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;
    private Logger b = LoggerFactory.getLogger(this.getClass());

    @Override
    public MonitorEvent a(Monitor monitor) {
        String nodeId;
        String message;
        MonitorEvent event = new MonitorEvent();
        HashSet<String> nodeIdSet = new HashSet<String>();
        List logSummaryList = LogSummaryAppenderUtils.getLogSummaryErrors((String)this.a.getEngineName());
        for (LogSummary logSummary : logSummaryList) {
            message = logSummary.getMessage();
            if (!Strings.CI.contains((CharSequence)message, (CharSequence)"Failed to process incoming batch from node '") || !Strings.CI.contains((CharSequence)logSummary.getStackTrace(), (CharSequence)"PKIX path building failed")) continue;
            nodeId = message.substring(message.indexOf("'") + 1);
            nodeId = nodeId.substring(0, nodeId.indexOf("'"));
            nodeIdSet.add(nodeId);
        }
        logSummaryList = LogSummaryAppenderUtils.getLogSummaryWarnings((String)this.a.getEngineName());
        for (LogSummary logSummary : logSummaryList) {
            message = logSummary.getMessage();
            if (!Strings.CI.contains((CharSequence)message, (CharSequence)"Could not communicate with node") || !Strings.CI.contains((CharSequence)logSummary.getStackTrace(), (CharSequence)"PKIX path building failed")) continue;
            nodeId = message.substring(message.indexOf("'") + 1);
            nodeId = nodeId.substring(0, nodeId.indexOf("'"));
            nodeId = nodeId.substring(nodeId.lastIndexOf(":") + 1);
            nodeIdSet.add(nodeId);
        }
        int nodeIdCount = nodeIdSet.size();
        event.setValue(nodeIdCount);
        if (nodeIdCount > 0) {
            String optionDescription;
            String problemDescription;
            if (nodeIdCount == 1) {
                problemDescription = "An unknown certificate authority error occurred while communicating with the '" + (String)nodeIdSet.iterator().next() + "' node.";
                optionDescription = "Import the certificates from the '" + (String)nodeIdSet.iterator().next() + "' node and restart SymmetricDS";
            } else {
                problemDescription = nodeIdCount + " unknown certificate authority errors occurred while communicating with the following nodes: " + String.valueOf(nodeIdSet) + ".";
                optionDescription = "Import the certificates from the following nodes and restart SymmetricDS: " + String.valueOf(nodeIdSet);
            }
            String actionDescription = "Import the missing certificates and restart SymmetricDS.";
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, optionDescription));
            recommendation.a(options);
            recommendation.a("nodeIdSet", nodeIdSet);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        Collection nodeIdSet = (Collection)recommendation.c("nodeIdSet");
        if (nodeIdSet != null) {
            INodeService nodeService = this.a.getNodeService();
            String userId = event.getApprovedBy();
            for (String nodeId : nodeIdSet) {
                Node node = nodeService.findNode(nodeId);
                if (node != null) {
                    try {
                        Certificate[] certs = SymmetricUtils.getCertificates((String)node.getSyncUrl());
                        if (certs == null) {
                            this.b.error("Failed to approve Unknown Certificate Authority insight because sync URL does not use HTTPS protocol: " + node.getSyncUrl());
                            return false;
                        }
                        ISecurityService securityService = this.a.getSecurityService();
                        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
                        for (Certificate cert : certs) {
                            if (!(cert instanceof X509Certificate)) continue;
                            try {
                                String certString = FormatUtils.convertToPem((X509Certificate)((X509Certificate)cert));
                                KeyStore.TrustedCertificateEntry entry = securityService.createTrustedCert(certString.getBytes(), "pem", null, null);
                                securityService.installTrustedCert(entry);
                                String subject = "";
                                Certificate trustedCertificate = entry.getTrustedCertificate();
                                if (trustedCertificate instanceof X509Certificate) {
                                    X509Certificate x509Certificate = (X509Certificate)trustedCertificate;
                                    subject = x509Certificate.getSubjectX500Principal().getName().replace(",", ", ");
                                }
                                consoleEventService.addEvent(new ConsoleEvent(userId, "Import Authority", nodeId, nodeId, null, subject));
                            }
                            catch (CertificateEncodingException certificateEncodingException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    catch (MalformedURLException e2) {
                        this.b.error("Failed to approve Unknown Certificate Authority insight because sync URL was invalid: " + node.getSyncUrl(), (Throwable)e2);
                        return false;
                    }
                    catch (IOException e3) {
                        this.b.error("Failed to approve Unknown Certificate Authority insight because failed to connect to sync URL: " + node.getSyncUrl(), (Throwable)e3);
                        return false;
                    }
                    catch (KeyManagementException | NoSuchAlgorithmException e4) {
                        this.b.error("Failed to approve Unknown Certificate Authority insight because failed to initialize SSL context", (Throwable)e4);
                        return false;
                    }
                }
                this.b.error("Failed to approve Unknown Certificate Authority insight because the node with the following ID could not be found: " + nodeId);
                return false;
            }
            as.restartSymmetric(this.a, userId, "Unknown Certificate Authority insight approval");
            return true;
        }
        this.b.error("Failed to approve Unknown Certificate Authority insight because node ID set was null.");
        return false;
    }

    @Override
    public String b() {
        return "unknownCa";
    }

    @Override
    public boolean a() {
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

