/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.fZ;
import com.jumpmind.symmetric.console.impl.gR;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.MonitorEvent;
import com.jumpmind.symmetric.console.service.IConsoleEventService;
import com.jumpmind.symmetric.console.ui.common.as;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.service.IConfigurationService;

public class gc
implements fZ,
IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private ISymmetricEngine a;

    @Override
    public MonitorEvent a(Monitor monitor) {
        MonitorEvent event = new MonitorEvent();
        List nodeChannels = this.a.getConfigurationService().getNodeChannels(this.a.getNodeId(), false);
        ArrayList<String> suspendedOrIgnoredChannelIdList = new ArrayList<String>();
        for (NodeChannel nodeChannel : nodeChannels) {
            String channelId = nodeChannel.getChannelId();
            if (!nodeChannel.isSuspendEnabled() && !nodeChannel.isIgnoreEnabled()) continue;
            suspendedOrIgnoredChannelIdList.add(channelId);
        }
        int channelCount = suspendedOrIgnoredChannelIdList.size();
        event.setValue(channelCount);
        if (channelCount > 0) {
            String actionDescription;
            String problemDescription;
            if (channelCount == 1) {
                String channelId = (String)suspendedOrIgnoredChannelIdList.get(0);
                problemDescription = "The '" + channelId + "' channel is suspended or ignored.";
                actionDescription = "Unflag the '" + channelId + "' channel in the " + this.a.getParameterService().getTablePrefix() + "_node_channel_ctl table.";
            } else {
                problemDescription = "The following channels are suspended or ignored: " + String.valueOf(suspendedOrIgnoredChannelIdList) + ".";
                actionDescription = "Unflag the channels in the " + this.a.getParameterService().getTablePrefix() + "_node_channel_ctl table.";
            }
            gR recommendation = new gR(problemDescription, actionDescription, true);
            ArrayList<gR.a> options = new ArrayList<gR.a>();
            gR gR2 = recommendation;
            Objects.requireNonNull(gR2);
            options.add(gR2.new gR.a(1, "Unsuspend and unignore all channels"));
            recommendation.a(options);
            event.setDetails(as.getMonitorEventGson().toJson((Object)recommendation));
        }
        return event;
    }

    @Override
    public boolean a(MonitorEvent event, gR recommendation) {
        ArrayList<String> modifiedNodeChannelList = new ArrayList<String>();
        IConfigurationService configService = this.a.getConfigurationService();
        String nodeId = this.a.getNodeId();
        for (NodeChannel nodeChannel : configService.getNodeChannels(nodeId, false)) {
            if (!nodeChannel.isSuspendEnabled() && !nodeChannel.isIgnoreEnabled()) continue;
            nodeChannel.setSuspendEnabled(false);
            nodeChannel.setIgnoreEnabled(false);
            configService.saveNodeChannel(nodeChannel, true);
            modifiedNodeChannelList.add(nodeChannel.toString());
        }
        IConsoleEventService consoleEventService = (IConsoleEventService)this.a.getExtensionService().getExtensionPoint(IConsoleEventService.class);
        consoleEventService.addEvent(new ConsoleEvent(event.getApprovedBy(), "Node Channel Modified", nodeId, nodeId, null, ((Object)modifiedNodeChannelList).toString()));
        return true;
    }

    @Override
    public String b() {
        return "channelSuspend";
    }

    @Override
    public boolean a() {
        return true;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.a = engine;
    }
}

