/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class fj
extends AbstractJdbcDdlReader {
    public fj(IDatabasePlatform platform) {
        super(platform);
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.a(connection, table);
        }
        return table;
    }

    protected void a(Connection connection, Table table) throws SQLException {
        Column[] columns = table.getColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            columns[idx].setAutoIncrement(this.a(connection, table, columns[idx]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean a(Connection connection, Table table, Column column) throws SQLException {
        PreparedStatement prepStmt = null;
        IDdlBuilder builder = this.getPlatform().getDdlBuilder();
        String triggerName = builder.getConstraintName("TRG", table, column.getName(), null);
        String seqName = builder.getConstraintName("SEQ", table, column.getName(), null);
        if (!this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
            triggerName = triggerName.toUpperCase();
            seqName = seqName.toUpperCase();
        }
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM SYSPROGRESS.SYSTRIGGER WHERE triggername = ? WITH (NOLOCK)");
            prepStmt.setString(1, triggerName);
            ResultSet resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                boolean bl2 = false;
                return bl2;
            }
            resultSet.close();
            prepStmt.close();
            prepStmt = connection.prepareStatement("SELECT * FROM SYSPROGRESS.SYSSEQUENCES WHERE \"SEQ-NAME\" = ? WITH (NOLOCK)");
            prepStmt.setString(1, seqName);
            resultSet = prepStmt.executeQuery();
            boolean resultFound = resultSet.next();
            resultSet.close();
            boolean bl3 = resultFound;
            return bl3;
        }
        finally {
            if (prepStmt != null) {
                prepStmt.close();
            }
        }
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getDefaultValue() != null && column.getDefaultValue().equals("NULL")) {
            column.setDefaultValue(null);
        }
        return column;
    }

    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk2) {
        fk2.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }

    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk2) {
        fk2.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
    }

    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, IIndex> knownIndices) throws SQLException {
        String indexName = (String)values.get(this.getName("INDEX_NAME"));
        if (indexName != null && !indexName.startsWith("SYS_")) {
            super.readIndex(metaData, values, knownIndices);
        }
    }

    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        List<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: {}", (Object)tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "select triggerid, triggername, owner, tbl, trigger_event, rssid from SYSPROGRESS.SYSTRIGGER where tblowner = ? and tbl = ?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger a(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("triggername"));
                trigger.setSchemaName(row.getString("owner"));
                trigger.setTableName(row.getString("tbl"));
                trigger.setEnabled(true);
                String triggerType = row.getString("trigger_event");
                if (triggerType.equals("I")) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                } else if (triggerType.equals("U")) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                } else if (triggerType.equals("D")) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }

            public /* synthetic */ Object mapRow(Row row) {
                return this.a(row);
            }
        }, new Object[]{schema, tableName});
        for (Trigger trigger : triggers) {
            Map metaData = trigger.getMetaData();
            String sourceSql = "select proc_text, seq from SYSPROGRESS.SYSPROCTEXT where id = ? and rssid = ? order by seq";
            StringBuilder buff = new StringBuilder();
            for (Row row : sqlTemplate.query(sourceSql, new Object[]{metaData.get("triggerid"), metaData.get("rssid")})) {
                buff.append(row.getString("proc_text"));
                if (row.getInt("seq") != 0) continue;
                buff.append("\n");
            }
            trigger.setSource(buff.toString());
        }
        return triggers;
    }
}

