/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fb
extends DmlStatement {
    private static final FastDateFormat a = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final Logger b = LoggerFactory.getLogger(fb.class);

    public fb(DmlStatementOptions options) {
        super(options);
    }

    public String buildDynamicSql(BinaryEncoding encoding, Row row, boolean useVariableDates, boolean useJdbcTimestampFormat, Column[] columns) {
        if (useJdbcTimestampFormat) {
            b.debug("zOS doesn't support useJdbcTimestampFormat.  Changing to false.");
            useJdbcTimestampFormat = false;
        }
        String QUESTION_MARK = "<!QUESTION_MARK!>";
        String newSql = this.sql;
        String quote = this.databaseInfo.getValueQuoteToken();
        String binaryQuoteStart = this.databaseInfo.getBinaryQuoteStart();
        String binaryQuoteEnd = this.databaseInfo.getBinaryQuoteEnd();
        String regex = "\\?";
        ArrayList<Column> columnsToProcess = new ArrayList<Column>();
        columnsToProcess.addAll(Arrays.asList(columns));
        for (int i2 = 0; i2 < columnsToProcess.size(); ++i2) {
            Column column = (Column)columnsToProcess.get(i2);
            String name = column.getName();
            int type = column.getMappedTypeCode();
            if (row.get((Object)name) != null) {
                if (column.isOfTextType()) {
                    try {
                        String value = row.getString(name);
                        value = value.replace("\\", "\\\\");
                        value = value.replace("$", "\\$");
                        value = value.replace("'", "''");
                        value = value.replace("?", "<!QUESTION_MARK!>");
                        newSql = newSql.replaceFirst(regex, quote + value + quote);
                        continue;
                    }
                    catch (RuntimeException ex2) {
                        b.error("Failed to replace ? in {" + this.sql + "} with " + name + "=" + row.getString(name));
                        throw ex2;
                    }
                }
                if (column.isTimestampWithTimezone()) {
                    newSql = newSql.replaceFirst(regex, quote + row.getString(name) + quote);
                    continue;
                }
                if (type == 91 || type == 93 || type == 92) {
                    Date date = row.getDateTime(name);
                    if (useVariableDates) {
                        long diff = date.getTime() - System.currentTimeMillis();
                        newSql = newSql.replaceFirst(regex, "${curdate" + diff + "}");
                        continue;
                    }
                    if (type == 92) {
                        newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{ts " : "") + quote + FormatUtils.TIME_FORMATTER.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                        continue;
                    }
                    if (type == 91) {
                        newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{ts " : "") + quote + a.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                        continue;
                    }
                    newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{ts " : "") + quote + FormatUtils.TIMESTAMP_FORMATTER.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                    continue;
                }
                if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (encoding == BinaryEncoding.NONE) {
                        newSql = newSql.replaceFirst(regex, quote + row.getString(name));
                        continue;
                    }
                    if (encoding == BinaryEncoding.BASE64) {
                        newSql = newSql.replaceFirst(regex, quote + new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset()) + quote);
                        continue;
                    }
                    if (encoding != BinaryEncoding.HEX) continue;
                    newSql = newSql.replaceFirst(regex, binaryQuoteStart + new String(Hex.encodeHex((byte[])bytes)) + binaryQuoteEnd);
                    continue;
                }
                newSql = newSql.replaceFirst(regex, row.getString(name));
                continue;
            }
            newSql = newSql.replaceFirst(regex, "null");
        }
        newSql = newSql.replace("<!QUESTION_MARK!>", "?");
        return newSql + this.databaseInfo.getSqlCommandDelimiter();
    }

    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        if (select && column.isPrimaryKey() && column.isOfTextType()) {
            String quotedColumn = this.quote + columnName + this.quote;
            String typeName = column.getJdbcTypeName();
            String size = column.getSize();
            sql.append("CAST(").append(quotedColumn).append(" AS ").append(typeName).append("(").append(size).append(")CCSID ASCII) AS ").append(quotedColumn);
        } else {
            sql.append(this.quote).append(columnName).append(this.quote);
        }
    }
}

