/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.hh;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.file.BeanShellFileSyncZipScript;
import org.jumpmind.symmetric.file.IFileConflictResolver;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.model.FileConflictStrategy;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fK
extends BeanShellFileSyncZipScript {
    protected static final Logger a = LoggerFactory.getLogger((String)new hh(new long[]{-3793156161535766940L, -702280166829125316L, -7848425270256966257L, 1186479865398932782L, -1240314363906737384L, -1004393023177326303L, 1682002934926656809L, 6979285289825643216L, 5264546993363138007L}).toString());
    protected ISymmetricEngine b;

    public fK(ISymmetricEngine engine) {
        super(engine.getExtensionService());
        this.b = engine;
    }

    public void buildScriptFileSnapshot(Batch batch, FileSnapshot snapshot, FileTriggerRouter triggerRouter, FileTrigger fileTrigger, File file, String targetBaseDir, String targetFile) {
        if (triggerRouter.getTargetBaseDir().startsWith("azure://")) {
            this.a(batch, snapshot, triggerRouter, fileTrigger, file, targetBaseDir, targetFile);
        } else if (triggerRouter.getTargetBaseDir().startsWith("s3://")) {
            this.b(batch, snapshot, triggerRouter, fileTrigger, file, targetBaseDir, targetFile);
        } else {
            super.buildScriptFileSnapshot(batch, snapshot, triggerRouter, fileTrigger, file, targetBaseDir, targetFile);
        }
    }

    public void a(Batch batch, FileSnapshot snapshot, FileTriggerRouter triggerRouter, FileTrigger fileTrigger, File file, String targetBaseDir, String targetFile) {
        String azureTargetContainer = targetBaseDir.replace("azure://", "");
        String azureAccountName = this.b.getParameterService().getString("file.sync.azure.account.name");
        FileSnapshot.LastEventType eventType = snapshot.getLastEventType();
        StringBuilder command = new StringBuilder();
        snapshot.getRelativeDir();
        command.append("azureAccountName = \"").append(azureAccountName).append("\";\n");
        command.append("azureTargetContainer = \"").append(azureTargetContainer).append("\";\n");
        command.append("token = engine.getParameterService().getString(com.jumpmind.symmetric.console.common.ConsoleConstants.FILE_SYNC_AZURE_SAS_TOKEN);\n");
        command.append("if(token != null && token.startsWith(org.jumpmind.security.SecurityConstants.PREFIX_ENC)){\n");
        command.append("  token = engine.getSecurityService().decrypt(token.substring(org.jumpmind.security.SecurityConstants.PREFIX_ENC.length()));\n");
        command.append("}\n");
        command.append("azureSASToken = token;\n");
        command.append("com.azure.storage.blob.BlobContainerClient blobContainerClient = new com.azure.storage.blob.BlobContainerClientBuilder()\n    .endpoint(\"https://\" + azureAccountName + \".blob.core.windows.net\")\n    .sasToken(azureSASToken)\n    .containerName(azureTargetContainer)\n    .buildClient(); \n");
        command.append("targetBaseDir = \"").append(targetBaseDir).append("\";\n");
        command.append("targetBaseDir = targetBaseDir.replace(\ncom.jumpmind.symmetric.file.FileConstants.AZURE_URI_PREFIX,\"\");\n");
        command.append("targetBaseDir = targetBaseDir.replace(azureTargetContainer,\"\");\n");
        command.append("processFile = true;\n");
        command.append("sourceFileName = \"").append(snapshot.getFileName()).append("\";\n");
        command.append("targetFileName = sourceFileName;\n");
        command.append("targetRelativeDir = \"");
        if (!snapshot.getRelativeDir().equals(".")) {
            command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir()));
            command.append("\";\n");
            command.append("targetFileName = targetRelativeDir + \"/\" + targetFileName;\n");
        } else {
            command.append("\";\n");
        }
        command.append("if(!targetBaseDir.equals(\"\")){\n");
        command.append("  targetFileName = targetBaseDir + \"/\" + targetFileName;\n");
        command.append("}\n");
        command.append("sourceFilePath = \"");
        command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir())).append("\";\n");
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getBeforeCopyScript())) {
            command.append(fileTrigger.getBeforeCopyScript()).append("\n");
        }
        if (file.isDirectory()) {
            command.append("processFile = false; \n");
        }
        command.append("if (processFile) {\n");
        switch (eventType) {
            case CREATE: 
            case MODIFY: {
                command.append("  java.io.File sourceFile = new java.io.File(batchDir + \"/\"");
                if (!snapshot.getRelativeDir().equals(".")) {
                    command.append(" + sourceFilePath + \"/\"");
                }
                command.append(" + sourceFileName");
                command.append(");\n");
                FileConflictStrategy conflictStrategy = triggerRouter.getConflictStrategy();
                if (conflictStrategy != FileConflictStrategy.TARGET_WINS && conflictStrategy != FileConflictStrategy.MANUAL && triggerRouter.getConflictStrategyString() != null) {
                    for (IFileConflictResolver resolver : this.extensionService.getExtensionPointList(IFileConflictResolver.class)) {
                        if (!triggerRouter.getConflictStrategyString().equals(resolver.getName())) continue;
                        command.append(resolver.getResolveCommand(snapshot));
                    }
                }
                command.append("  if (processFile) {\n");
                command.append("    try {\n");
                command.append("      blob = blobContainerClient.getBlobClient(targetFileName);\n");
                command.append("      blob.uploadFromFile(sourceFile.getPath(), true);\n");
                command.append("    } catch (java.lang.Throwable e) {\n");
                command.append("      String errorDir = batchDir.toString();\n");
                command.append("      errorDir = errorDir.substring(0, errorDir.lastIndexOf('/')) + \"-error/\";\n");
                if (!snapshot.getRelativeDir().equals(".")) {
                    command.append("      errorDir += sourceFilePath + \"/\";\n");
                }
                command.append("      log.error(\"File '\" + targetFile + \"' is not writable. It will be placed in the '\" + errorDir + \"' directory.\");\n");
                command.append("      java.io.File errorFile = new java.io.File(errorDir + sourceFileName);\n");
                command.append("      if (sourceFile.isDirectory()) {\n");
                command.append("        org.apache.commons.io.FileUtils.copyDirectory(sourceFile, errorFile, true);\n");
                command.append("      } else {\n");
                command.append("        org.apache.commons.io.FileUtils.copyFile(sourceFile, errorFile, true);\n");
                command.append("      }\n");
                command.append("    }\n");
                command.append("  }\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
            case DELETE: {
                command.append("      blob = blobContainerClient.getBlobClient(targetFileName);\n");
                command.append("      if(blob.exists()){\n");
                command.append("        blob.delete();\n");
                command.append("      }\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getAfterCopyScript())) {
            command.append(fileTrigger.getAfterCopyScript()).append("\n");
        }
        command.append("}\n\n");
        this.getScript().append((CharSequence)command);
    }

    public void b(Batch batch, FileSnapshot snapshot, FileTriggerRouter triggerRouter, FileTrigger fileTrigger, File file, String targetBaseDir, String targetFile) {
        String s3Bucket = targetBaseDir.replace("s3://", "");
        String region = this.b.getParameterService().getString("file.sync.s3.region");
        String encAccessKey = this.b.getParameterService().getString("file.sync.s3.account.key");
        String encSecretKey = this.b.getParameterService().getString("file.sync.s3.secret.key");
        FileSnapshot.LastEventType eventType = snapshot.getLastEventType();
        StringBuilder command = new StringBuilder();
        String prefix = "enc:";
        snapshot.getRelativeDir();
        command.append("s3Bucket = \"").append(s3Bucket).append("\";\n");
        command.append("s3Region = \"").append(region).append("\";\n");
        command.append("securityService = engine.getSecurityService();\n");
        command.append("token = \"" + encAccessKey + "\";\n");
        command.append("prefix = \"" + prefix + "\";\n");
        command.append("if(token != null && token.startsWith(prefix)){\n");
        command.append(" tokenSubstring = token.substring(prefix.length());\n");
        command.append(" token = securityService.decrypt(tokenSubstring);\n");
        command.append("}\n");
        command.append("awsAccessKey = token;\n");
        command.append("token = \"" + encSecretKey + "\";\n");
        command.append("if(token != null && token.startsWith(prefix)){\n");
        command.append(" tokenSubstring = token.substring(prefix.length());\n");
        command.append(" token = securityService.decrypt(tokenSubstring);\n");
        command.append("}\n");
        command.append("awsSecretKey = token;\n");
        command.append("com.amazonaws.auth.BasicAWSCredentials awsCreds = new com.amazonaws.auth.BasicAWSCredentials(awsAccessKey, awsSecretKey);\n");
        command.append("  com.amazonaws.services.s3.AmazonS3 s3Client = com.amazonaws.services.s3.AmazonS3ClientBuilder\n                  .standard()\n                  .withCredentials(new com.amazonaws.auth.AWSStaticCredentialsProvider(awsCreds))\n                  .withRegion(s3Region)\n                  .build();\n");
        command.append("targetBaseDir = \"").append(targetBaseDir).append("\";\n");
        command.append("targetBaseDir = s3Bucket;\n");
        command.append("targetBaseDir = targetBaseDir.replace(s3Bucket,\"\");\n");
        command.append("processFile = true;\n");
        command.append("sourceFileName = \"").append(snapshot.getFileName()).append("\";\n");
        command.append("targetFileName = sourceFileName;\n");
        command.append("targetRelativeDir = \"");
        if (!snapshot.getRelativeDir().equals(".")) {
            command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir()));
            command.append("\";\n");
            command.append("targetFileName = targetRelativeDir + \"/\" + targetFileName;\n");
        } else {
            command.append("\";\n");
        }
        command.append("if(!targetBaseDir.equals(\"\")){\n");
        command.append("  targetFileName = targetBaseDir + \"/\" + targetFileName;\n");
        command.append("}\n");
        command.append("sourceFilePath = \"");
        command.append(StringEscapeUtils.escapeJava((String)snapshot.getRelativeDir())).append("\";\n");
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getBeforeCopyScript())) {
            command.append(fileTrigger.getBeforeCopyScript()).append("\n");
        }
        if (file.isDirectory()) {
            command.append("processFile = false; \n");
        }
        command.append("if (processFile) {\n");
        switch (eventType) {
            case CREATE: 
            case MODIFY: {
                command.append("  java.io.File sourceFile = new java.io.File(batchDir + \"/\"");
                if (!snapshot.getRelativeDir().equals(".")) {
                    command.append(" + sourceFilePath + \"/\"");
                }
                command.append(" + sourceFileName");
                command.append(");\n");
                FileConflictStrategy conflictStrategy = triggerRouter.getConflictStrategy();
                if (conflictStrategy != FileConflictStrategy.TARGET_WINS && conflictStrategy != FileConflictStrategy.MANUAL && triggerRouter.getConflictStrategyString() != null) {
                    for (IFileConflictResolver resolver : this.extensionService.getExtensionPointList(IFileConflictResolver.class)) {
                        if (!triggerRouter.getConflictStrategyString().equals(resolver.getName())) continue;
                        command.append(resolver.getResolveCommand(snapshot));
                    }
                }
                command.append("  if (processFile) {\n");
                command.append("    try {\n");
                command.append("      com.amazonaws.services.s3.model.PutObjectRequest request = new com.amazonaws.services.s3.model.PutObjectRequest(s3Bucket, targetFileName, new File(sourceFile.getPath()));\n");
                command.append("      s3Client.putObject(request);\n");
                command.append("    } catch (java.lang.Throwable e) {\n");
                command.append("      String errorDir = batchDir.toString();\n");
                command.append("      errorDir = errorDir.substring(0, errorDir.lastIndexOf('/')) + \"-error/\";\n");
                if (!snapshot.getRelativeDir().equals(".")) {
                    command.append("      errorDir += sourceFilePath + \"/\";\n");
                }
                command.append("      log.error(\"File '\" + targetFile + \"' is not writable. It will be placed in the '\" + errorDir + \"' directory.\");\n");
                command.append("      java.io.File errorFile = new java.io.File(errorDir + sourceFileName);\n");
                command.append("      if (sourceFile.isDirectory()) {\n");
                command.append("        org.apache.commons.io.FileUtils.copyDirectory(sourceFile, errorFile, true);\n");
                command.append("      } else {\n");
                command.append("        org.apache.commons.io.FileUtils.copyFile(sourceFile, errorFile, true);\n");
                command.append("      }\n");
                command.append("    }\n");
                command.append("  }\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
            case DELETE: {
                command.append("      s3Client.deleteObject(new com.amazonaws.services.s3.model.DeleteObjectRequest(s3Bucket, targetFileName));\n");
                command.append("  fileList.put(").append(targetFile).append(",\"");
                command.append(eventType.getCode());
                command.append("\");\n");
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fileTrigger.getAfterCopyScript())) {
            command.append(fileTrigger.getAfterCopyScript()).append("\n");
        }
        command.append("}\n\n");
        this.getScript().append((CharSequence)command);
    }
}

