/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.NumberRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.stage.PerfListener;
import org.jumpmind.symmetric.io.stage.PerfResult;
import org.jumpmind.util.CustomizableThreadFactory;
import org.jumpmind.vaadin.ui.common.ResizableDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class cQ
extends ResizableDialog
implements PerfListener {
    private static final long q = 1L;
    protected Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected I b;
    protected String c;
    protected CustomizableThreadFactory d;
    protected Span e;
    protected Span f;
    protected Span g = new Span();
    protected Grid<PerfResult> h;
    protected Div i;
    protected Span j = new Span();
    protected Button k;
    protected ExecutorService l;
    protected Future<?> m;
    protected UI n;
    protected int o;
    protected boolean p = true;

    public cQ(I controller, String engineName, String threadNameSuffix, String header) {
        super(header);
        this.b = controller;
        this.c = engineName;
        String threadName = engineName.toLowerCase() + threadNameSuffix;
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(threadName);
        this.l = Executors.newFixedThreadPool(1, (ThreadFactory)threadFactory);
        this.setCloseOnEsc(true);
        this.setCloseOnOutsideClick(true);
        this.setWidth("800px");
        this.setHeight("720px");
        this.innerContent.getStyle().set("margin", "0");
        VerticalLayout layout = new VerticalLayout();
        Span overallRatingSpan = new Span("Overall Rating");
        layout.add(new Component[]{overallRatingSpan});
        layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{overallRatingSpan});
        this.e = new Span("");
        this.e.setClassName("rating-poor");
        this.e.getStyle().set("min-height", "58px");
        this.f = new Span("/10");
        this.f.getStyle().set("font-size", "36px");
        this.f.setVisible(false);
        HorizontalLayout ratingLayout = new HorizontalLayout(new Component[]{this.e, this.f});
        ratingLayout.setSpacing(false);
        ratingLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.END);
        layout.add(new Component[]{ratingLayout});
        layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{ratingLayout});
        this.g.setVisible(false);
        layout.add(new Component[]{this.g});
        layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.g});
        this.h = new Grid();
        this.h.setItems(this.b());
        this.h.setSelectionMode(Grid.SelectionMode.NONE);
        this.h.setHeight("91px");
        this.h.setWidthFull();
        this.h.addColumn(PerfResult::getName).setKey("name").setHeader("Operation").setAutoWidth(true);
        this.h.addColumn(PerfResult::getCount).setKey("count").setHeader("Count");
        this.h.addColumn(PerfResult::getMillis).setKey("millis").setHeader("Millis");
        this.h.addColumn((Renderer)new NumberRenderer(PerfResult::getRating, (NumberFormat)new DecimalFormat("#0.0"))).setKey("rating").setHeader("Rating");
        this.h.addColumn(PerfResult::getOutcome).setKey("outcome").setHeader("Outcome");
        for (Grid.Column column : this.h.getColumns()) {
            column.setResizable(true);
        }
        layout.addAndExpand(new Component[]{this.h});
        HorizontalLayout hlayout = new HorizontalLayout();
        Span spacer = new Span();
        hlayout.add(new Component[]{spacer});
        hlayout.setFlexGrow(4.0, new HasElement[]{spacer});
        this.i = as.getSpinnerIcon("24px", "inherit");
        this.i.setVisible(false);
        hlayout.addAndExpand(new Component[]{this.i});
        hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.i});
        this.j = new Span();
        hlayout.addAndExpand(new Component[]{this.j});
        hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.j});
        this.k = new Button("Run Test");
        this.k.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.m == null) {
                this.n = UI.getCurrent();
                this.o = this.n.getPollInterval();
                this.n.setPollInterval(1000);
                this.m = this.f();
            } else if (!this.m.isDone() && !this.m.isCancelled()) {
                this.p = false;
            }
        });
        this.k.setDisableOnClick(true);
        hlayout.add(new Component[]{this.k});
        hlayout.setFlexGrow(2.0, new HasElement[]{this.k});
        hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.k});
        Button closeButton = new Button("Close");
        closeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        closeButton.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        hlayout.add(new Component[]{closeButton});
        hlayout.setFlexGrow(2.0, new HasElement[]{this.k});
        hlayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{closeButton});
        this.buildButtonFooter(new Component[]{hlayout});
        this.add((Component)layout);
    }

    protected abstract List<PerfResult> a();

    protected abstract List<PerfResult> b();

    protected Future<?> f() {
        return this.l.submit(this::g);
    }

    public void g() {
        MDC.put((String)"engineName", (String)this.c);
        as.securelyAccessUI(this.getUI().orElse(UI.getCurrent()), (Command & Serializable)() -> {
            this.g.setVisible(false);
            this.k.setText("Cancel Test");
            this.i.setVisible(true);
            this.j.setText("5%");
            this.g.setText("");
            this.k.setEnabled(true);
        });
        try {
            this.a(this.a());
        }
        catch (Exception e2) {
            this.a.warn("Test not complete", (Throwable)e2);
        }
        as.securelyAccessUI(this.getUI().orElse(UI.getCurrent()), (Command & Serializable)() -> {
            this.g.setVisible(StringUtils.isNotEmpty((CharSequence)this.g.getText()));
            this.k.setText("Run Test");
            this.i.setVisible(false);
            this.j.setText("");
            this.n.setPollInterval(this.o);
            this.m = null;
            this.k.setEnabled(true);
        });
    }

    public void update(List<PerfResult> results, float percentComplete) {
        DecimalFormat df2 = new DecimalFormat("#0%");
        as.securelyAccessUI(this.getUI().orElse(null), (Command & Serializable)() -> {
            this.j.setText(df2.format(percentComplete));
            this.a(results);
        });
    }

    public void a(List<PerfResult> results) {
        if (results == null) {
            return;
        }
        as.securelyAccessUI(this.getUI().orElse(UI.getCurrent()), (Command & Serializable)() -> {
            if (this.p) {
                this.h.setItems((Collection)results);
                this.a(this.b(results));
                String outcome = this.c(results);
                this.g.setText(outcome);
                if (StringUtils.isBlank((CharSequence)outcome) || "Success".equalsIgnoreCase(outcome)) {
                    this.g.setClassName("healthy");
                } else {
                    this.g.setClassName("unhealthy");
                }
                this.f.setVisible(true);
            } else {
                this.p = true;
            }
        });
    }

    protected float b(List<PerfResult> results) {
        if (results == null) {
            return -1.0f;
        }
        int resultCount = results.size();
        if (resultCount > 0) {
            float overallRating = 0.0f;
            for (PerfResult result : results) {
                overallRating += result.getRating();
            }
            return overallRating / (float)resultCount;
        }
        return -1.0f;
    }

    protected void a(float overallRating) {
        DecimalFormat df2 = new DecimalFormat("#0.0");
        this.e.setText(df2.format(overallRating));
        if (overallRating < 3.0f) {
            this.e.setClassName("rating-poor");
        } else if (overallRating < 5.0f) {
            this.e.setClassName("rating-fair");
        } else if (overallRating < 8.0f) {
            this.e.setClassName("rating-good");
        } else {
            this.e.setClassName("rating-excellent");
        }
    }

    protected String c(List<PerfResult> results) {
        if (results == null || results.size() <= 0) {
            return "";
        }
        String resultOutcome = "Success";
        for (PerfResult result : results) {
            String outcome = result.getOutcome();
            if (StringUtils.isBlank((CharSequence)outcome) || resultOutcome.equalsIgnoreCase(outcome)) continue;
            return outcome;
        }
        return resultOutcome;
    }

    public void close() {
        this.l.shutdownNow();
        super.close();
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$updateItems$a7d9eb9$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("(Ljava/util/List;)V")) break;
                return () -> ((cQ)((Object)lambda.getCapturedArg(0))).d((List)lambda.getCapturedArg(1));
            }
            case "getName": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jumpmind/symmetric/io/stage/PerfResult") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return PerfResult::getName;
            }
            case "lambda$new$b65a5b95$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> this.close();
            }
            case "lambda$run$f7fe4649$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("()V")) break;
                return (Command & Serializable)() -> {
                    this.g.setVisible(false);
                    this.k.setText("Cancel Test");
                    this.i.setVisible(true);
                    this.j.setText("5%");
                    this.g.setText("");
                    this.k.setEnabled(true);
                };
            }
            case "getOutcome": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jumpmind/symmetric/io/stage/PerfResult") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return PerfResult::getOutcome;
            }
            case "lambda$run$f7fe4649$2": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("()V")) break;
                return (Command & Serializable)() -> {
                    this.g.setVisible(StringUtils.isNotEmpty((CharSequence)this.g.getText()));
                    this.k.setText("Run Test");
                    this.i.setVisible(false);
                    this.j.setText("");
                    this.n.setPollInterval(this.o);
                    this.m = null;
                    this.k.setEnabled(true);
                };
            }
            case "lambda$update$bb5423fb$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/Command") || !lambda.getFunctionalInterfaceMethodName().equals("execute") || !lambda.getFunctionalInterfaceMethodSignature().equals("()V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("(Ljava/text/DecimalFormat;FLjava/util/List;)V")) break;
                return () -> ((cQ)((Object)lambda.getCapturedArg(0))).a((DecimalFormat)lambda.getCapturedArg(1), ((Float)lambda.getCapturedArg(2)).floatValue(), (List)lambda.getCapturedArg(3));
            }
            case "lambda$new$b65a5b95$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/manage/PerformanceTestDialog") || !lambda.getImplMethodSignature().equals("(Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return (ComponentEventListener & Serializable)event -> {
                    if (this.m == null) {
                        this.n = UI.getCurrent();
                        this.o = this.n.getPollInterval();
                        this.n.setPollInterval(1000);
                        this.m = this.f();
                    } else if (!this.m.isDone() && !this.m.isCancelled()) {
                        this.p = false;
                    }
                };
            }
            case "getCount": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jumpmind/symmetric/io/stage/PerfResult") || !lambda.getImplMethodSignature().equals("()J")) break;
                return PerfResult::getCount;
            }
            case "getMillis": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jumpmind/symmetric/io/stage/PerfResult") || !lambda.getImplMethodSignature().equals("()J")) break;
                return PerfResult::getMillis;
            }
            case "getRating": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/ValueProvider") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jumpmind/symmetric/io/stage/PerfResult") || !lambda.getImplMethodSignature().equals("()F")) break;
                return PerfResult::getRating;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

