/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.X;
import com.jumpmind.symmetric.console.impl.bc;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.b;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class ba
extends b<FileTrigger> {
    private static final long a = 1L;
    private HorizontalLayout b;
    private bc c;

    public ba(I controller) {
        super("File capture is a representation of the files monitored for changes to be captured and routed to another system.", controller);
    }

    @Override
    protected Component buildMainTab() {
        VerticalLayout layout = (VerticalLayout)super.buildMainTab();
        this.c = new bc(this.controller);
        this.b = this.c.b();
        if (this.controller.getConsoleUser().hasPrivilegeWrite("File Sync Control")) {
            this.b.setEnabled(true);
        } else {
            this.b.setEnabled(false);
        }
        if (this.controller.getConsoleUser().hasPrivilegeRead("File Sync Control")) {
            layout.addComponentAtIndex(1, (Component)this.b);
        }
        return layout;
    }

    @Override
    public String getEditTitle() {
        return "Edit '%s' File Capture";
    }

    @Override
    public String getNewTitle() {
        return "New File Capture";
    }

    @Override
    public String getTitleKey() {
        return "File Capture";
    }

    protected String a(FileTrigger item) {
        return item.getTriggerId();
    }

    @Override
    protected void itemSelected() {
    }

    @Override
    protected void noItemsSelected() {
    }

    @Override
    protected void updateDisplaySpan() {
        super.updateDisplaySpan();
        this.c.a(this.b);
    }

    @Override
    protected R<FileTrigger> createForm(boolean newItemFlag, boolean deleteFlag) {
        return new X(this.controller, this.grid.getSelectedItems(), newItemFlag, deleteFlag);
    }

    @Override
    protected String getKeyColumn() {
        return "triggerId";
    }

    @Override
    protected String[] getFilterColumns() {
        String[] columns = new String[]{"triggerId", "baseDir"};
        return columns;
    }

    @Override
    protected Map<String, String> getVisibleGridColumns() {
        LinkedHashMap<String, String> visible = new LinkedHashMap<String, String>();
        visible.put("triggerId", this.controller.getMessage("Identifier", new Object[0]));
        visible.put("channelId", this.controller.getMessage("Channel Id", new Object[0]));
        visible.put("reloadChannelId", this.controller.getMessage("Reload Channel Id", new Object[0]));
        visible.put("baseDir", this.controller.getMessage("Base Directory", new Object[0]));
        visible.put("recurse", this.controller.getMessage("Recurse", new Object[0]));
        visible.put("includesFiles", this.controller.getMessage("Include Files", new Object[0]));
        visible.put("excludesFiles", this.controller.getMessage("Exclude Files", new Object[0]));
        visible.put("syncOnCreate", this.controller.getMessage("Sync on Create", new Object[0]));
        visible.put("syncOnModified", this.controller.getMessage("Sync on Modified", new Object[0]));
        visible.put("syncOnDelete", this.controller.getMessage("Sync on Delete", new Object[0]));
        visible.put("beforeCopyScript", this.controller.getMessage("Before Copy Script", new Object[0]));
        visible.put("afterCopyScript", this.controller.getMessage("After Copy Script", new Object[0]));
        return visible;
    }

    @Override
    protected void initGrid() {
        this.grid = new Grid(FileTrigger.class);
    }

    @Override
    protected void fillGrid(Grid<FileTrigger> grid) {
        String searchValue;
        IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
        if (this.itemList != null) {
            this.itemList.clear();
        }
        if (!StringUtils.isBlank((CharSequence)(searchValue = this.searchField.getValue()))) {
            List allFileTriggers = fileSyncService.getFileTriggers();
            for (FileTrigger fileTrigger : allFileTriggers) {
                if (CommonUiUtils.isFilteredOut((String)fileTrigger.getTriggerId(), (String)searchValue)) continue;
                this.itemList.add(fileTrigger);
            }
        } else {
            this.itemList = fileSyncService.getFileTriggers();
        }
        this.updateItems(this.itemList);
    }

    protected Image a(String fileTriggerId, List<FileTriggerRouter> fileTriggerRouters) {
        boolean syncingIn = false;
        boolean syncingOut = false;
        boolean linked = false;
        String nodeGroupId = this.controller.getSymmetricEngine().getParameterService().getNodeGroupId();
        for (FileTriggerRouter fileTriggerRouter : fileTriggerRouters) {
            if (!fileTriggerRouter.getFileTrigger().getTriggerId().equals(fileTriggerId)) continue;
            linked = true;
            NodeGroupLink link = fileTriggerRouter.getRouter().getNodeGroupLink();
            if (!fileTriggerRouter.isEnabled()) continue;
            if (link.getSourceNodeGroupId().equals(nodeGroupId)) {
                syncingOut = true;
            }
            if (!link.getTargetNodeGroupId().equals(nodeGroupId)) continue;
            syncingIn = true;
        }
        Image icon = as.createImage(this.controller.getContextPath(), "/icons/link_break.png");
        icon.setTitle("The file capture has not been linked yet");
        if (syncingIn && syncingOut) {
            icon = as.createImage(this.controller.getContextPath(), "/icons/arrow_left_right.png");
            icon.setTitle("Data is captured locally and being loaded");
        } else if (syncingIn) {
            icon = as.createImage(this.controller.getContextPath(), "/icons/arrow_right.png");
            icon.setTitle("Data is being loaded locally");
        } else if (syncingOut) {
            icon = as.createImage(this.controller.getContextPath(), "/icons/arrow_left.png");
            icon.setTitle("Data is captured locally");
        } else if (linked) {
            icon = new Image();
        }
        return icon;
    }

    protected TriggerHistory b(String triggerId, List<TriggerHistory> histories) {
        for (TriggerHistory history : histories) {
            if (!history.getTriggerId().equals(triggerId)) continue;
            return history;
        }
        return null;
    }

    @Override
    protected void configureGridColumns() {
        super.configureGridColumns();
        this.columnVisibilityToggler.addColumn(this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)fileTrigger -> {
            IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
            return this.a(fileTrigger.getTriggerId(), fileSyncService.getFileTriggerRouters(false));
        })).setHeader("").setKey("icon").setWidth("50px").setFlexGrow(0), "");
        this.grid.setColumnOrder(Arrays.asList(this.grid.getColumnByKey("icon"), this.grid.getColumnByKey("triggerId"), this.grid.getColumnByKey("channelId"), this.grid.getColumnByKey("reloadChannelId"), this.grid.getColumnByKey("baseDir"), this.grid.getColumnByKey("recurse"), this.grid.getColumnByKey("includesFiles"), this.grid.getColumnByKey("excludesFiles"), this.grid.getColumnByKey("syncOnCreate"), this.grid.getColumnByKey("syncOnModified"), this.grid.getColumnByKey("syncOnDelete"), this.grid.getColumnByKey("beforeCopyScript"), this.grid.getColumnByKey("afterCopyScript"), this.grid.getColumnByKey("lastUpdateTime"), this.grid.getColumnByKey("lastUpdateBy"), this.grid.getColumnByKey("createTime")));
    }

    @Override
    protected boolean isDeleteEnabled(StringBuilder tooltip) {
        if (!this.grid.getSelectedItems().isEmpty()) {
            if (this.c.a() && this.controller.getConsoleUser().hasPrivilegeWrite("Create/Edit/Delete Files")) {
                return true;
            }
            String consoleRoleId = "unknown";
            if (this.controller.getConsoleUser().getRole() != null) {
                consoleRoleId = this.controller.getConsoleUser().getRole();
            }
            tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
            return false;
        }
        return false;
    }

    @Override
    protected boolean isNewEnabled(StringBuilder tooltip) {
        if (this.c.a() && this.controller.getConsoleUser().hasPrivilegeWrite("Create/Edit/Delete Files")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean isEditEnabled(StringBuilder tooltip) {
        if (this.c.a() && this.controller.getConsoleUser().hasPrivilegeWrite("Create/Edit/Delete Files")) {
            return true;
        }
        String consoleRoleId = "unknown";
        if (this.controller.getConsoleUser().getRole() != null) {
            consoleRoleId = this.controller.getConsoleUser().getRole();
        }
        tooltip.append(String.format("Your role '%s' does not have the privileges needed for this action.", consoleRoleId));
        return false;
    }

    @Override
    protected boolean gridCanBeModified() {
        return this.controller.getConsoleUser().hasPrivilegeRead("Create/Edit/Delete Files") || this.controller.getConsoleUser().hasPrivilegeRead("File Sync Control") || this.controller.getConsoleUser().hasPrivilegeRead("Auto Create Files");
    }

    @Override
    protected void hideColumns() {
        this.grid.getColumnByKey("reloadChannelId").setVisible(false);
        this.grid.getColumnByKey("includesFiles").setVisible(false);
        this.grid.getColumnByKey("excludesFiles").setVisible(false);
        this.grid.getColumnByKey("beforeCopyScript").setVisible(false);
        this.grid.getColumnByKey("afterCopyScript").setVisible(false);
        this.grid.getColumnByKey("lastUpdateTime").setVisible(false);
        this.grid.getColumnByKey("lastUpdateBy").setVisible(false);
        this.grid.getColumnByKey("createTime").setVisible(false);
    }

    @Override
    public String getDocAnchor() {
        return "/doc/html/user-guide.html#_file_triggers";
    }

    @Override
    protected /* synthetic */ String getId(IModelObject iModelObject) {
        return this.a((FileTrigger)iModelObject);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$configureGridColumns$3fed5817$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/function/SerializableFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/configure/FileCaptureEditPanel") || !lambda.getImplMethodSignature().equals("(Lorg/jumpmind/symmetric/model/FileTrigger;)Lcom/vaadin/flow/component/html/Image;")) break;
                return (SerializableFunction & Serializable)fileTrigger -> {
                    IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
                    return this.a(fileTrigger.getTriggerId(), fileSyncService.getFileTriggerRouters(false));
                };
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

