/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.model.TableGroup;
import com.jumpmind.symmetric.console.service.ITableGroupService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class am
extends R<TableGroup> {
    private static final long serialVersionUID = 1L;
    private String originalId;

    public am(I controller, Set<TableGroup> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((TableGroup)this.itemSet.iterator().next()).getId();
        }
        this.binder = new Binder(TableGroup.class);
        TextField id = new TextField();
        id.setId("id");
        this.binder.forField((HasValue)id).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Table Group Id")).bind("id");
        id.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)id, this.controller.getMessage("Table Group Id", new Object[0])));
        ArrayList<String> nodeGroupIds = new ArrayList<String>();
        for (NodeGroup nodeGroup : this.controller.getSymmetricEngine().getConfigurationService().getNodeGroups()) {
            nodeGroupIds.add(nodeGroup.getNodeGroupId());
        }
        Select nodeGroupLink = new Select();
        nodeGroupLink.setItems((Collection)this.controller.getSymmetricEngine().getConfigurationService().getNodeGroupLinks(false));
        nodeGroupLink.setId("nodeGroupLink");
        this.binder.forField((HasValue)nodeGroupLink).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Group Link")).bind("nodeGroupLink");
        nodeGroupLink.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a((HasValue<?, ?>)nodeGroupLink, this.controller.getMessage("Group Link", new Object[0])));
        this.advancedFieldList = new ArrayList();
        TextArea description = new TextArea();
        description.setId("description");
        description.setHeight("102px");
        description.setWidth("30em");
        this.binder.forField((HasValue)description).bind("description");
        description.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a((HasValue<?, ?>)description, this.controller.getMessage("Description", new Object[0])));
        Select writerType = new Select();
        writerType.setItems((Object[])TableGroup.WriterType.values());
        writerType.setId("writerType");
        writerType.setEmptySelectionAllowed(true);
        writerType.setItemLabelGenerator((ItemLabelGenerator & Serializable)type -> type != null ? WordUtils.capitalizeFully((String)type.toString()) : "");
        this.binder.forField((HasValue)writerType).bind("writerType");
        this.fieldList.add(new R.a((HasValue<?, ?>)writerType, this.controller.getMessage("Writer Type", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        this.newItem = new TableGroup();
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            ITableGroupService tableGroupService = this.controller.getTableGroupService();
            if (!this.isBulk) {
                TableGroup group;
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((TableGroup)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((TableGroup)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    group = saveAsCopy ? (TableGroup)this.newItem : (TableGroup)this.itemSet.iterator().next();
                    group.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        tableGroupService.saveTableGroupAsCopy(this.originalId, group);
                    } else if (this.originalId == null || this.originalId.equals(group.getId())) {
                        tableGroupService.saveTableGroup(group);
                    } else {
                        tableGroupService.renameTableGroup(this.originalId, group);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((TableGroup)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    group = (TableGroup)this.newItem;
                    group.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    group.setCreateBy(this.controller.getConsoleUser().getUserId());
                    tableGroupService.saveTableGroup(group);
                }
                this.addEvent(this.newItemFlag ? "Table Group Created" : "Table Group Modified", group.getId());
            } else {
                for (TableGroup group : this.itemSet) {
                    this.saveFieldsToTableGroup(this.fieldList, group);
                    this.saveFieldsToTableGroup(this.advancedFieldList, group);
                    group.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    tableGroupService.saveTableGroup(group);
                }
                this.addEvent("Table Group Modified", this.itemSet.stream().map(TableGroup::getId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToTableGroup(List<R.a> fields, TableGroup group) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "nodeGroupLink": {
                    group.setNodeGroupLink((NodeGroupLink)field.getValue());
                    break;
                }
                case "description": {
                    group.setDescription((String)field.getValue());
                    break;
                }
                case "writerType": {
                    group.setWriterType((TableGroup.WriterType)((Object)field.getValue()));
                }
            }
        }
    }

    @Override
    public void delete() {
        for (TableGroup group : this.itemSet) {
            this.controller.getTableGroupService().deleteTableGroup(group.getId());
        }
        this.addEvent("Table Group Deleted", this.itemSet.stream().map(TableGroup::getId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("id");
        orderedFields.add("nodeGroupLink");
        orderedFields.add("description");
        orderedFields.add("writerType");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "id";
    }

    @Override
    public String getHelpSectionName() {
        return "_table_groups";
    }
}

