/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.J;
import com.jumpmind.symmetric.console.ui.common.M;
import com.jumpmind.symmetric.console.ui.common.am;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.q;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class al
extends R<Trigger> {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "identifier";
    private J panel;
    private Checkbox useStreamLobs;
    private Checkbox streamRow;
    private TextField channelExpression;
    private TextField timeBasedCaptureColumn;
    private List<R.a> hiddenFieldList;
    private String originalId;

    public al(I controller, Set<Trigger> itemSet, boolean newItemFlag, boolean deleteFlag, J panel) {
        super(controller, itemSet, newItemFlag, deleteFlag);
        this.panel = panel;
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((Trigger)this.itemSet.iterator().next()).getTriggerId();
        }
        this.binder = new Binder(Trigger.class);
        TextField identifier = new TextField();
        identifier.setId(IDENTIFIER);
        identifier.setClassName("input-long");
        this.binder.forField((HasValue)identifier).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Identifier")).bind("triggerId");
        identifier.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)identifier, this.controller.getMessage("Identifier", new Object[0])));
        TextField sourceCatalogName = new TextField();
        sourceCatalogName.setId("sourceCatalogName");
        sourceCatalogName.setClassName("input-long");
        this.binder.forField((HasValue)sourceCatalogName).bind("sourceCatalogName");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)sourceCatalogName, this.controller.getMessage("Source Catalog", new Object[0])));
        TextField sourceSchemaName = new TextField();
        sourceSchemaName.setId("sourceSchemaName");
        sourceSchemaName.setClassName("input-long");
        this.binder.forField((HasValue)sourceSchemaName).bind("sourceSchemaName");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)sourceSchemaName, this.controller.getMessage("Source Schema", new Object[0])));
        TextField sourceTableName = new TextField();
        sourceTableName.setId("sourceTableName");
        sourceTableName.setClassName("input-long");
        this.binder.forField((HasValue)sourceTableName).withValidator((SerializablePredicate & Serializable)value -> !value.equals(sourceTableName.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Source Table")).bind("sourceTableName");
        sourceTableName.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)sourceTableName, this.controller.getMessage("Source Table", new Object[0])));
        Select<String> channelId = this.getChannelIdSelect(this.controller.getMessage("Channel Id", new Object[0]), "channelId", false);
        if (!this.isBulk) {
            channelId.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.channelExpression.setRequiredIndicatorVisible("dynamic".equals(event.getValue())));
        }
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)channelId, this.controller.getMessage("Channel Id", new Object[0])));
        this.advancedFieldList = new ArrayList();
        Checkbox syncOnInsert = new Checkbox();
        syncOnInsert.setId("syncOnInsert");
        this.binder.forField((HasValue)syncOnInsert).bind("syncOnInsert");
        syncOnInsert.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnInsert, this.controller.getMessage("Sync on Insert", new Object[0])));
        Checkbox syncOnUpdate = new Checkbox();
        syncOnUpdate.setId("syncOnUpdate");
        this.binder.forField((HasValue)syncOnUpdate).bind("syncOnUpdate");
        syncOnUpdate.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnUpdate, this.controller.getMessage("Sync on Update", new Object[0])));
        Checkbox syncOnDelete = new Checkbox();
        syncOnDelete.setId("syncOnDelete");
        this.binder.forField((HasValue)syncOnDelete).bind("syncOnDelete");
        syncOnDelete.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnDelete, this.controller.getMessage("Sync on Delete", new Object[0])));
        Select<String> reloadChannelId = this.getChannelIdSelect(this.controller.getMessage("Reload Channel Id", new Object[0]), "reloadChannelId", true);
        reloadChannelId.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)reloadChannelId, this.controller.getMessage("Reload Channel Id", new Object[0])));
        TextField syncOnInsertCondition = new TextField();
        syncOnInsertCondition.setId("syncOnInsertCondition");
        syncOnInsertCondition.setClassName("input-long");
        this.binder.forField((HasValue)syncOnInsertCondition).withValidator((SerializablePredicate & Serializable)value -> !value.equals(syncOnInsertCondition.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Sync on Insert Condition")).bind("syncOnInsertCondition");
        syncOnInsertCondition.setRequiredIndicatorVisible(!this.isBulk);
        syncOnInsertCondition.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnInsertCondition, this.controller.getMessage("Sync on Insert Condition", new Object[0])));
        TextField syncOnUpdateCondition = new TextField();
        syncOnUpdateCondition.setId("syncOnUpdateCondition");
        syncOnUpdateCondition.setClassName("input-long");
        this.binder.forField((HasValue)syncOnUpdateCondition).withValidator((SerializablePredicate & Serializable)value -> !value.equals(syncOnUpdateCondition.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Sync on Update Condition")).bind("syncOnUpdateCondition");
        syncOnUpdateCondition.setRequiredIndicatorVisible(!this.isBulk);
        syncOnUpdateCondition.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnUpdateCondition, this.controller.getMessage("Sync on Update Condition", new Object[0])));
        TextField syncOnDeleteCondition = new TextField();
        syncOnDeleteCondition.setId("syncOnDeleteCondition");
        syncOnDeleteCondition.setClassName("input-long");
        this.binder.forField((HasValue)syncOnDeleteCondition).withValidator((SerializablePredicate & Serializable)value -> !value.equals(syncOnDeleteCondition.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Sync on Delete Condition")).bind("syncOnDeleteCondition");
        syncOnDeleteCondition.setRequiredIndicatorVisible(!this.isBulk);
        syncOnDeleteCondition.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnDeleteCondition, this.controller.getMessage("Sync on Delete Condition", new Object[0])));
        this.hiddenFieldList = new ArrayList<R.a>();
        TextField customOnInsertText = new TextField();
        customOnInsertText.setId("customOnInsertText");
        this.binder.forField((HasValue)customOnInsertText).bind("customOnInsertText");
        this.hiddenFieldList.add(new R.a(this, (HasValue<?, ?>)customOnInsertText));
        TextField customOnDeleteText = new TextField();
        customOnDeleteText.setId("customOnDeleteText");
        this.binder.forField((HasValue)customOnDeleteText).bind("customOnDeleteText");
        this.hiddenFieldList.add(new R.a(this, (HasValue<?, ?>)customOnDeleteText));
        TextField customBeforeInsertText = new TextField();
        customBeforeInsertText.setId("customBeforeInsertText");
        this.binder.forField((HasValue)customBeforeInsertText).bind("customBeforeInsertText");
        this.hiddenFieldList.add(new R.a(this, (HasValue<?, ?>)customBeforeInsertText));
        TextField customBeforeUpdateText = new TextField();
        customBeforeUpdateText.setId("customBeforeUpdateText");
        this.binder.forField((HasValue)customBeforeUpdateText).bind("customBeforeUpdateText");
        this.hiddenFieldList.add(new R.a(this, (HasValue<?, ?>)customBeforeUpdateText));
        TextField customBeforeDeleteText = new TextField();
        customBeforeDeleteText.setId("customBeforeDeleteText");
        this.binder.forField((HasValue)customBeforeDeleteText).bind("customBeforeDeleteText");
        this.hiddenFieldList.add(new R.a(this, (HasValue<?, ?>)customBeforeDeleteText));
        am customOnUpdateText = new am(null);
        ArrayList fields = new ArrayList();
        fields.add((HasValue<?, String>)customBeforeInsertText);
        fields.add((HasValue<?, String>)customBeforeUpdateText);
        fields.add((HasValue<?, String>)customBeforeDeleteText);
        fields.add((HasValue<?, String>)customOnInsertText);
        fields.add((HasValue<?, String>)customOnUpdateText);
        fields.add((HasValue<?, String>)customOnDeleteText);
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add("Before Insert");
        descriptions.add("Before Update");
        descriptions.add("Before Delete");
        descriptions.add("After Insert");
        descriptions.add("After Update");
        descriptions.add("After Delete");
        q dialog = new q("Custom Trigger SQL", descriptions, customOnUpdateText, fields, 3, true, this.controller);
        dialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
        customOnUpdateText.addClickListener(dialog);
        customOnInsertText.addValueChangeListener((HasValue.ValueChangeListener)dialog);
        customOnDeleteText.addValueChangeListener((HasValue.ValueChangeListener)dialog);
        customBeforeInsertText.addValueChangeListener((HasValue.ValueChangeListener)dialog);
        customBeforeUpdateText.addValueChangeListener((HasValue.ValueChangeListener)dialog);
        customBeforeDeleteText.addValueChangeListener((HasValue.ValueChangeListener)dialog);
        customOnUpdateText.setId("customOnUpdateText");
        customOnUpdateText.getElement().getClassList().add((Object)"input-long");
        this.binder.forField((HasValue)customOnUpdateText).bind("customOnUpdateText");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)customOnUpdateText, this.controller.getMessage("Custom Trigger SQL", new Object[0])));
        Checkbox syncOnIncomingBatch = new Checkbox();
        syncOnIncomingBatch.setId("syncOnIncomingBatch");
        this.binder.forField((HasValue)syncOnIncomingBatch).bind("syncOnIncomingBatch");
        syncOnIncomingBatch.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnIncomingBatch, this.controller.getMessage("Sync on Incoming", new Object[0])));
        Checkbox useCaptureLobs = new Checkbox();
        useCaptureLobs.setId("useCaptureLobs");
        this.binder.forField((HasValue)useCaptureLobs).bind("useCaptureLobs");
        useCaptureLobs.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)useCaptureLobs, this.controller.getMessage("Capture Row As Lob", new Object[0])));
        this.useStreamLobs = new Checkbox();
        this.useStreamLobs.setId("useStreamLobs");
        this.binder.forField((HasValue)this.useStreamLobs).bind("useStreamLobs");
        this.useStreamLobs.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateCheckboxState());
        this.useStreamLobs.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)this.useStreamLobs, this.controller.getMessage("Stream Lobs", new Object[0])));
        this.streamRow = new Checkbox();
        this.streamRow.setId("streamRow");
        this.binder.forField((HasValue)this.streamRow).bind("streamRow");
        this.streamRow.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateCheckboxState());
        this.streamRow.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)this.streamRow, this.controller.getMessage("Stream Row", new Object[0])));
        Checkbox useCaptureOldData = new Checkbox();
        useCaptureOldData.setId("useCaptureOldData");
        this.binder.forField((HasValue)useCaptureOldData).bind("useCaptureOldData");
        useCaptureOldData.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)useCaptureOldData, this.controller.getMessage("Capture Old Data", new Object[0])));
        TextField externalSelect = new TextField();
        externalSelect.setId("externalSelect");
        externalSelect.setClassName("input-long");
        this.binder.forField((HasValue)externalSelect).bind("externalSelect");
        externalSelect.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)externalSelect, this.controller.getMessage("External Select", new Object[0])));
        TextField excludedColumnNames = new TextField();
        excludedColumnNames.setId("excludedColumnNames");
        excludedColumnNames.setClassName("input-long");
        this.binder.forField((HasValue)excludedColumnNames).bind("excludedColumnNames");
        excludedColumnNames.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)excludedColumnNames, this.controller.getMessage("Excluded Column Names", new Object[0])));
        TextField includedColumnNames = new TextField();
        includedColumnNames.setId("includedColumnNames");
        includedColumnNames.setClassName("input-long");
        this.binder.forField((HasValue)includedColumnNames).bind("includedColumnNames");
        includedColumnNames.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)includedColumnNames, this.controller.getMessage("Included Column Names", new Object[0])));
        TextField syncKeyNames = new TextField();
        syncKeyNames.setId("syncKeyNames");
        syncKeyNames.setClassName("input-long");
        this.binder.forField((HasValue)syncKeyNames).bind("syncKeyNames");
        syncKeyNames.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncKeyNames, this.controller.getMessage("Sync Key Names", new Object[0])));
        this.channelExpression = new TextField();
        this.channelExpression.setId("channelExpression");
        this.channelExpression.setClassName("input-long");
        this.binder.forField((HasValue)this.channelExpression).withValidator((SerializablePredicate & Serializable)value -> !value.equals(this.channelExpression.getEmptyValue()) || !"dynamic".equals(channelId.getValue()), "Channel expression is required when the channel is set to dynamic").bind("channelExpression");
        this.channelExpression.setVisible(false);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)this.channelExpression, this.controller.getMessage("Channel Expression", new Object[0])));
        this.timeBasedCaptureColumn = new TextField();
        this.timeBasedCaptureColumn.setId("timeBasedCaptureColumn");
        this.timeBasedCaptureColumn.setClassName("input-long");
        this.binder.forField((HasValue)this.timeBasedCaptureColumn).bind("timeBasedCaptureColumn");
        this.timeBasedCaptureColumn.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)this.timeBasedCaptureColumn, this.controller.getMessage("Time-Based Capture Column", new Object[0])));
    }

    private Select<String> getChannelIdSelect(String caption, String id, boolean includeReload) {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        boolean hideSystemChannels = this.controller.getSymmetricEngine().getParameterService().is("console.web.hide.system.info");
        ArrayList<String> channelIdList = new ArrayList<String>();
        String firstChannelId = null;
        for (NodeChannel nodeChannel : configService.getNodeChannels(false)) {
            String channelId = nodeChannel.getChannelId();
            if (channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("system")) continue;
            Channel channel = nodeChannel.getChannel();
            boolean include = !channel.isFileSyncFlag();
            include &= channel.isReloadFlag() && includeReload || !channel.isReloadFlag() && !includeReload;
            if (!(include &= !hideSystemChannels || !channelId.equals("dynamic") && !channelId.equals("monitor"))) continue;
            if (firstChannelId == null) {
                firstChannelId = channelId;
            }
            channelIdList.add(channelId);
        }
        channelIdList.sort(null);
        Select channelIdSelect = new Select();
        channelIdSelect.setItems(channelIdList);
        channelIdSelect.setId(id);
        this.formatComboBox(channelIdSelect);
        this.binder.forField((HasValue)channelIdSelect).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", caption)).bind(id);
        channelIdSelect.setRequiredIndicatorVisible(!this.isBulk);
        channelIdSelect.setValue(firstChannelId);
        return channelIdSelect;
    }

    protected void updateCheckboxState() {
        if (((Boolean)this.streamRow.getValue()).booleanValue()) {
            this.useStreamLobs.setEnabled(false);
            this.useStreamLobs.setValue((Object)false);
        } else if (((Boolean)this.useStreamLobs.getValue()).booleanValue()) {
            this.streamRow.setEnabled(false);
            this.streamRow.setValue((Object)false);
        } else {
            this.streamRow.setEnabled(true);
            this.useStreamLobs.setEnabled(true);
        }
    }

    @Override
    protected void generateNewItem() {
        Trigger trigger = new Trigger();
        trigger.setTriggerId("");
        trigger.setCreateTime(new Date());
        trigger.setLastUpdateTime(new Date());
        trigger.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        this.newItem = trigger;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            if (!this.isBulk) {
                if (!this.newItemFlag) {
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((Trigger)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((Trigger)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    Trigger trigger = saveAsCopy ? (Trigger)this.newItem : (Trigger)this.itemSet.iterator().next();
                    HashSet<Trigger> newTriggerSet = new HashSet<Trigger>();
                    newTriggerSet.add(trigger);
                    this.saveTriggers(saveAsCopy, newTriggerSet);
                } else {
                    try {
                        this.binder.writeBean((Object)((Trigger)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    Trigger trigger = (Trigger)this.newItem;
                    HashSet<Trigger> newTriggerSet = new HashSet<Trigger>();
                    newTriggerSet.add(trigger);
                    this.saveTriggers(saveAsCopy, newTriggerSet);
                }
            } else {
                for (Trigger trigger : this.itemSet) {
                    this.saveFieldsToTrigger(this.fieldList, trigger);
                    this.saveFieldsToTrigger(this.advancedFieldList, trigger);
                    this.saveFieldsToTrigger(this.hiddenFieldList, trigger);
                }
                this.saveTriggers(saveAsCopy, this.itemSet);
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToTrigger(List<R.a> fields, Trigger trigger) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "sourceCatalogName": {
                    trigger.setSourceCatalogName((String)field.getValue());
                    break;
                }
                case "sourceSchemaName": {
                    trigger.setSourceSchemaName((String)field.getValue());
                    break;
                }
                case "sourceTableName": {
                    trigger.setSourceTableName((String)field.getValue());
                    break;
                }
                case "channelId": {
                    trigger.setChannelId((String)field.getValue());
                    break;
                }
                case "syncOnInsert": {
                    trigger.setSyncOnInsert(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnUpdate": {
                    trigger.setSyncOnUpdate(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnDelete": {
                    trigger.setSyncOnDelete(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "reloadChannelId": {
                    trigger.setReloadChannelId((String)field.getValue());
                    break;
                }
                case "syncOnInsertCondition": {
                    trigger.setSyncOnInsertCondition((String)field.getValue());
                    break;
                }
                case "syncOnUpdateCondition": {
                    trigger.setSyncOnUpdateCondition((String)field.getValue());
                    break;
                }
                case "syncOnDeleteCondition": {
                    trigger.setSyncOnDeleteCondition((String)field.getValue());
                    break;
                }
                case "customOnInsertText": {
                    trigger.setCustomOnInsertText((String)field.getValue());
                    break;
                }
                case "customOnUpdateText": {
                    trigger.setCustomOnUpdateText((String)field.getValue());
                    break;
                }
                case "customOnDeleteText": {
                    trigger.setCustomOnDeleteText((String)field.getValue());
                    break;
                }
                case "customBeforeInsertText": {
                    trigger.setCustomBeforeInsertText((String)field.getValue());
                    break;
                }
                case "customBeforeUpdateText": {
                    trigger.setCustomBeforeUpdateText((String)field.getValue());
                    break;
                }
                case "customBeforeDeleteText": {
                    trigger.setCustomBeforeDeleteText((String)field.getValue());
                    break;
                }
                case "syncOnIncomingBatch": {
                    trigger.setSyncOnIncomingBatch(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "useCaptureLobs": {
                    trigger.setUseCaptureLobs(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "useStreamLobs": {
                    trigger.setUseStreamLobs(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "streamRow": {
                    trigger.setStreamRow(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "useCaptureOldData": {
                    trigger.setUseCaptureOldData(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "externalSelect": {
                    trigger.setExternalSelect((String)field.getValue());
                    break;
                }
                case "excludedColumnNames": {
                    trigger.setExcludedColumnNames((String)field.getValue());
                    break;
                }
                case "includedColumnNames": {
                    trigger.setIncludedColumnNames((String)field.getValue());
                    break;
                }
                case "syncKeyNames": {
                    trigger.setSyncKeyNames((String)field.getValue());
                }
                case "timeBasedCaptureColumn": {
                    trigger.setTimeBasedCaptureColumn((String)field.getValue());
                }
            }
        }
    }

    private void saveTriggers(final boolean saveAsCopy, final Set<Trigger> triggers) {
        M<Object> dialog = new M<Object>("Saving Table Capture...", new M.a<Object>(){
            boolean lockNotAcquired;
            Lock lock;

            @Override
            public Object doWork() {
                ITriggerRouterService triggerRouterService = al.this.controller.getSymmetricEngine().getTriggerRouterService();
                boolean isRename = false;
                for (Trigger trigger : triggers) {
                    trigger.setLastUpdateBy(al.this.controller.getConsoleUser().getUserId());
                    if (saveAsCopy) {
                        triggerRouterService.saveTriggerAsCopy(al.this.originalId, trigger);
                        continue;
                    }
                    if (al.this.originalId == null || al.this.originalId.equals(trigger.getTriggerId())) continue;
                    triggerRouterService.renameTrigger(al.this.originalId, trigger);
                    isRename = true;
                }
                if (!saveAsCopy && !isRename) {
                    if (al.this.newItemFlag) {
                        triggerRouterService.insertTriggers((Collection)triggers);
                    } else {
                        triggerRouterService.updateTriggers((Collection)triggers);
                    }
                }
                if (!al.this.controller.getSymmetricEngine().getParameterService().is("auto.sync.triggers.after.config.change") && !triggerRouterService.syncTriggers(new ArrayList(triggers), null, false, true)) {
                    this.lockNotAcquired = true;
                    this.lock = (Lock)al.this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
                }
                return null;
            }

            @Override
            public void doUI(Object data) {
                al.this.addEvent(al.this.newItemFlag ? "Table Capture Created" : "Table Capture Modified", triggers.stream().map(Trigger::getTriggerId).collect(Collectors.toSet()));
                if (this.lockNotAcquired) {
                    as.notifySyncTriggersLockNotAcquired(this.lock);
                }
                if (al.this.formListener != null) {
                    al.this.formListener.formSaved();
                }
            }
        }, this.controller.getBackgroundRefresherService());
        dialog.show();
    }

    @Override
    public void delete() {
        M<Object> dialog = new M<Object>("Deleting Table Capture...", new M.a<Object>(){
            boolean lockNotAcquired;
            Lock lock;

            @Override
            public Object doWork() {
                ITriggerRouterService triggerRouterService = al.this.controller.getSymmetricEngine().getTriggerRouterService();
                triggerRouterService.deleteTriggers((Collection)al.this.itemSet);
                if (!al.this.controller.getSymmetricEngine().getParameterService().is("auto.sync.triggers.after.config.change") && !triggerRouterService.syncTriggers(new ArrayList(al.this.itemSet), null, false, true)) {
                    this.lockNotAcquired = true;
                    this.lock = (Lock)al.this.controller.getSymmetricEngine().getClusterService().findLocks().get("SyncTriggers");
                }
                return null;
            }

            @Override
            public void doUI(Object data) {
                al.this.addEvent("Table Capture Deleted", al.this.itemSet.stream().map(Trigger::getTriggerId).collect(Collectors.toSet()));
                if (this.lockNotAcquired) {
                    as.notifySyncTriggersLockNotAcquired(this.lock);
                }
                al.this.panel.onRefresh(new Object[0]);
            }
        }, this.controller.getBackgroundRefresherService());
        dialog.show();
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        if (!this.isBulk) {
            orderedFields.add(IDENTIFIER);
            orderedFields.add("sourceCatalogName");
            orderedFields.add("sourceSchemaName");
        }
        orderedFields.add("sourceTableName");
        orderedFields.add("channelId");
        orderedFields.add("syncOnInsert");
        orderedFields.add("syncOnUpdate");
        orderedFields.add("syncOnDelete");
        orderedFields.add("reloadChannelId");
        if (this.isBulk) {
            orderedFields.add("sourceCatalogName");
            orderedFields.add("sourceSchemaName");
        }
        orderedFields.add("syncOnInsertCondition");
        orderedFields.add("syncOnUpdateCondition");
        orderedFields.add("syncOnDeleteCondition");
        orderedFields.add("customOnInsertText");
        orderedFields.add("customOnUpdateText");
        orderedFields.add("customOnDeleteText");
        orderedFields.add("customBeforeInsertText");
        orderedFields.add("customBeforeUpdateText");
        orderedFields.add("customBeforeDeleteText");
        orderedFields.add("syncOnIncomingBatch");
        orderedFields.add("useCaptureLobs");
        orderedFields.add("useStreamLobs");
        orderedFields.add("streamRow");
        orderedFields.add("useCaptureOldData");
        orderedFields.add("externalSelect");
        orderedFields.add("excludedColumnNames");
        orderedFields.add("includedColumnNames");
        orderedFields.add("syncKeyNames");
        orderedFields.add("timeBasedCaptureColumn");
        if (!this.isBulk) {
            orderedFields.add("channelExpression");
        }
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return IDENTIFIER;
    }

    @Override
    public String getHelpSectionName() {
        return "_table_triggers";
    }
}

