/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.ga;
import com.jumpmind.symmetric.console.model.Monitor;
import com.jumpmind.symmetric.console.model.Notification;
import com.jumpmind.symmetric.console.service.IMonitorService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.Slider;
import com.jumpmind.symmetric.console.ui.common.ah;
import com.jumpmind.symmetric.console.ui.common.as;
import com.jumpmind.symmetric.console.ui.common.w;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.converter.StringToLongConverter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class af
extends R<Monitor> {
    private static final long serialVersionUID = 1L;
    Slider severityLevel;
    R.a isInsightField;
    String originalId;
    boolean originalIsInsight;
    int originalSeverityLevel;
    List<Notification> notificationList;
    Set<Notification> changedNotificationSet = new HashSet<Notification>();

    public af(I controller, Set<Monitor> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((Monitor)this.itemSet.iterator().next()).getMonitorId();
        }
        this.originalIsInsight = !this.newItemFlag;
        for (Monitor monitor2 : this.itemSet) {
            this.originalIsInsight &= monitor2.isInsight();
            this.originalSeverityLevel = Math.max(this.originalSeverityLevel, monitor2.getSeverityLevel());
        }
        this.binder = new Binder(Monitor.class);
        TextField monitorId = new TextField();
        monitorId.setId("monitorId");
        this.binder.forField((HasValue)monitorId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Monitor Id")).bind("monitorId");
        monitorId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)monitorId, this.controller.getMessage("Monitor Id", new Object[0])));
        ArrayList<Object> targetNodeList = new ArrayList<Object>();
        targetNodeList.add(this.controller.getSymmetricEngine().getParameterService().getExternalId() + " only");
        targetNodeList.add("ALL");
        for (NodeGroup nodeGroup : this.controller.getSymmetricEngine().getConfigurationService().getNodeGroups()) {
            targetNodeList.add(nodeGroup.getNodeGroupId());
        }
        Select targetNode = new Select();
        targetNode.setItems(targetNodeList);
        if (this.itemSet.size() == 1 && !targetNodeList.contains(((Monitor)this.itemSet.iterator().next()).getTargetNode())) {
            String currentTargetNode = ((Monitor)this.itemSet.iterator().next()).getTargetNode();
            targetNodeList.add(currentTargetNode);
            targetNode.setItems(targetNodeList);
            targetNode.setValue((Object)currentTargetNode);
        }
        targetNode.setId("targetNode");
        this.formatComboBox(targetNode);
        this.binder.forField((HasValue)targetNode).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Target Nodes")).bind("targetNode");
        targetNode.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)targetNode, this.controller.getMessage("Target Nodes", new Object[0])));
        ArrayList<String> typeList = new ArrayList<String>();
        for (ga type : this.controller.getSymmetricEngine().getExtensionService().getExtensionPointList(ga.class)) {
            typeList.add(type.b());
        }
        typeList.sort((t0, t1) -> as.formatMonitorType(t0).compareToIgnoreCase(as.formatMonitorType(t1)));
        Select type = new Select();
        type.setItems(typeList);
        type.setId("type");
        this.formatComboBox(type);
        type.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> as.formatMonitorType(item));
        this.binder.forField((HasValue)type).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Monitor Type")).bind("type");
        type.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)type, this.controller.getMessage("Monitor Type", new Object[0])));
        TextField expression = new TextField();
        expression.setId("expression");
        this.binder.forField((HasValue)expression).bind("expression");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)expression, this.controller.getMessage("Expression", new Object[0])));
        TextField threshold = new TextField();
        threshold.setId("threshold");
        this.binder.forField((HasValue)threshold).withConverter((Converter)new StringToLongConverter(this.controller.getMessage("Threshold must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Threshold")).bind("threshold");
        threshold.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)threshold, this.controller.getMessage("Threshold", new Object[0])));
        IJob monitorJob = this.controller.getSymmetricEngine().getJobManager().getJob("Monitor");
        if (monitorJob.getSchedule().trim().contains(" ")) {
            TextField runPeriod = new TextField();
            ((Component)runPeriod).setId("runPeriod");
            runPeriod.setRequiredIndicatorVisible(!this.isBulk);
            this.binder.forField((HasValue)runPeriod).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Run Period (seconds)")).bind("runPeriod");
            this.fieldList.add(new R.a(this, (HasValue<?, ?>)runPeriod, this.controller.getMessage("Run Period (seconds)", new Object[0])));
        } else {
            w runPeriod = new w(null);
            ((Component)runPeriod).setId("runPeriod");
            runPeriod.setButtonCaption(this.controller.getMessage("Customize", new Object[0]));
            runPeriod.addClickListener((ComponentEventListener<ClickEvent<Button>>)((ComponentEventListener & Serializable)arg_0 -> this.lambda$initFields$f1538fca$1((HasValue)runPeriod, arg_0)));
            Span runPeriodSpan = new Span();
            int jobPeriod = Integer.parseInt(monitorJob.getSchedule());
            HasValue.ValueChangeListener & Serializable listener = (HasValue.ValueChangeListener & Serializable)event -> {
                int monitorPeriod = Integer.parseInt(((String)event.getValue()).replace(",", "")) * 1000;
                if (monitorPeriod <= jobPeriod) {
                    runPeriodSpan.setText("Runs every " + as.formatDurationFull(jobPeriod) + " with monitor job");
                } else {
                    runPeriodSpan.setText("Runs every " + as.formatDurationFull((long)Math.ceil((double)monitorPeriod / (double)jobPeriod) * (long)jobPeriod));
                }
            };
            runPeriod.addValueChangeListener(listener);
            this.binder.forField((HasValue)runPeriod).bind((ValueProvider & Serializable)monitor -> String.valueOf(monitor.getRunPeriod()), (Setter & Serializable)(monitor, val) -> monitor.setRunPeriod(Integer.parseInt(val)));
            this.fieldList.add(new R.a(this, (HasValue<?, ?>)runPeriod, this.controller.getMessage("Run Period", new Object[0]), (Component)runPeriodSpan));
        }
        TextField runCount = new TextField();
        runCount.setWidth("8em");
        if (this.isBulk) {
            runCount.getStyle().set("padding-left", "16px");
        }
        runCount.setValue("0");
        runCount.setId("runCount");
        this.binder.forField((HasValue)runCount).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Run Count must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Run Count")).bind("runCount");
        runCount.setRequiredIndicatorVisible(!this.isBulk);
        boolean isRunCountSet = !this.newItemFlag && !this.isBulk && ((Monitor)this.itemSet.iterator().next()).getRunCount() > 1;
        runCount.setEnabled(isRunCountSet);
        HorizontalLayout runCountComponents = new HorizontalLayout();
        Checkbox takeAverage = new Checkbox(this.controller.getMessage("Take an average from multiple runs", new Object[0]));
        takeAverage.setValue((Object)isRunCountSet);
        takeAverage.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (((Boolean)event.getValue()).booleanValue()) {
                runCount.setEnabled(true);
            } else {
                runCount.setEnabled(false);
                runCount.setValue("0");
            }
        });
        runCountComponents.add(new Component[]{takeAverage});
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)runCount, this.controller.getMessage("Run Count", new Object[0]), (Component)runCountComponents));
        this.severityLevel = new Slider(1, 3);
        this.severityLevel.setId("severityLevel");
        Map<Integer, String> severityLevelNames = Monitor.getSeverityLevelNames();
        Span severityLevelSpan = new Span(severityLevelNames.get(100));
        this.severityLevel.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> severityLevelSpan.setText((String)severityLevelNames.get((Integer)event.getValue() * 100)));
        this.severityLevel.setValue(this.newItemFlag ? 1 : ((Monitor)this.itemSet.iterator().next()).getSeverityLevel() / 100);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)this.severityLevel, this.controller.getMessage("Severity Level", new Object[0]), (Component)severityLevelSpan));
        TextField displayOrder = new TextField();
        displayOrder.setId("displayOrder");
        this.binder.forField((HasValue)displayOrder).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Display Order must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Display Order")).bind("displayOrder");
        displayOrder.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)displayOrder, this.controller.getMessage("Display Order", new Object[0])));
        Checkbox isInsight = new Checkbox();
        isInsight.setId("insight");
        this.binder.forField((HasValue)isInsight).bind("insight");
        this.isInsightField = new R.a(this, (HasValue<?, ?>)isInsight, this.controller.getMessage("Is Insight", new Object[0]));
        this.fieldList.add(this.isInsightField);
        Checkbox isPinned = new Checkbox();
        isPinned.setId("pinned");
        this.binder.forField((HasValue)isPinned).bind("pinned");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)isPinned, this.controller.getMessage("Is Pinned", new Object[0])));
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        Monitor monitor = new Monitor();
        monitor.setExternalId("ALL");
        monitor.setNodeGroupId("ALL");
        monitor.setSeverityLevel(Monitor.getSeverityLevelNames().keySet().iterator().next());
        monitor.setEnabled(true);
        this.newItem = monitor;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            Command & Serializable callback = (Command & Serializable)() -> {
                if (!this.isBulk) {
                    Monitor monitor;
                    if (!this.newItemFlag) {
                        try {
                            if (saveAsCopy) {
                                if (this.newItem == null) {
                                    this.generateNewItem();
                                }
                                this.binder.writeBean((Object)((Monitor)this.newItem));
                            } else {
                                this.binder.writeBean((Object)((Monitor)this.itemSet.iterator().next()));
                            }
                        }
                        catch (ValidationException e2) {
                            CommonUiUtils.notify((String)"Failed to write to bean");
                        }
                        monitor = saveAsCopy ? (Monitor)this.newItem : (Monitor)this.itemSet.iterator().next();
                    } else {
                        try {
                            this.binder.writeBean((Object)((Monitor)this.newItem));
                        }
                        catch (ValidationException e3) {
                            CommonUiUtils.notify((String)"Failed to write to bean");
                        }
                        monitor = (Monitor)this.newItem;
                    }
                    monitor.setSeverityLevel((Integer)this.severityLevel.getValue() * 100);
                    this.saveMonitor(saveAsCopy, monitor);
                    this.addEvent(this.newItemFlag ? "Monitor Created" : "Monitor Modified", monitor.getMonitorId());
                } else {
                    for (Monitor monitor : this.itemSet) {
                        for (R.a formField : this.fieldList) {
                            HasValue<?, ?> field = formField.getField();
                            Checkbox checkbox = formField.getCheckbox();
                            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
                            switch (((Component)field).getId().orElse("")) {
                                case "targetNode": {
                                    monitor.setTargetNode((String)field.getValue());
                                    break;
                                }
                                case "type": {
                                    monitor.setType((String)field.getValue());
                                    break;
                                }
                                case "expression": {
                                    monitor.setExpression((String)field.getValue());
                                    break;
                                }
                                case "threshold": {
                                    monitor.setThreshold(Long.valueOf((String)field.getValue()));
                                    break;
                                }
                                case "runPeriod": {
                                    monitor.setRunPeriod(Integer.valueOf((String)field.getValue()));
                                    break;
                                }
                                case "runCount": {
                                    monitor.setRunCount(Integer.valueOf((String)field.getValue()));
                                    break;
                                }
                                case "severityLevel": {
                                    monitor.setSeverityLevel((Integer)this.severityLevel.getValue() * 100);
                                    break;
                                }
                                case "displayOrder": {
                                    monitor.setDisplayOrder(Integer.valueOf((String)field.getValue()));
                                    break;
                                }
                                case "insight": {
                                    monitor.setInsight((Boolean)field.getValue());
                                    break;
                                }
                                case "pinned": {
                                    monitor.setPinned((Boolean)field.getValue());
                                    break;
                                }
                                case "enabled": {
                                    monitor.setEnabled((Boolean)field.getValue());
                                }
                            }
                        }
                        this.saveMonitor(saveAsCopy, monitor);
                    }
                    this.addEvent("Monitor Modified", this.itemSet.stream().map(Monitor::getMonitorId).collect(Collectors.toSet()));
                }
                this.saveNotifications();
                if (this.formListener != null) {
                    this.formListener.formSaved();
                }
            };
            if (!this.originalIsInsight && ((Boolean)((Checkbox)this.isInsightField.getField()).getValue()).booleanValue() && (!this.isBulk || this.isInsightField.getCheckbox() != null && ((Boolean)this.isInsightField.getCheckbox().getValue()).booleanValue())) {
                this.formListener.getFormLayout().enableCancelShortcut(false);
                new ConfirmDialog(this.controller.getMessage("Confirm Changes", new Object[0]), this.controller.getMessage("You checked the \"Is Insight\" box. Insights don't trigger notifications and they're displayed via the Dashboard tab's Insight Manager and Insights Dialog instead of the Manage Monitors screen. Are you sure that you want to save your changes?", new Object[0]), this.controller.getMessage("Yes", new Object[0]), (ComponentEventListener & Serializable)e2 -> {
                    callback.execute();
                    this.formListener.closeForm(true);
                }, this.controller.getMessage("No", new Object[0]), (ComponentEventListener & Serializable)e2 -> this.formListener.getFormLayout().enableCancelShortcut(true)).open();
                return false;
            }
            callback.execute();
            return true;
        }
        return false;
    }

    public void saveMonitor(boolean saveAsCopy, Monitor monitor) {
        if (monitor.getTargetNode().endsWith(" only")) {
            monitor.setExternalId(this.controller.getSymmetricEngine().getParameterService().getExternalId());
            monitor.setNodeGroupId(this.controller.getSymmetricEngine().getParameterService().getNodeGroupId());
        } else {
            monitor.setNodeGroupId(monitor.getTargetNode());
            monitor.setExternalId("ALL");
        }
        monitor.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        monitor.setLastUpdateTime(new Date());
        IMonitorService monitorService = this.controller.getMonitorService();
        if (saveAsCopy) {
            monitorService.saveMonitorAsCopy(monitor);
        } else {
            if (!this.newItemFlag) {
                if (!this.originalIsInsight && monitor.isInsight()) {
                    this.updateNotifications(this.isBulk ? monitor.getMonitorId() : this.originalId);
                } else {
                    int newSeverityLevel = monitor.getSeverityLevel();
                    if (this.originalSeverityLevel > newSeverityLevel) {
                        this.updateNotifications(this.isBulk ? monitor.getMonitorId() : this.originalId, newSeverityLevel);
                    }
                }
            }
            if (this.isBulk || this.newItemFlag || this.originalId == null || this.originalId.equals(monitor.getMonitorId())) {
                monitorService.saveMonitor(monitor);
            } else {
                monitorService.renameMonitor(this.originalId, monitor);
                this.updateNotifications(this.originalId, monitor.getMonitorId());
            }
        }
    }

    @Override
    public void delete() {
        IMonitorService monitorService = this.controller.getMonitorService();
        for (Monitor monitor : this.itemSet) {
            String monitorId = monitor.getMonitorId();
            monitorService.deleteMonitor(monitorId);
            if (monitor.isInsight()) continue;
            this.updateNotifications(monitorId);
        }
        this.addEvent("Monitor Deleted", this.itemSet.stream().map(Monitor::getMonitorId).collect(Collectors.toSet()));
        this.saveNotifications();
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    protected void updateNotifications(String monitorIdToRemove) {
        this.updateNotifications(monitorIdToRemove, null, null);
    }

    protected void updateNotifications(String monitorIdToRemove, String monitorIdToAdd) {
        this.updateNotifications(monitorIdToRemove, monitorIdToAdd, null);
    }

    protected void updateNotifications(String monitorIdToRemove, Integer monitorSeverity) {
        this.updateNotifications(monitorIdToRemove, null, monitorSeverity);
    }

    protected void updateNotifications(String monitorIdToRemove, String monitorIdToAdd, Integer monitorSeverity) {
        if (this.notificationList == null) {
            this.notificationList = this.controller.getMonitorService().getNotifications();
        }
        for (Notification notification : this.notificationList) {
            Notification.Expression expression;
            List<String> monitorIdList;
            if (monitorSeverity != null && monitorSeverity >= notification.getSeverityLevel() || !(monitorIdList = (expression = notification.getExpression()).getMonitorIds()).contains(monitorIdToRemove)) continue;
            monitorIdList.remove(monitorIdToRemove);
            if (monitorIdToAdd != null) {
                monitorIdList.add(monitorIdToAdd);
            }
            notification.setExpression(expression);
            this.changedNotificationSet.add(notification);
        }
    }

    protected void saveNotifications() {
        if (!this.changedNotificationSet.isEmpty()) {
            IMonitorService monitorService = this.controller.getMonitorService();
            for (Notification notification : this.changedNotificationSet) {
                monitorService.saveNotification(notification);
            }
            this.addEvent("Notification Modified", this.changedNotificationSet.stream().map(Notification::getNotificationId).collect(Collectors.toSet()));
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("monitorId");
        orderedFields.add("targetNode");
        orderedFields.add("type");
        orderedFields.add("expression");
        orderedFields.add("threshold");
        orderedFields.add("runPeriod");
        orderedFields.add("runCount");
        orderedFields.add("severityLevel");
        orderedFields.add("displayOrder");
        orderedFields.add("insight");
        orderedFields.add("pinned");
        orderedFields.add("enabled");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "monitorId";
    }

    @Override
    public String getHelpSectionName() {
        return "_monitors";
    }

    private /* synthetic */ void lambda$initFields$f1538fca$1(HasValue runPeriod, ClickEvent event) {
        ah dialog = new ah(this.controller, runPeriod);
        dialog.addOpenedChangeListener((ComponentEventListener & Serializable)e2 -> this.formListener.getFormLayout().enableCancelShortcut(!e2.isOpened()));
        dialog.open();
    }
}

