/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.eatthepath.otp.TimeBasedOneTimePasswordGenerator;
import com.eatthepath.otp.UncheckedNoSuchAlgorithmException;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.jumpmind.symmetric.console.impl.aG;
import com.jumpmind.symmetric.console.impl.aJ;
import com.jumpmind.symmetric.console.model.ConsoleEvent;
import com.jumpmind.symmetric.console.model.ConsoleUser;
import com.jumpmind.symmetric.console.service.IConsoleUserService;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.aq;
import com.jumpmind.symmetric.console.ui.common.as;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.DownloadResponse;
import com.vaadin.flow.server.streams.InputStreamDownloadCallback;
import com.vaadin.flow.server.streams.InputStreamDownloadHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.time.Instant;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class aI
extends aq
implements aJ {
    private static final long b = 1L;
    final Logger a = LoggerFactory.getLogger(this.getClass());
    private TextField c;
    private String d;
    private aJ e;

    public aI(aJ loginListener, ConsoleUser user, I controller) {
        super(controller, "Multifactor Login", new Object[0]);
        this.e = loginListener;
        this.setWidth("400px");
        this.setResizable(false);
        controller.setPageTitle("Multifactor Login");
        this.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (!event.isOpened()) {
                controller.setPageTitle(null);
            }
        });
        VerticalLayout layout = new VerticalLayout();
        layout.setClassName("dialog-content");
        layout.addAndExpand(new Component[]{new Span()});
        if (user.getOtpKey() == null) {
            String userId = user.getFirstName() + " " + user.getLastName();
            String companyName = "SymmetricDS";
            this.d = aI.b();
            String barCodeUrl = aI.a(this.d, companyName, "User: " + userId);
            try {
                long rand_int1 = System.currentTimeMillis();
                InputStreamDownloadHandler downloadHandler = DownloadHandler.fromInputStream((InputStreamDownloadCallback & Serializable)event -> {
                    try {
                        BufferedImage image = aI.a(barCodeUrl, 275, 275);
                        ByteArrayOutputStream imagebuffer = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)image, "png", imagebuffer);
                        byte[] imageBytes = imagebuffer.toByteArray();
                        return new DownloadResponse((InputStream)new ByteArrayInputStream(imageBytes), "QRCode" + rand_int1 + ".png", null, (long)imageBytes.length);
                    }
                    catch (WriterException e2) {
                        return DownloadResponse.error((HttpStatusCode)HttpStatusCode.INTERNAL_SERVER_ERROR);
                    }
                });
                Image qr = new Image((DownloadHandler)downloadHandler, "Scan this QR code");
                layout.add(new Component[]{qr});
                layout.setHorizontalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{qr});
                super.close();
            }
            catch (Exception e2) {
                this.a.error("Unable to generate QR code", (Throwable)e2);
            }
        } else {
            this.d = user.getOtpKey();
        }
        this.c = new TextField(controller.getMessage("6-digit Passcode", new Object[0]));
        this.c.setWidthFull();
        layout.add(new Component[]{this.c});
        Button loginButton = as.createPrimaryButton(controller.getMessage("Login", new Object[0]), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> this.a(this.c.getValue(), user));
        Button normalLoginButton = as.createLinkButton("Back to Login Prompt", null, (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.close();
            new aG(loginListener, controller).open();
        });
        this.getFooter().add(new Component[]{normalLoginButton, loginButton});
        this.addAndExpand(new Component[]{layout});
        this.a();
    }

    public void a() {
        this.c.focus();
    }

    protected void a(String otpCode, ConsoleUser user) {
        IConsoleUserService userService = this.controller.getConsoleUserService();
        if (!user.isEnabled()) {
            CommonUiUtils.notify((String)String.format("User '%s' has been disabled.  Please contact an admin to reset your password.", user.getUserId()));
            Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(user.getUserId(), "Console User Disabled", identity.getNodeId(), identity.getNodeId(), null, null));
        } else if (StringUtils.isNumeric((CharSequence)otpCode) && otpCode != null && !otpCode.equalsIgnoreCase("")) {
            if (Integer.parseInt(otpCode) == aI.a(this.d)) {
                this.close();
                user.setOtpKey(this.d);
                user.setFailedLoginAttempts(0);
                this.a(user, true);
            } else {
                int maxFailedLoginAttempts;
                if (user.getOtpKey() != null && (maxFailedLoginAttempts = this.controller.getSymmetricEngine().getParameterService().getInt("console.password.failed.attempts", 0)) > 0) {
                    int failedLoginAttempts = user.getFailedLoginAttempts() + 1;
                    user.setFailedLoginAttempts(failedLoginAttempts);
                    if (failedLoginAttempts >= maxFailedLoginAttempts) {
                        user.setEnabled(false);
                    }
                }
                CommonUiUtils.notify((String)String.format("Code incorrect", new Object[0]));
            }
        } else {
            CommonUiUtils.notify((String)String.format("Enter 6-digit numeric code.", new Object[0]));
        }
        userService.save(user);
    }

    public static String b() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        return base32.encodeToString(bytes);
    }

    public static int a(String secretKey) {
        Base32 base32 = new Base32();
        byte[] bytes = base32.decode(secretKey);
        TimeBasedOneTimePasswordGenerator totp = null;
        try {
            totp = new TimeBasedOneTimePasswordGenerator();
        }
        catch (UncheckedNoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        Instant now = Instant.now();
        try {
            SecretKeySpec key = new SecretKeySpec(bytes, 0, bytes.length, "AES");
            return totp.generateOneTimePassword((Key)key, now);
        }
        catch (InvalidKeyException e3) {
            throw new RuntimeException(e3);
        }
    }

    public static String a(String secretKey, String account, String issuer) {
        try {
            return "otpauth://totp/" + URLEncoder.encode(issuer + ":" + account, "UTF-8").replace("+", "%20") + "?secret=" + URLEncoder.encode(secretKey, "UTF-8").replace("+", "%20") + "&issuer=" + URLEncoder.encode(issuer, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static BufferedImage a(String barCodeData, int height, int width) throws WriterException, IOException {
        BitMatrix matrix = new MultiFormatWriter().encode(barCodeData, BarcodeFormat.QR_CODE, width, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
    }

    @Override
    public void a(ConsoleUser user, boolean enableLogout) {
        this.e.a(user, enableLogout);
        Node identity = this.controller.getSymmetricEngine().getNodeService().findIdentity();
        String ip = VaadinSession.getCurrent().getBrowser().getAddress();
        if (identity != null) {
            this.controller.getConsoleEventService().addEvent(new ConsoleEvent(user.getUserId(), "Console User Login", identity.getNodeId(), identity.getNodeId(), null, ip));
            this.controller.getConsoleUserService().login(user);
        }
        this.a.info("Login for " + user.getUserId() + " from " + ip);
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "lambda$new$f82c5515$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/LoginDialogOTP") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/screen/LoginListener;Lcom/jumpmind/symmetric/console/ui/common/IUIController;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((aI)lambda.getCapturedArg(0)).a((aJ)lambda.getCapturedArg(1), (I)lambda.getCapturedArg(2), arg_0);
            }
            case "lambda$new$be21bff$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/server/streams/InputStreamDownloadCallback") || !lambda.getFunctionalInterfaceMethodName().equals("complete") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/LoginDialogOTP") || !lambda.getImplMethodSignature().equals("(Ljava/lang/String;JLcom/vaadin/flow/server/streams/DownloadEvent;)Lcom/vaadin/flow/server/streams/DownloadResponse;")) break;
                return arg_0 -> aI.a((String)lambda.getCapturedArg(0), (Long)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$new$c7dfe46d$1": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/LoginDialogOTP") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/model/ConsoleUser;Lcom/vaadin/flow/component/ClickEvent;)V")) break;
                return arg_0 -> ((aI)lambda.getCapturedArg(0)).a((ConsoleUser)lambda.getCapturedArg(1), arg_0);
            }
            case "lambda$new$4e4a8b06$1": {
                if (lambda.getImplMethodKind() != 6 || !lambda.getFunctionalInterfaceClass().equals("com/vaadin/flow/component/ComponentEventListener") || !lambda.getFunctionalInterfaceMethodName().equals("onComponentEvent") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Lcom/vaadin/flow/component/ComponentEvent;)V") || !lambda.getImplClass().equals("com/jumpmind/symmetric/console/ui/screen/LoginDialogOTP") || !lambda.getImplMethodSignature().equals("(Lcom/jumpmind/symmetric/console/ui/common/IUIController;Lcom/vaadin/flow/component/dialog/Dialog$OpenedChangeEvent;)V")) break;
                return arg_0 -> aI.a((I)lambda.getCapturedArg(0), arg_0);
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

