/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.fL;
import com.jumpmind.symmetric.console.ui.common.I;
import com.jumpmind.symmetric.console.ui.common.k;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class X
extends R<FileTrigger> {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "identifier";
    private String originalId;

    public X(I controller, Set<FileTrigger> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((FileTrigger)this.itemSet.iterator().next()).getTriggerId();
        }
        this.binder = new Binder(FileTrigger.class);
        TextField identifier = new TextField();
        identifier.setId(IDENTIFIER);
        identifier.setWidth("20em");
        this.binder.forField((HasValue)identifier).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Identifier")).bind("triggerId");
        identifier.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)identifier, this.controller.getMessage("Identifier", new Object[0])));
        Select<String> channelId = this.getChannelIdSelect(this.controller.getMessage("Channel Id", new Object[0]), "channelId", false);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)channelId, this.controller.getMessage("Channel Id", new Object[0])));
        Select<String> reloadChannelId = this.getChannelIdSelect(this.controller.getMessage("Reload Channel Id", new Object[0]), "reloadChannelId", true);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)reloadChannelId, this.controller.getMessage("Reload Channel Id", new Object[0])));
        TextField baseDir = new TextField();
        baseDir.setId("baseDir");
        baseDir.setWidth("20em");
        this.binder.forField((HasValue)baseDir).withValidator((SerializablePredicate & Serializable)value -> !value.equals(baseDir.getEmptyValue()) || this.isBulk, this.controller.getMessage("%s is required.", "Base Directory")).bind("baseDir");
        baseDir.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)baseDir, this.controller.getMessage("Base Directory", new Object[0])));
        this.advancedFieldList = new ArrayList();
        Checkbox recurse = new Checkbox();
        recurse.setId("recurse");
        this.binder.forField((HasValue)recurse).bind("recurse");
        recurse.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)recurse, this.controller.getMessage("Recurse", new Object[0])));
        TextField includesFiles = new TextField();
        includesFiles.setId("includesFiles");
        includesFiles.setWidth("20em");
        this.binder.forField((HasValue)includesFiles).bind("includesFiles");
        includesFiles.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)includesFiles, this.controller.getMessage("Include Files", new Object[0])));
        TextField excludesFiles = new TextField();
        excludesFiles.setId("excludesFiles");
        excludesFiles.setWidth("20em");
        this.binder.forField((HasValue)excludesFiles).bind("excludesFiles");
        excludesFiles.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)excludesFiles, this.controller.getMessage("Exclude Files", new Object[0])));
        Checkbox syncOnCreate = new Checkbox();
        syncOnCreate.setId("syncOnCreate");
        this.binder.forField((HasValue)syncOnCreate).bind("syncOnCreate");
        syncOnCreate.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnCreate, this.controller.getMessage("Sync on Create", new Object[0])));
        Checkbox syncOnModified = new Checkbox();
        syncOnModified.setId("syncOnModified");
        this.binder.forField((HasValue)syncOnModified).bind("syncOnModified");
        syncOnModified.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnModified, this.controller.getMessage("Sync on Modified", new Object[0])));
        Checkbox syncOnDelete = new Checkbox();
        syncOnDelete.setId("syncOnDelete");
        this.binder.forField((HasValue)syncOnDelete).bind("syncOnDelete");
        syncOnDelete.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnDelete, this.controller.getMessage("Sync on Delete", new Object[0])));
        Checkbox syncOnCtlFile = new Checkbox();
        syncOnCtlFile.setId("syncOnCtlFile");
        this.binder.forField((HasValue)syncOnCtlFile).bind("syncOnCtlFile");
        syncOnCtlFile.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)syncOnCtlFile, this.controller.getMessage("Sync on Ctl File", new Object[0])));
        Checkbox deleteAfterSync = new Checkbox();
        deleteAfterSync.setId("deleteAfterSync");
        this.binder.forField((HasValue)deleteAfterSync).bind("deleteAfterSync");
        deleteAfterSync.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)deleteAfterSync, this.controller.getMessage("Delete After Sync", new Object[0])));
        TextArea beforeCopyScript = new TextArea();
        beforeCopyScript.setId("beforeCopyScript");
        beforeCopyScript.setHeight("102px");
        beforeCopyScript.setWidth("20em");
        k beforeDialog = new k(this.controller.getMessage("Before Copy Script", new Object[0]), this.controller.getMessage("A bsh script that is run right before the file copy", new Object[0]), (HasValue<?, String>)beforeCopyScript, this.controller);
        beforeDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
        beforeCopyScript.addFocusListener(beforeDialog.getFocusListener());
        beforeCopyScript.addBlurListener(beforeDialog.getBlurListener());
        this.binder.forField((HasValue)beforeCopyScript).bind("beforeCopyScript");
        beforeCopyScript.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)beforeCopyScript, this.controller.getMessage("Before Copy Script", new Object[0])));
        TextArea afterCopyScript = new TextArea();
        afterCopyScript.setId("afterCopyScript");
        afterCopyScript.setHeight("102px");
        afterCopyScript.setWidth("20em");
        k afterDialog = new k(this.controller.getMessage("After Copy Script", new Object[0]), this.controller.getMessage("A bsh script that is run right after the file copy", new Object[0]), (HasValue<?, String>)afterCopyScript, this.controller);
        afterDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> this.formListener.getFormLayout().enableCancelShortcut(!event.isOpened()));
        afterCopyScript.addFocusListener(afterDialog.getFocusListener());
        afterCopyScript.addBlurListener(afterDialog.getBlurListener());
        this.binder.forField((HasValue)afterCopyScript).bind("afterCopyScript");
        afterCopyScript.setVisible(this.isBulk);
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)afterCopyScript, this.controller.getMessage("After Copy Script", new Object[0])));
    }

    private Select<String> getChannelIdSelect(String label, String id, boolean includeReload) {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        ArrayList<String> channelIdList = new ArrayList<String>();
        String firstChannelId = null;
        for (NodeChannel nodeChannel : configService.getNodeChannels(false)) {
            String channelId = nodeChannel.getChannelId();
            if (channelId.equals("config") || channelId.equals("heartbeat") || channelId.equals("system")) continue;
            Channel channel = nodeChannel.getChannel();
            boolean include = channel.isFileSyncFlag();
            if (!(include &= channel.isReloadFlag() && includeReload || !channel.isReloadFlag() && !includeReload)) continue;
            if (firstChannelId == null) {
                firstChannelId = channelId;
            }
            channelIdList.add(channelId);
        }
        channelIdList.sort(null);
        Select channelIdSelect = new Select();
        channelIdSelect.setItems(channelIdList);
        channelIdSelect.setId(id);
        this.formatComboBox(channelIdSelect);
        this.binder.forField((HasValue)channelIdSelect).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", label)).bind(id);
        channelIdSelect.setRequiredIndicatorVisible(!this.isBulk);
        channelIdSelect.setValue((Object)firstChannelId);
        return channelIdSelect;
    }

    @Override
    protected void generateNewItem() {
        FileTrigger fileTrigger = new FileTrigger();
        fileTrigger.setTriggerId("");
        fileTrigger.setCreateTime(new Date());
        fileTrigger.setLastUpdateTime(new Date());
        fileTrigger.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
        this.newItem = fileTrigger;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
            if (!this.isBulk) {
                FileTrigger fileTrigger;
                if (!this.newItemFlag) {
                    try {
                        this.binder.writeBean((Object)((FileTrigger)this.itemSet.iterator().next()));
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    fileTrigger = (FileTrigger)this.itemSet.iterator().next();
                    fileTrigger.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTrigger.setLastUpdateTime(new Date());
                    if (saveAsCopy) {
                        fileSyncService.saveFileTriggerAsCopy(this.originalId, fileTrigger);
                    } else if (this.originalId == null || this.originalId.equals(fileTrigger.getTriggerId())) {
                        fileSyncService.saveFileTrigger(fileTrigger);
                    } else {
                        fileSyncService.renameFileTrigger(this.originalId, fileTrigger);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((FileTrigger)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    fileTrigger = (FileTrigger)this.newItem;
                    fileTrigger.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTrigger.setLastUpdateTime(new Date());
                    fileSyncService.saveFileTrigger(fileTrigger);
                }
                this.addEvent(this.newItemFlag ? "File Capture Created" : "File Capture Modified", fileTrigger.getTriggerId());
                fL fileSyncChecker = new fL();
                fileSyncChecker.a(fileTrigger.getBaseDir(), this.controller);
            } else {
                for (FileTrigger fileTrigger : this.itemSet) {
                    this.saveFieldsToFileTrigger(this.fieldList, fileTrigger);
                    this.saveFieldsToFileTrigger(this.advancedFieldList, fileTrigger);
                    fileTrigger.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    fileTrigger.setLastUpdateTime(new Date());
                    fileSyncService.saveFileTrigger(fileTrigger);
                }
                this.addEvent("File Capture Modified", this.itemSet.stream().map(FileTrigger::getTriggerId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private void saveFieldsToFileTrigger(List<R.a> fields, FileTrigger fileTrigger) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "channelId": {
                    fileTrigger.setTriggerId((String)field.getValue());
                    break;
                }
                case "reloadChannelId": {
                    fileTrigger.setReloadChannelId((String)field.getValue());
                    break;
                }
                case "baseDir": {
                    fileTrigger.setBaseDir((String)field.getValue());
                    break;
                }
                case "recurse": {
                    fileTrigger.setRecurse(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "includesFiles": {
                    fileTrigger.setIncludesFiles((String)field.getValue());
                    break;
                }
                case "excludesFiles": {
                    fileTrigger.setExcludesFiles((String)field.getValue());
                    break;
                }
                case "syncOnCreate": {
                    fileTrigger.setSyncOnCreate(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnModified": {
                    fileTrigger.setSyncOnModified(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnDelete": {
                    fileTrigger.setSyncOnDelete(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "syncOnCtlFile": {
                    fileTrigger.setSyncOnCtlFile(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "deleteAfterSync": {
                    fileTrigger.setDeleteAfterSync(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "beforeCopyScript": {
                    fileTrigger.setBeforeCopyScript((String)field.getValue());
                    break;
                }
                case "afterCopyScript": {
                    fileTrigger.setAfterCopyScript((String)field.getValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        IFileSyncService fileSyncService = this.controller.getSymmetricEngine().getFileSyncService();
        ITriggerRouterService triggerRouterService = this.controller.getSymmetricEngine().getTriggerRouterService();
        for (FileTrigger fileTrigger : this.itemSet) {
            List routers = triggerRouterService.getRouters();
            for (Router router : routers) {
                FileTriggerRouter fileTriggerRouter = fileSyncService.getFileTriggerRouter(fileTrigger.getTriggerId(), router.getRouterId(), true);
                if (fileTriggerRouter == null) continue;
                fileSyncService.deleteFileTriggerRouter(fileTriggerRouter);
            }
            fileSyncService.deleteFileTrigger(fileTrigger);
        }
        this.addEvent("File Capture Deleted", this.itemSet.stream().map(FileTrigger::getTriggerId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add(IDENTIFIER);
        orderedFields.add("channelId");
        orderedFields.add("reloadChannelId");
        orderedFields.add("baseDir");
        orderedFields.add("recurse");
        orderedFields.add("includesFiles");
        orderedFields.add("excludesFiles");
        orderedFields.add("syncOnCreate");
        orderedFields.add("syncOnModified");
        orderedFields.add("syncOnDelete");
        orderedFields.add("syncOnCtlFile");
        orderedFields.add("deleteAfterSync");
        orderedFields.add("beforeCopyScript");
        orderedFields.add("afterCopyScript");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return IDENTIFIER;
    }

    @Override
    public String getHelpSectionName() {
        return "_file_triggers";
    }
}

