/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.impl;

import com.jumpmind.symmetric.console.impl.R;
import com.jumpmind.symmetric.console.impl.ah;
import com.jumpmind.symmetric.console.ui.common.I;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToBigDecimalConverter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.validator.BigDecimalRangeValidator;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.vaadin.ui.common.CommonUiUtils;

public class S
extends R<NodeChannel> {
    private static final long serialVersionUID = 1L;
    private String originalId;
    private boolean originalReloadFlag;
    private boolean originalFileSyncFlag;
    private R.a reloadFlagField;
    private R.a fileSyncFlagField;

    public S(I controller, Set<NodeChannel> itemSet, boolean newItemFlag, boolean deleteFlag) {
        super(controller, itemSet, newItemFlag, deleteFlag);
    }

    @Override
    public void initFields() {
        if (!this.newItemFlag && !this.isBulk) {
            this.originalId = ((NodeChannel)this.itemSet.iterator().next()).getChannelId();
            this.originalReloadFlag = ((NodeChannel)this.itemSet.iterator().next()).isReloadFlag();
            this.originalFileSyncFlag = ((NodeChannel)this.itemSet.iterator().next()).isFileSyncFlag();
        }
        this.binder = new Binder(NodeChannel.class);
        TextField channelId = new TextField();
        channelId.setId("channelId");
        this.binder.forField((HasValue)channelId).withValidator((SerializablePredicate & Serializable)value -> !StringUtils.isBlank((CharSequence)value) || this.isBulk, this.controller.getMessage("%s is required.", "Channel Id")).bind("channelId");
        channelId.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)channelId, this.controller.getMessage("Channel Id", new Object[0])));
        TextField processingOrder = new TextField();
        processingOrder.setId("processingOrder");
        this.binder.forField((HasValue)processingOrder).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Processing Order must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Processing Order")).bind("processingOrder");
        processingOrder.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)processingOrder, this.controller.getMessage("Processing Order", new Object[0])));
        IRouterService routerService = this.controller.getSymmetricEngine().getRouterService();
        Select batchAlgorithm = new Select();
        batchAlgorithm.setItems((Collection)routerService.getAvailableBatchAlgorithms());
        batchAlgorithm.setId("batchAlgorithm");
        this.formatComboBox(batchAlgorithm);
        this.binder.forField((HasValue)batchAlgorithm).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Batch Algorithm")).bind("batchAlgorithm");
        batchAlgorithm.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)batchAlgorithm, this.controller.getMessage("Batch Algorithm", new Object[0])));
        TextField maxBatchSize = new TextField();
        maxBatchSize.setId("maxBatchSize");
        this.binder.forField((HasValue)maxBatchSize).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Max. Batch Size must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Max. Batch Size")).bind("maxBatchSize");
        maxBatchSize.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)maxBatchSize, this.controller.getMessage("Max. Batch Size", new Object[0])));
        TextField maxBatchToSend = new TextField();
        maxBatchToSend.setId("maxBatchToSend");
        this.binder.forField((HasValue)maxBatchToSend).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Max. Batch to Send must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Max. Batch to Send")).bind("maxBatchToSend");
        maxBatchToSend.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)maxBatchToSend, this.controller.getMessage("Max. Batch to Send", new Object[0])));
        TextField maxDataToRoute = new TextField();
        maxDataToRoute.setId("maxDataToRoute");
        this.binder.forField((HasValue)maxDataToRoute).withConverter((Converter)new StringToIntegerConverter(this.controller.getMessage("Max. Data to Route must be an integer.", new Object[0]))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Max. Data to Route")).bind("maxDataToRoute");
        maxDataToRoute.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)maxDataToRoute, this.controller.getMessage("Max. Data to Route", new Object[0])));
        TextField maxKBytesPerSecond = new TextField();
        maxKBytesPerSecond.setId("maxKBytesPerSecond");
        this.binder.forField((HasValue)maxKBytesPerSecond).withConverter((Converter)new StringToBigDecimalConverter(this.controller.getMessage("Max. KB/s must be an integer.", new Object[0]))).withValidator((Validator)new BigDecimalRangeValidator(this.controller.getMessage("Max. KB/s must be between 0 and 1,000,000,000.", new Object[0]), BigDecimal.ZERO, new BigDecimal(1000000000))).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Max. KB/s")).bind("maxKBytesPerSecond");
        maxKBytesPerSecond.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)maxKBytesPerSecond, this.controller.getMessage("Max. KB/s", new Object[0])));
        IDataLoaderService dataLoaderService = this.controller.getSymmetricEngine().getDataLoaderService();
        Select dataLoaderType = new Select();
        dataLoaderType.setItems((Collection)dataLoaderService.getAvailableDataLoaderFactories());
        dataLoaderType.setId("dataLoaderType");
        this.formatComboBox(dataLoaderType);
        this.binder.forField((HasValue)dataLoaderType).withValidator((SerializablePredicate & Serializable)value -> value != null || this.isBulk, this.controller.getMessage("%s is required.", "Data Loader Type")).bind("dataLoaderType");
        dataLoaderType.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)dataLoaderType, this.controller.getMessage("Data Loader Type", new Object[0])));
        TextField queue = new TextField();
        queue.setId("queue");
        this.binder.forField((HasValue)queue).withValidator((Validator)new ah()).bind("queue");
        queue.setRequiredIndicatorVisible(!this.isBulk);
        this.fieldList.add(new R.a(this, (HasValue<?, ?>)queue, this.controller.getMessage("Queue Name", new Object[0])));
        this.advancedFieldList = new ArrayList();
        Select dataEventActionShortName = new Select();
        dataEventActionShortName.setItems(Arrays.asList("", "push", "pull"));
        dataEventActionShortName.setId("dataEventActionShortName");
        this.formatComboBox(dataEventActionShortName);
        this.binder.forField((HasValue)dataEventActionShortName).bind("dataEventActionShortName");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)dataEventActionShortName, this.controller.getMessage("Group Link Direction", new Object[0])));
        Checkbox enabled = new Checkbox();
        enabled.setId("enabled");
        this.binder.forField((HasValue)enabled).bind("enabled");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)enabled, this.controller.getMessage("Enabled", new Object[0])));
        Checkbox reloadFlag = new Checkbox();
        reloadFlag.setId("reloadFlag");
        this.binder.forField((HasValue)reloadFlag).bind("reloadFlag");
        this.reloadFlagField = new R.a(this, (HasValue<?, ?>)reloadFlag, this.controller.getMessage("Reload Channel", new Object[0]));
        this.advancedFieldList.add(this.reloadFlagField);
        Checkbox fileSyncFlag = new Checkbox();
        fileSyncFlag.setId("fileSyncFlag");
        this.binder.forField((HasValue)fileSyncFlag).bind("fileSyncFlag");
        this.fileSyncFlagField = new R.a(this, (HasValue<?, ?>)fileSyncFlag, this.controller.getMessage("File Sync Channel", new Object[0]));
        this.advancedFieldList.add(this.fileSyncFlagField);
        Checkbox useOldDataToRoute = new Checkbox();
        useOldDataToRoute.setId("useOldDataToRoute");
        this.binder.forField((HasValue)useOldDataToRoute).bind("useOldDataToRoute");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)useOldDataToRoute, this.controller.getMessage("Use Old Data to Route", new Object[0])));
        Checkbox useRowDataToRoute = new Checkbox();
        useRowDataToRoute.setId("useRowDataToRoute");
        this.binder.forField((HasValue)useRowDataToRoute).bind("useRowDataToRoute");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)useRowDataToRoute, this.controller.getMessage("Use Row Data to Route", new Object[0])));
        Checkbox usePkDataToRoute = new Checkbox();
        usePkDataToRoute.setId("usePkDataToRoute");
        this.binder.forField((HasValue)usePkDataToRoute).bind("usePkDataToRoute");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)usePkDataToRoute, this.controller.getMessage("Use Primary Key (PK) Data to Route", new Object[0])));
        Checkbox containsBigLob = new Checkbox();
        containsBigLob.setId("containsBigLob");
        this.binder.forField((HasValue)containsBigLob).bind("containsBigLob");
        this.advancedFieldList.add(new R.a(this, (HasValue<?, ?>)containsBigLob, this.controller.getMessage("Contains Lob or Wide Row Data", new Object[0])));
    }

    @Override
    protected void generateNewItem() {
        NodeChannel nodeChannel = new NodeChannel();
        nodeChannel.setEnabled(true);
        nodeChannel.setProcessingOrder(50);
        nodeChannel.setMaxBatchSize(10000);
        nodeChannel.setMaxBatchToSend(10);
        nodeChannel.setChannelId("");
        nodeChannel.setQueue("");
        this.newItem = nodeChannel;
    }

    @Override
    public boolean save(boolean saveAsCopy) {
        if (this.binder.validate().isOk()) {
            IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
            if (!this.isBulk) {
                Channel channel;
                if (!this.newItemFlag) {
                    List allFileTriggers;
                    List allTriggers;
                    boolean reloadFlagChanged;
                    try {
                        if (saveAsCopy) {
                            if (this.newItem == null) {
                                this.generateNewItem();
                            }
                            this.binder.writeBean((Object)((NodeChannel)this.newItem));
                        } else {
                            this.binder.writeBean((Object)((NodeChannel)this.itemSet.iterator().next()));
                        }
                    }
                    catch (ValidationException e2) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    channel = saveAsCopy ? ((NodeChannel)this.newItem).getChannel() : ((NodeChannel)this.itemSet.iterator().next()).getChannel();
                    channel.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    boolean bl2 = reloadFlagChanged = channel.isReloadFlag() != this.originalReloadFlag;
                    if ((reloadFlagChanged || channel.isFileSyncFlag() != this.originalFileSyncFlag) && !this.validateFlagChanges(allTriggers = this.controller.getSymmetricEngine().getTriggerRouterService().getTriggers(), allFileTriggers = this.controller.getSymmetricEngine().getFileSyncService().getFileTriggers(), this.originalId, reloadFlagChanged)) {
                        return false;
                    }
                    if (saveAsCopy) {
                        configService.saveChannelAsCopy(channel, true);
                    } else if (this.originalId == null || this.originalId.equals(channel.getChannelId())) {
                        configService.saveChannel(channel, true);
                    } else {
                        configService.renameChannel(this.originalId, channel);
                    }
                } else {
                    try {
                        this.binder.writeBean((Object)((NodeChannel)this.newItem));
                    }
                    catch (ValidationException e3) {
                        CommonUiUtils.notify((String)"Failed to write to bean");
                    }
                    channel = ((NodeChannel)this.newItem).getChannel();
                    channel.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    configService.saveChannel(channel, true);
                }
                this.addEvent(this.newItemFlag ? "Channel Created" : "Channel Modified", channel.getChannelId());
            } else {
                if (((Boolean)this.reloadFlagField.getCheckbox().getValue()).booleanValue() || ((Boolean)this.fileSyncFlagField.getCheckbox().getValue()).booleanValue()) {
                    List allTriggers = this.controller.getSymmetricEngine().getTriggerRouterService().getTriggers();
                    List allFileTriggers = this.controller.getSymmetricEngine().getFileSyncService().getFileTriggers();
                    for (NodeChannel nodeChannel : this.itemSet) {
                        boolean fileSyncFlagChanged;
                        boolean reloadFlagChanged = (Boolean)this.reloadFlagField.getCheckbox().getValue() != false && nodeChannel.isReloadFlag() != ((Boolean)((Checkbox)this.reloadFlagField.getField()).getValue()).booleanValue();
                        boolean bl3 = fileSyncFlagChanged = (Boolean)this.fileSyncFlagField.getCheckbox().getValue() != false && nodeChannel.isFileSyncFlag() != ((Boolean)((Checkbox)this.fileSyncFlagField.getField()).getValue()).booleanValue();
                        if (!reloadFlagChanged && !fileSyncFlagChanged || this.validateFlagChanges(allTriggers, allFileTriggers, nodeChannel.getChannelId(), reloadFlagChanged)) continue;
                        return false;
                    }
                }
                for (NodeChannel nodeChannel : this.itemSet) {
                    this.saveFieldsToChannel(this.fieldList, nodeChannel);
                    this.saveFieldsToChannel(this.advancedFieldList, nodeChannel);
                    Channel channel = nodeChannel.getChannel();
                    channel.setLastUpdateBy(this.controller.getConsoleUser().getUserId());
                    configService.saveChannel(channel, true);
                }
                this.addEvent("Channel Modified", this.itemSet.stream().map(NodeChannel::getChannelId).collect(Collectors.toSet()));
            }
            if (this.formListener != null) {
                this.formListener.formSaved();
            }
            return true;
        }
        return false;
    }

    private boolean validateFlagChanges(List<Trigger> allTriggers, List<FileTrigger> allFileTriggers, String channelId, boolean reloadFlagChanged) {
        for (Trigger trigger : allTriggers) {
            if (!channelId.equals(trigger.getChannelId()) && !channelId.equals(trigger.getReloadChannelId())) continue;
            if (reloadFlagChanged) {
                CommonUiUtils.notify((String)this.controller.getMessage("The '%s' channel's Reload Channel flag cannot be changed when it is being referenced by the '%s' table capture.", channelId, trigger.getTriggerId()));
            } else {
                CommonUiUtils.notify((String)this.controller.getMessage("The '%s' channel's File Sync Channel flag cannot be changed when it is being referenced by the '%s' table capture.", channelId, trigger.getTriggerId()));
            }
            return false;
        }
        for (FileTrigger fileTrigger : allFileTriggers) {
            if (!channelId.equals(fileTrigger.getChannelId()) && !channelId.equals(fileTrigger.getReloadChannelId())) continue;
            if (reloadFlagChanged) {
                CommonUiUtils.notify((String)this.controller.getMessage("The '%s' channel's Reload Channel flag cannot be changed when it is being referenced by the '%s' file capture.", channelId, fileTrigger.getTriggerId()));
            } else {
                CommonUiUtils.notify((String)this.controller.getMessage("The '%s' channel's File Sync Channel flag cannot be changed when it is being referenced by the '%s' file capture.", channelId, fileTrigger.getTriggerId()));
            }
            return false;
        }
        return true;
    }

    private void saveFieldsToChannel(List<R.a> fields, NodeChannel nodeChannel) {
        for (R.a formField : fields) {
            HasValue<?, ?> field = formField.getField();
            Checkbox checkbox = formField.getCheckbox();
            if (checkbox == null || !((Boolean)checkbox.getValue()).booleanValue() || !(field instanceof Component)) continue;
            switch (((Component)field).getId().orElse("")) {
                case "processingOrder": {
                    nodeChannel.setProcessingOrder(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "batchAlgorithm": {
                    nodeChannel.setBatchAlgorithm((String)field.getValue());
                    break;
                }
                case "maxBatchSize": {
                    nodeChannel.setMaxBatchSize(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "maxBatchToSend": {
                    nodeChannel.setMaxBatchToSend(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "maxDataToRoute": {
                    nodeChannel.setMaxDataToRoute(Integer.parseInt((String)field.getValue()));
                    break;
                }
                case "maxKBytesPerSecond": {
                    String value = ((String)field.getValue()).replaceAll(",", "");
                    nodeChannel.setMaxKBytesPerSecond(new BigDecimal(value));
                    break;
                }
                case "dataLoaderType": {
                    nodeChannel.setDataLoaderType((String)field.getValue());
                    break;
                }
                case "queue": {
                    nodeChannel.setQueue((String)field.getValue());
                    break;
                }
                case "dataEventActionShortName": {
                    nodeChannel.setDataEventActionShortName((String)field.getValue());
                    break;
                }
                case "enabled": {
                    nodeChannel.setEnabled(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "reloadFlag": {
                    nodeChannel.setReloadFlag(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "fileSyncFlag": {
                    nodeChannel.setFileSyncFlag(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "useOldDataToRoute": {
                    nodeChannel.setUseOldDataToRoute(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "useRowDataToRoute": {
                    nodeChannel.setUseRowDataToRoute(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "usePkDataToRoute": {
                    nodeChannel.setUsePkDataToRoute(((Boolean)field.getValue()).booleanValue());
                    break;
                }
                case "containsBigLob": {
                    nodeChannel.setContainsBigLob(((Boolean)field.getValue()).booleanValue());
                }
            }
        }
    }

    @Override
    public void delete() {
        IConfigurationService configService = this.controller.getSymmetricEngine().getConfigurationService();
        for (NodeChannel nodeChannel : this.itemSet) {
            configService.deleteChannel(nodeChannel.getChannel());
        }
        this.addEvent("Channel Deleted", this.itemSet.stream().map(NodeChannel::getChannelId).collect(Collectors.toSet()));
        if (this.formListener != null) {
            this.formListener.formDeleted();
        }
    }

    @Override
    protected List<String> getOrderedFieldIds() {
        ArrayList<String> orderedFields = new ArrayList<String>();
        orderedFields.add("channelId");
        orderedFields.add("processingOrder");
        orderedFields.add("batchAlgorithm");
        orderedFields.add("maxBatchSize");
        orderedFields.add("maxBatchToSend");
        orderedFields.add("maxDataToRoute");
        orderedFields.add("maxKBytesPerSecond");
        orderedFields.add("dataLoaderType");
        orderedFields.add("queue");
        orderedFields.add("dataEventActionShortName");
        orderedFields.add("enabled");
        orderedFields.add("reloadFlag");
        orderedFields.add("fileSyncFlag");
        orderedFields.add("useOldDataToRoute");
        orderedFields.add("useRowDataToRoute");
        orderedFields.add("usePkDataToRoute");
        orderedFields.add("containsBigLob");
        return orderedFields;
    }

    @Override
    public String getKeyId() {
        return "channelId";
    }

    @Override
    public String getHelpSectionName() {
        return "_channels";
    }
}

