/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.console.authentication;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.INodeRegistrationAuthenticator;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;

public class NodeRegistrationSecretAuthenticator
implements IBuiltInExtensionPoint,
INodeRegistrationAuthenticator,
ISymmetricEngineAware {
    protected ISymmetricEngine engine;

    public boolean authenticate(String userId, String password) {
        String secret = this.engine.getParameterService().getString("registration.secret");
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            if (secret.startsWith("enc:")) {
                secret = this.engine.getSecurityService().decrypt(secret.substring("enc:".length()));
            } else if (secret.startsWith("obf:")) {
                secret = this.engine.getSecurityService().unobfuscate(secret.substring("obf:".length()));
            }
            if (secret != null && secret.equals(password)) {
                return true;
            }
        }
        return false;
    }

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }
}

