/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric.cc;

import com.jumpmind.symmetric.console.a;
import com.sun.jna.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.wrapper.WrapperService;

public class SymmetricControlCenter
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final String INSTALL = "Install Service";
    static final String UNINSTALL = "Uninstall Service";
    static final String START = "Start Server";
    static final String STOP = "Stop Server";
    static final String STATUS = "Status";
    static final String OPEN = "Open Web Console";
    static JFrame frame;
    String symHome;
    WrapperService wrapper;
    ProgressWorker progressWorker;
    String httpPort;
    String httpsPort;
    boolean isHttp;
    boolean isHttps;
    boolean isPrivileged;
    JButton installButton = new JButton("----");
    JButton runButton = new JButton("----");
    JButton openButton = new JButton("Open Web Console");
    JLabel serverStopLabel;
    JLabel serverRunLabel;
    JLabel serverTextLabel = new JLabel("----");
    JLabel httpStopLabel;
    JLabel httpRunLabel;
    JLabel httpTextLabel = new JLabel("----");
    JLabel httpsStopLabel;
    JLabel httpsRunLabel;
    JLabel httpsTextLabel = new JLabel("----");
    JLabel jmxStopLabel;
    JLabel jmxRunLabel;
    JLabel jmxTextLabel = new JLabel("----");
    JLabel installLabel = new JLabel("----");
    JLabel memoryLabel = new JLabel("----");
    ImageIcon statusOn;
    ImageIcon statusOff;
    ImageIcon statusDisabled;
    ImageIcon statusEnabled;

    public SymmetricControlCenter() throws IOException {
        this.symHome = System.getenv("SYM_HOME");
        if (this.symHome == null) {
            this.symHome = System.getProperty("SYM_HOME");
        }
        if (this.symHome == null) {
            throw new RuntimeException("Missing SYM_HOME environment variable");
        }
        this.wrapper = WrapperService.getInstance();
        this.loadConfig();
        this.isPrivileged = this.wrapper.isPrivileged();
        if (!this.isPrivileged) {
            this.wrapper.relaunchAsPrivileged(this.getClass().getName());
        }
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.statusOn = new ImageIcon(ImageIO.read(this.getClass().getResource("/status_on.png")));
        this.statusOff = new ImageIcon(ImageIO.read(this.getClass().getResource("/status_off.png")));
        this.statusEnabled = new ImageIcon(ImageIO.read(this.getClass().getResource("/status_enabled.png")));
        this.statusDisabled = new ImageIcon(ImageIO.read(this.getClass().getResource("/status_disabled.png")));
        this.serverStopLabel = new JLabel(this.statusDisabled);
        this.serverRunLabel = new JLabel(this.statusDisabled);
        this.httpStopLabel = new JLabel(this.statusDisabled);
        this.httpRunLabel = new JLabel(this.statusDisabled);
        this.httpsStopLabel = new JLabel(this.statusDisabled);
        this.httpsRunLabel = new JLabel(this.statusDisabled);
        this.jmxStopLabel = new JLabel(this.statusDisabled);
        this.jmxRunLabel = new JLabel(this.statusDisabled);
        Border border = BorderFactory.createEtchedBorder(1);
        int fill = 0;
        int anchor = 21;
        int anchorEnd = 22;
        Insets insets = new Insets(0, 5, 5, 5);
        Insets indentInsets = new Insets(0, 15, 5, 5);
        Dimension buttonDim = new Dimension(170, 40);
        JPanel topPanel = new JPanel();
        BufferedImage image = ImageIO.read(this.getClass().getResource("/SymmetricDS_header.png"));
        topPanel.add((Component)new JLabel(new ImageIcon(image)), "First");
        this.add(topPanel);
        this.add(Box.createVerticalStrut(12));
        JPanel generalPanel = new JPanel();
        generalPanel.setLayout(new GridBagLayout());
        generalPanel.setBorder(BorderFactory.createTitledBorder(border));
        generalPanel.add((Component)new JLabel("Version:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        JLabel versionLabel = new JLabel(a.a().version());
        versionLabel.setFont(versionLabel.getFont().deriveFont(1));
        generalPanel.add((Component)versionLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        generalPanel.add((Component)new JLabel("Base Directory:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        JLabel baseDirLabel = new JLabel();
        baseDirLabel.setFont(baseDirLabel.getFont().deriveFont(1));
        if (StringUtils.isEmpty((CharSequence)this.symHome)) {
            baseDirLabel.setText("Missing SYM_HOME environment variable");
            baseDirLabel.setForeground(Color.RED);
        } else {
            baseDirLabel.setText(this.symHome);
        }
        generalPanel.add((Component)baseDirLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, anchor, fill, indentInsets, 0, 0));
        this.add(generalPanel);
        this.add(Box.createVerticalStrut(12));
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        statusPanel.setBorder(BorderFactory.createTitledBorder(border, STATUS));
        statusPanel.add((Component)this.serverStopLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.serverRunLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.serverTextLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        statusPanel.add((Component)this.runButton, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, anchorEnd, fill, insets, 0, 0));
        statusPanel.add((Component)this.httpStopLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.httpRunLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.httpTextLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        statusPanel.add((Component)this.httpsStopLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.httpsRunLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.httpsTextLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        statusPanel.add((Component)this.openButton, new GridBagConstraints(3, 2, 1, 2, 1.0, 0.0, anchorEnd, fill, insets, 0, 0));
        statusPanel.add((Component)this.jmxStopLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.jmxRunLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        statusPanel.add((Component)this.jmxTextLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        this.runButton.addActionListener(this);
        this.runButton.setPreferredSize(buttonDim);
        this.openButton.addActionListener(this);
        this.openButton.setPreferredSize(buttonDim);
        this.add(statusPanel);
        this.add(Box.createVerticalStrut(18));
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridBagLayout());
        optionPanel.setBorder(BorderFactory.createTitledBorder(border));
        optionPanel.add((Component)new JLabel("Automatic startup:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        this.installLabel.setFont(this.installLabel.getFont().deriveFont(1));
        this.installLabel.setPreferredSize(new Dimension(150, 20));
        optionPanel.add((Component)this.installLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, anchor, fill, indentInsets, 0, 0));
        optionPanel.add((Component)new JLabel("Max memory:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        optionPanel.add((Component)this.memoryLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0));
        optionPanel.add((Component)this.installButton, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, anchorEnd, fill, insets, 0, 0));
        this.installButton.addActionListener(this);
        this.installButton.setPreferredSize(buttonDim);
        this.add(optionPanel);
        RefreshWorker refreshWorker = new RefreshWorker();
        refreshWorker.execute();
    }

    protected void loadConfig() {
        try {
            this.wrapper.loadConfig(this.symHome, this.symHome + File.separator + "conf" + File.separator + "sym_service.conf", this.symHome + File.separator + "lib" + File.separator + "symmetric-wrapper.jar");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String text = ((JButton)event.getSource()).getText();
        if (text.equals(OPEN)) {
            String hostname;
            File serverPropertiesFile = new File(this.symHome + File.separator + "conf" + File.separator + "symmetric-server.properties");
            if (serverPropertiesFile.exists()) {
                TypedProperties serverProperties = new TypedProperties(serverPropertiesFile);
                hostname = serverProperties.get("host.bind.name", System.getProperty("host.bind.name", "localhost"));
            } else {
                hostname = System.getProperty("host.bind.name", "localhost");
            }
            if (hostname.equals("0.0.0.0")) {
                hostname = "localhost";
            }
            String cmd = (this.isHttp ? "http" : "https") + "://" + hostname + ":" + (this.isHttp ? this.httpPort : this.httpsPort);
            if (Platform.isWindows()) {
                cmd = "cmd /c start " + cmd;
            } else if (Platform.isMac()) {
                cmd = "open " + cmd;
            } else if (!Platform.isWindows()) {
                cmd = "xdg-open " + cmd;
            }
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e2) {
                JOptionPane.showMessageDialog(frame, e2);
            }
        } else if (text.equals(INSTALL) && !this.isPrivileged) {
            String privUser = "root";
            if (System.getProperty("os.name").startsWith("Windows")) {
                privUser = "Administrator";
            }
            JOptionPane.showMessageDialog(frame, "You must be " + privUser + " to install the service.");
        } else {
            this.runButton.setEnabled(false);
            this.openButton.setEnabled(false);
            this.installButton.setEnabled(false);
            this.progressWorker = new ProgressWorker(this, text);
            this.progressWorker.execute();
            this.loadConfig();
            new Runner(text).start();
        }
    }

    protected synchronized void refresh() {
        if (new File("tmp/upgrade.tmp").exists()) {
            System.exit(16);
        }
        if (frame == null || !frame.isVisible()) {
            return;
        }
        boolean isInstalled = this.wrapper.isInstalled();
        this.installLabel.setText(isInstalled ? "Yes" : "No");
        if (isInstalled) {
            this.installButton.setText(UNINSTALL);
        } else {
            this.installButton.setText(INSTALL);
        }
        boolean isRunning = this.wrapper.isRunning();
        this.serverStopLabel.setIcon(isRunning ? this.statusDisabled : this.statusOff);
        this.serverRunLabel.setIcon(isRunning ? this.statusOn : this.statusDisabled);
        if (isRunning) {
            this.serverTextLabel.setText("Server is running as PID " + this.wrapper.getWrapperPid() + ", " + this.wrapper.getServerPid());
        } else {
            this.serverTextLabel.setText("Server is stopped");
        }
        this.runButton.setEnabled(true);
        String maxMemory = this.wrapper.getConfig().getMaxMemory();
        int memory = 0;
        try {
            memory = Integer.parseInt(maxMemory);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (memory < 1000) {
            this.memoryLabel.setText(maxMemory + " MB");
        } else if (memory % 1000 == 0) {
            this.memoryLabel.setText(memory / 1000 + " GB");
        } else {
            this.memoryLabel.setText(String.format("%.2f", Float.valueOf((float)memory / 1000.0f)) + " GB");
        }
        if (isRunning) {
            this.runButton.setText(STOP);
            this.openButton.setEnabled(true);
            this.installButton.setEnabled(false);
            this.installButton.setToolTipText("Stop server first before installing service.");
        } else {
            this.runButton.setText(START);
            this.openButton.setEnabled(false);
            this.installButton.setEnabled(true);
            this.installButton.setToolTipText(null);
        }
        try {
            Properties prop = new Properties();
            prop.load(new FileReader(this.symHome + File.separator + "conf" + File.separator + "symmetric-server.properties"));
            this.httpPort = prop.getProperty("http.port");
            this.isHttp = Boolean.parseBoolean(prop.getProperty("http.enable"));
            this.httpStopLabel.setIcon(this.isHttp ? this.statusDisabled : this.statusEnabled);
            this.httpRunLabel.setIcon(this.isHttp ? (isRunning ? this.statusOn : this.statusEnabled) : this.statusDisabled);
            this.httpTextLabel.setText((String)(this.isHttp ? "HTTP on port " + this.httpPort : "HTTP is disabled"));
            this.httpsPort = prop.getProperty("https.port");
            this.isHttps = Boolean.parseBoolean(prop.getProperty("https.enable"));
            this.httpsStopLabel.setIcon(this.isHttps ? this.statusDisabled : this.statusEnabled);
            this.httpsRunLabel.setIcon(this.isHttps ? (isRunning ? this.statusOn : this.statusEnabled) : this.statusDisabled);
            this.httpsTextLabel.setText((String)(this.isHttps ? "HTTPS on port " + this.httpsPort : "HTTPS is disabled"));
            List options = this.wrapper.getConfig().getOptions();
            boolean isJmx = false;
            int jmxPort = 0;
            for (String option : options) {
                if (option.endsWith("com.sun.management.jmxremote")) {
                    isJmx = true;
                }
                if (!option.contains("com.sun.management.jmxremote.port")) continue;
                try {
                    jmxPort = Integer.parseInt(option.split("=")[1]);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.jmxStopLabel.setIcon(isJmx ? this.statusDisabled : this.statusEnabled);
            this.jmxRunLabel.setIcon(isJmx ? (isRunning ? this.statusOn : this.statusEnabled) : this.statusDisabled);
            this.jmxTextLabel.setText((String)(isJmx ? "JMX on port " + jmxPort : "JMX is disabled"));
        }
        catch (IOException e3) {
            JOptionPane.showMessageDialog(frame, e3);
        }
    }

    protected static void displayGUI() throws IOException {
        SymmetricControlCenter panel = new SymmetricControlCenter();
        URL iconUrl = SymmetricControlCenter.class.getResource("/SymmetricDS_icon.png");
        frame = new JFrame("SymmetricDS Pro Control Center");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(panel);
        frame.setIconImage(new ImageIcon(iconUrl).getImage());
        frame.setMinimumSize(new Dimension(580, 400));
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SymmetricControlCenter.displayGUI();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    JOptionPane.showMessageDialog(frame, e2);
                }
            }
        });
    }

    static {
        String symHome = System.getenv("SYM_HOME");
        if (symHome == null) {
            symHome = ".";
        }
        System.setProperty("log4j.sym.home", symHome);
    }

    class RefreshWorker
    extends SwingWorker<Void, Void> {
        int sleepMs = 150;

        RefreshWorker() {
        }

        @Override
        public Void doInBackground() {
            while (true) {
                SymmetricControlCenter.this.refresh();
                try {
                    Thread.sleep(this.sleepMs);
                    this.sleepMs = 5000;
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    }

    class ProgressWorker
    extends SwingWorker<Void, Void> {
        private ProgressMonitor dialog;
        private boolean isCancel;

        public ProgressWorker(Component parent, String message) {
            this.dialog = new ProgressMonitor(parent, message, null, 0, 25);
            this.dialog.setMillisToDecideToPopup(100);
        }

        public void cancel() {
            this.isCancel = true;
        }

        @Override
        public Void doInBackground() {
            for (int i2 = 0; i2 <= 25 && !this.isCancel; ++i2) {
                this.dialog.setProgress(i2);
                try {
                    Thread.sleep(240L);
                    continue;
                }
                catch (Exception e2) {
                    break;
                }
            }
            this.dialog.close();
            return null;
        }
    }

    class Runner
    extends Thread {
        private String text;

        Runner(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            try {
                if (this.text.equals(SymmetricControlCenter.START)) {
                    SymmetricControlCenter.this.wrapper.start();
                } else if (this.text.equals(SymmetricControlCenter.STOP)) {
                    SymmetricControlCenter.this.wrapper.stop();
                } else if (this.text.equals(SymmetricControlCenter.INSTALL)) {
                    SymmetricControlCenter.this.wrapper.install();
                } else if (this.text.equals(SymmetricControlCenter.UNINSTALL)) {
                    SymmetricControlCenter.this.wrapper.uninstall();
                }
            }
            catch (Exception e2) {
                SymmetricControlCenter.this.progressWorker.cancel();
                JOptionPane.showMessageDialog(frame, e2);
            }
            catch (Error e3) {
                SymmetricControlCenter.this.progressWorker.cancel();
                JOptionPane.showMessageDialog(frame, e3);
            }
            SymmetricControlCenter.this.progressWorker.cancel();
            SymmetricControlCenter.this.refresh();
        }
    }
}

