/*
 * Decompiled with CFR 0.152.
 */
package com.jumpmind.symmetric;

import com.jumpmind.symmetric.console.authentication.OAuth2Servlet;
import com.jumpmind.symmetric.console.authentication.SamlServlet;
import com.jumpmind.symmetric.console.ui.AppServlet;
import com.jumpmind.symmetric.security.RestApiKeyFilter;
import com.vaadin.flow.spring.annotation.EnableVaadin;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@EnableVaadin(value={"com.jumpmind.symmetric"})
public class SymmetricBootConfig {
    @Bean
    ServletContextInitializer proServletContextInitializer() {
        return new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.setInitParameter("productionMode", "false");
                servletContext.setInitParameter("deploymentType", "professional");
            }
        };
    }

    @Bean
    @DependsOn(value={"symmetricServlet"})
    ServletRegistrationBean<AppServlet> appServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new AppServlet(), new String[0]);
        bean.setName("appServlet");
        bean.addInitParameter("widgetset", "com.jumpmind.symmetric.console.ui.widgetset.ConsoleWidgetSet");
        bean.addUrlMappings(new String[]{"/app/*", "/VAADIN/*"});
        bean.setLoadOnStartup(2);
        bean.setAsyncSupported(true);
        return bean;
    }

    @Bean
    @DependsOn(value={"symmetricServlet"})
    ServletRegistrationBean<SamlServlet> samlServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new SamlServlet(), new String[0]);
        bean.setName("samlServlet");
        bean.addUrlMappings(new String[]{"/saml/*"});
        bean.setLoadOnStartup(3);
        return bean;
    }

    @Bean
    @DependsOn(value={"symmetricServlet"})
    FilterRegistrationBean<RestApiKeyFilter> restApiKeyFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new RestApiKeyFilter());
        bean.addInitParameter("enabled", "true");
        bean.addUrlPatterns(new String[]{"/api/*"});
        bean.setOrder(1);
        return bean;
    }

    @Bean
    @DependsOn(value={"symmetricServlet"})
    ServletRegistrationBean<OAuth2Servlet> oAuth2Servlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new OAuth2Servlet(), new String[0]);
        bean.setName("oAuth2Servlet");
        bean.addUrlMappings(new String[]{"/openid/*"});
        bean.setLoadOnStartup(4);
        return bean;
    }
}

