/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class SymmetricServiceValidator
implements DataValidator {
    private String errorMessage;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessage;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        boolean isInstallService = Boolean.parseBoolean(idata.getVariable("select.install.service"));
        String runAsUser = idata.getVariable("select.install.run.as.user");
        boolean isRunAsUser = runAsUser != null && runAsUser.length() > 0;
        String serviceName = idata.getVariable("select.install.serviceName");
        if (isInstallService) {
            boolean isValidUser;
            if (idata.getPlatform().getName() != Platform.Name.WINDOWS && !this.isRoot()) {
                this.errorMessage = "Must be root to install service.";
                return DataValidator.Status.ERROR;
            }
            boolean existsService = false;
            existsService = idata.getPlatform().getName() == Platform.Name.WINDOWS ? this.checkServiceExists(serviceName) : new File("/etc/init.d/" + serviceName).exists();
            if (existsService) {
                this.errorMessage = "The service name is already in use.";
                return DataValidator.Status.ERROR;
            }
            if (isRunAsUser && !(isValidUser = this.checkUser(runAsUser, idata.getPlatform().getName() == Platform.Name.WINDOWS))) {
                this.errorMessage = "The run as user " + runAsUser + " is invalid.";
                return DataValidator.Status.ERROR;
            }
        }
        return DataValidator.Status.OK;
    }

    private boolean checkUser(String user, boolean isWindows) {
        int ret = -1;
        String[] cmd = new String[]{"id", "-u", user};
        if (isWindows) {
            cmd = new String[]{"net", "user", user};
        }
        StringBuilder output = new StringBuilder();
        try {
            Process proc = SymmetricIzPackHelper.runCommandForProcess(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            reader.close();
            ret = proc.waitFor();
        }
        catch (Exception e) {
            System.err.println("Error while running command: " + e);
        }
        return ret == 0;
    }

    private boolean checkServiceExists(String serviceName) {
        String output = SymmetricIzPackHelper.runCommand(new String[]{"sc", "query", serviceName});
        return output.indexOf(serviceName) != -1;
    }

    private boolean isRoot() {
        String uid = SymmetricIzPackHelper.runCommand(new String[]{"id", "-u"});
        return uid != null && uid.trim().equals("0");
    }
}

