/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import bsh.Interpreter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ColumnPolicy;
import org.jumpmind.symmetric.io.data.transform.TargetDmlAction;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformTable
implements Cloneable {
    final String INTERPRETER_KEY = String.format("%s.BshInterpreter", this.getClass().getName());
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Object> bshContext = new HashMap<String, Object>();
    protected String transformId;
    protected String sourceCatalogName;
    protected String sourceSchemaName;
    protected String sourceTableName;
    protected String targetCatalogName;
    protected String targetSchemaName;
    protected String targetTableName;
    protected TransformPoint transformPoint;
    protected List<TransformColumn> transformColumns;
    protected List<TransformColumn> primaryKeyColumns;
    protected String updateAction = TargetDmlAction.UPDATE_COL.name();
    protected TargetDmlAction deleteAction = TargetDmlAction.DEL_ROW;
    protected ColumnPolicy columnPolicy = ColumnPolicy.IMPLIED;
    protected boolean updateFirst = false;
    protected int transformOrder = 0;
    protected Date createTime;
    protected Date lastUpdateTime;
    protected String lastUpdateBy;

    public TransformTable(String sourceTableName, String targetTableName, TransformPoint transformPoint, TransformColumn ... columns) {
        this.sourceTableName = sourceTableName;
        this.targetTableName = targetTableName;
        this.transformPoint = transformPoint;
        this.transformColumns = new ArrayList<TransformColumn>();
        this.primaryKeyColumns = new ArrayList<TransformColumn>();
        if (columns != null) {
            for (TransformColumn transformColumn : columns) {
                if (transformColumn.isPk()) {
                    this.primaryKeyColumns.add(transformColumn);
                }
                this.transformColumns.add(transformColumn);
            }
        }
    }

    public TransformTable() {
    }

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.sourceCatalogName, (String)this.sourceSchemaName, (String)this.sourceTableName);
    }

    public String getFullyQualifiedTargetTableName() {
        return Table.getFullyQualifiedTableName((String)this.targetCatalogName, (String)this.targetSchemaName, (String)this.targetTableName);
    }

    public String getTransformId() {
        return this.transformId;
    }

    public void setTransformId(String transformId) {
        this.transformId = transformId;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public void setTransformPoint(TransformPoint transformPoint) {
        this.transformPoint = transformPoint;
    }

    public TransformPoint getTransformPoint() {
        return this.transformPoint;
    }

    public void setTransformColumns(List<TransformColumn> transformColumns) {
        this.transformColumns = transformColumns;
        this.primaryKeyColumns = new ArrayList<TransformColumn>();
        if (transformColumns != null) {
            for (TransformColumn transformColumn : transformColumns) {
                if (!transformColumn.isPk()) continue;
                this.primaryKeyColumns.add(transformColumn);
            }
        }
    }

    public List<TransformColumn> getTransformColumns() {
        return this.transformColumns;
    }

    public List<TransformColumn> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<TransformColumn> getTransformColumnFor(String columnName) {
        ArrayList<TransformColumn> columns = new ArrayList<TransformColumn>(2);
        if (this.transformColumns != null) {
            for (TransformColumn column : this.transformColumns) {
                if (!Strings.CI.equals(column.getSourceColumnName(), columnName)) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public List<TransformColumn> getTransformColumnTo(String targetColumn) {
        ArrayList<TransformColumn> columns = new ArrayList<TransformColumn>(2);
        if (this.transformColumns != null) {
            for (TransformColumn column : this.transformColumns) {
                if (!Strings.CI.equals(column.getTargetColumnName(), targetColumn)) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public TransformColumn getTransformColumn(String targetColumn, TransformColumn.IncludeOnType includeOn) {
        if (this.transformColumns != null) {
            for (TransformColumn column : this.transformColumns) {
                if (!Strings.CI.equals(targetColumn, column.getTargetColumnName()) || includeOn != column.getIncludeOn()) continue;
                return column;
            }
        }
        return null;
    }

    public void addTransformColumn(TransformColumn column) {
        if (this.transformColumns == null) {
            this.transformColumns = new ArrayList<TransformColumn>();
        }
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = new ArrayList<TransformColumn>();
        }
        this.transformColumns.add(column);
        if (column.isPk()) {
            this.primaryKeyColumns.add(column);
        }
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public String getUpdateAction() {
        return this.updateAction;
    }

    public TargetDmlAction evaluateTargetDmlAction(DataContext dataContext, TransformedData transformedData) {
        TargetDmlAction action = null;
        try {
            action = TargetDmlAction.valueOf(this.updateAction);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (action == null) {
            Interpreter interpreter = this.getInterpreter(dataContext);
            Map<String, String> sourceValues = transformedData.getSourceValues();
            try {
                interpreter.set("sourceDmlType", (Object)transformedData.getSourceDmlType());
                interpreter.set("sourceDmlTypeString", (Object)transformedData.getSourceDmlType().toString());
                interpreter.set("transformedData", (Object)transformedData);
                CsvData csvData = dataContext.getData();
                if (csvData != null) {
                    interpreter.set("externalData", csvData.getAttribute("externalData"));
                } else {
                    interpreter.set("externalData", null);
                }
                for (String string : sourceValues.keySet()) {
                    interpreter.set(string.toUpperCase(), (Object)sourceValues.get(string));
                    interpreter.set(string, (Object)sourceValues.get(string));
                }
                if (transformedData.getOldSourceValues() != null) {
                    for (Map.Entry entry : transformedData.getOldSourceValues().entrySet()) {
                        interpreter.set("OLD_" + (String)entry.getKey(), entry.getValue());
                        interpreter.set("OLD_" + ((String)entry.getKey()).toUpperCase(), entry.getValue());
                    }
                }
                String transformExpression = this.updateAction;
                String string = String.format("transform_%d()", Math.abs((long)transformExpression.hashCode()));
                if (dataContext.get(string) == null) {
                    interpreter.set("context", (Object)dataContext);
                    interpreter.set("bshContext", bshContext);
                    interpreter.eval(String.format("%s {\n%s\n}", string, transformExpression));
                    dataContext.put(string, Boolean.TRUE);
                }
                Object result = interpreter.eval(string);
                action = TargetDmlAction.valueOf((String)result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return action;
    }

    protected Interpreter getInterpreter(Context context) {
        Interpreter interpreter = (Interpreter)context.get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.put(this.INTERPRETER_KEY, (Object)interpreter);
        }
        return interpreter;
    }

    public void setDeleteAction(TargetDmlAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public TargetDmlAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setTransformOrder(int transformOrder) {
        this.transformOrder = transformOrder;
    }

    public int getTransformOrder() {
        return this.transformOrder;
    }

    public void setUpdateFirst(boolean updateFirst) {
        this.updateFirst = updateFirst;
    }

    public boolean isUpdateFirst() {
        return this.updateFirst;
    }

    public ColumnPolicy getColumnPolicy() {
        return this.columnPolicy;
    }

    public void setColumnPolicy(ColumnPolicy columnPolicy) {
        this.columnPolicy = columnPolicy;
    }

    public int hashCode() {
        if (this.transformId != null) {
            return this.transformId.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.transformId != null) {
            if (obj instanceof TransformTable) {
                return this.transformId.equals(((TransformTable)obj).transformId);
            }
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.transformId != null) {
            return this.transformId;
        }
        return super.toString();
    }

    public TransformTable enhanceWithImpliedColumns(String[] keyNames, String[] columnNames) {
        try {
            TransformTable copiedVersion = (TransformTable)this.clone();
            copiedVersion.transformColumns = this.transformColumns != null ? new ArrayList<TransformColumn>(this.transformColumns) : new ArrayList<TransformColumn>();
            copiedVersion.primaryKeyColumns = this.primaryKeyColumns != null ? new ArrayList<TransformColumn>(this.primaryKeyColumns) : new ArrayList<TransformColumn>();
            if (this.columnPolicy == ColumnPolicy.IMPLIED) {
                Object newCol;
                String columnLowerCase;
                boolean hasDelete;
                boolean hasUpdate;
                boolean hasInsert;
                for (String column : keyNames) {
                    hasInsert = false;
                    hasUpdate = false;
                    hasDelete = false;
                    columnLowerCase = column.toLowerCase();
                    if (this.primaryKeyColumns != null) {
                        for (TransformColumn xCol : this.transformColumns) {
                            if ((!StringUtils.isNotBlank((CharSequence)xCol.getSourceColumnName()) || !columnLowerCase.equals(xCol.getSourceColumnNameLowerCase())) && (!StringUtils.isNotBlank((CharSequence)xCol.getTargetColumnName()) || !columnLowerCase.equals(xCol.getTargetColumnNameLowerCase()))) continue;
                            if (xCol.includeOn == TransformColumn.IncludeOnType.ALL) {
                                hasDelete = true;
                                hasUpdate = true;
                                hasInsert = true;
                                break;
                            }
                            if (xCol.includeOn == TransformColumn.IncludeOnType.INSERT) {
                                hasInsert = true;
                                continue;
                            }
                            if (xCol.includeOn == TransformColumn.IncludeOnType.UPDATE) {
                                hasUpdate = true;
                                continue;
                            }
                            if (xCol.includeOn != TransformColumn.IncludeOnType.DELETE) continue;
                            hasDelete = true;
                        }
                    }
                    if (!(hasInsert || hasUpdate || hasDelete)) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.ALL, true);
                        copiedVersion.primaryKeyColumns.add((TransformColumn)newCol);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                        continue;
                    }
                    if (!hasInsert) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.INSERT, true);
                        copiedVersion.primaryKeyColumns.add((TransformColumn)newCol);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                    }
                    if (!hasUpdate) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.UPDATE, true);
                        copiedVersion.primaryKeyColumns.add((TransformColumn)newCol);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                    }
                    if (hasDelete) continue;
                    newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.DELETE, true);
                    copiedVersion.primaryKeyColumns.add((TransformColumn)newCol);
                    copiedVersion.transformColumns.add((TransformColumn)newCol);
                }
                for (String column : columnNames) {
                    hasInsert = false;
                    hasUpdate = false;
                    hasDelete = false;
                    columnLowerCase = column.toLowerCase();
                    for (TransformColumn xCol : copiedVersion.transformColumns) {
                        if ((!StringUtils.isNotBlank((CharSequence)xCol.getSourceColumnName()) || !columnLowerCase.equals(xCol.getSourceColumnNameLowerCase())) && (!StringUtils.isNotBlank((CharSequence)xCol.getTargetColumnName()) || !columnLowerCase.equals(xCol.getTargetColumnNameLowerCase()))) continue;
                        if (xCol.includeOn == TransformColumn.IncludeOnType.ALL) {
                            hasDelete = true;
                            hasUpdate = true;
                            hasInsert = true;
                            break;
                        }
                        if (xCol.includeOn == TransformColumn.IncludeOnType.INSERT) {
                            hasInsert = true;
                            continue;
                        }
                        if (xCol.includeOn == TransformColumn.IncludeOnType.UPDATE) {
                            hasUpdate = true;
                            continue;
                        }
                        if (xCol.includeOn != TransformColumn.IncludeOnType.DELETE) continue;
                        hasDelete = true;
                    }
                    if (!(hasInsert || hasUpdate || hasDelete)) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.ALL, false);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                        continue;
                    }
                    if (!hasInsert) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.INSERT, false);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                    }
                    if (!hasUpdate) {
                        newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.UPDATE, false);
                        copiedVersion.transformColumns.add((TransformColumn)newCol);
                    }
                    if (hasDelete) continue;
                    newCol = this.createImplicitTransformColumn(column, TransformColumn.IncludeOnType.DELETE, false);
                    copiedVersion.transformColumns.add((TransformColumn)newCol);
                }
            }
            return copiedVersion;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private TransformColumn createImplicitTransformColumn(String column, TransformColumn.IncludeOnType includeOnType, boolean pk) {
        TransformColumn newCol = new TransformColumn();
        newCol.setTransformId(this.transformId);
        newCol.setPk(pk);
        newCol.setIncludeOn(includeOnType);
        newCol.setTransformType("copy");
        newCol.setSourceColumnName(column);
        newCol.setTargetColumnName(column);
        return newCol;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }
}

