/*
 * Decompiled with CFR 0.152.
 */
package com.symmetric.corp.service;

import com.anfcorp.stores.symmetric.corp.model.RegionDef;
import com.anfcorp.stores.symmetric.corp.model.UdaStoreData;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

public class AdminService
implements ISymmetricEngineAware,
IExtensionPoint {
    protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String ASSIGN_RGN_ACTION = "ASSIGN_RGN";
    private static final String MSG_MISSING_TIMEZONE = "MISSING_TIMEZONE";
    private static final String LEVEL_WARN = "WARN";
    private static final String MSG_RUN = "RUN";
    private static final String MSG_MULTIPLE_FLAGSHIP_REGIONS = "MULTIPLE_FLAGSHIP_REGIONS";
    private static final String MSG_SUCCESS = "SUCCESS";
    private static final String LEVEL_INFO = "INFO";
    private static final String LEVEL_ERROR = "ERROR";
    private static final String MSG_NO_RGN = "NO_RGN";
    private static final String GC_SKUS_TO_TOUCH_PREFIX = "77777706";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Map<String, String> sql;
    protected DataSource dataSource;
    protected String[] storeSpecificTables;
    protected int maxStoresToAssignToRegion;
    protected long minMinutesBetweenRegionAssignmentRuns;
    protected boolean lockTableInitialized;
    protected boolean regionalAssignmentJobEnabled;
    protected ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    protected BigDecimal toNumber(String number) {
        if (!StringUtils.isBlank((String)number)) {
            return new BigDecimal(number);
        }
        return null;
    }

    protected Date toDate(String date) throws ParseException {
        if (!StringUtils.isBlank((String)date)) {
            return DateUtils.parseDate((String)date, (String[])new String[]{DATE_TIME_FORMAT});
        }
        return null;
    }

    protected Set<String> getStoreIdsFromCsv(String storeList) {
        String[] stores;
        HashSet<String> storeIds = null;
        if (!StringUtils.isBlank((String)storeList) && (stores = storeList.split(",")) != null) {
            for (String storeId : stores) {
                if (storeIds == null) {
                    storeIds = new HashSet<String>();
                }
                storeIds.add(storeId);
            }
        }
        return storeIds;
    }

    protected List<Integer> getBrandIdsFromCsv(String brandIdList) {
        String[] brandIdStrings;
        ArrayList<Integer> brandIds = null;
        if (!StringUtils.isBlank((String)brandIdList) && (brandIdStrings = brandIdList.split(",")) != null) {
            for (String brandId : brandIdStrings) {
                if (brandIds == null) {
                    brandIds = new ArrayList<Integer>();
                }
                brandIds.add(new Integer(brandId));
            }
        }
        return brandIds;
    }

    @Transactional
    public String deleteStoreFromRegion(String storeId, int regionNumber) {
        this.logger.info((Object)"Calling deleteStoreFromRegion.");
        String response = null;
        String regionNodeId = AdminService.getRegionNodeId(regionNumber);
        IDataService dataService = this.engine.getDataService();
        if (this.isRegionConfigured(regionNodeId)) {
            StringBuilder output = new StringBuilder();
            try {
                JdbcTemplate template = new JdbcTemplate(this.dataSource);
                template.update(this.sql.get("deleteStoreFromRegionSql"), new Object[]{storeId, AdminService.getRegionNodeId(regionNumber)});
                output.append("Deleting store from anf_registration_redirect\n");
                output.append(dataService.sendSQL(regionNodeId, null, null, "sym_node_security", String.format("delete from sym_node_security where node_id in (select node_id from sym_node where external_id='%s')", storeId)));
                output.append("\n");
                output.append(dataService.sendSQL(regionNodeId, null, null, "sym_node", String.format("delete from sym_node where external_id ='%s'", storeId)));
                NodeChannel channel = new NodeChannel();
                channel.setNodeId("reload");
                channel.setEnabled(true);
                if (this.storeSpecificTables != null) {
                    for (String tableName : this.storeSpecificTables) {
                        output.append(dataService.sendSQL(regionNodeId, null, null, tableName, String.format("delete from %s where id_str_rt='%s'", tableName, storeId)));
                        output.append("\n");
                    }
                }
            }
            catch (Exception ex) {
                output.append("\n");
                output.append(ExceptionUtils.getFullStackTrace((Throwable)ex));
            }
            response = output.toString();
        } else {
            response = this.getUnconfiguredRegionMessage(regionNodeId);
        }
        return this.wrapPreformattedText(response);
    }

    private String wrapPreformattedText(String text) {
        return "<pre>" + text + "</pre>";
    }

    private String getUnconfiguredRegionMessage(String regionNodeId) {
        return String.format("The region %s is currently not configured", regionNodeId);
    }

    @Transactional
    public String assignStoreToRegion(String storeId, int regionNumber) {
        this.logger.info((Object)"Calling assignStoreToRegion.");
        String response = null;
        String regionNodeId = AdminService.getRegionNodeId(regionNumber);
        response = this.assignStoreToRegion(storeId, regionNodeId);
        return this.wrapPreformattedText(response);
    }

    public String assignStoreToRegion(String storeId, String regionNodeId) {
        this.logger.info((Object)"Calling assignStoreToRegion.");
        String response = null;
        IDataService dataService = this.engine.getDataService();
        IRegistrationService registrationService = this.engine.getRegistrationService();
        if (this.isRegionConfigured(regionNodeId)) {
            Node node = new Node(regionNodeId, null, null);
            if (!this.isStoreAssignedToARegion(storeId)) {
                StringBuilder output = new StringBuilder();
                try {
                    NodeChannel channel = new NodeChannel();
                    channel.setNodeId("reload");
                    channel.setMaxBatchSize(3);
                    channel.setEnabled(true);
                    registrationService.saveRegistrationRedirect(storeId, regionNodeId);
                    if (this.storeSpecificTables != null) {
                        for (int i = this.storeSpecificTables.length - 1; i >= 0; --i) {
                            String tableName = this.storeSpecificTables[i];
                            dataService.insertSqlEvent(node, "call pack_symmetric.setValue(1)", false, -1L, "corp");
                            output.append(dataService.reloadTable(regionNodeId, null, null, tableName, String.format("id_str_rt='%s'", storeId)));
                            output.append("\n");
                            dataService.insertSqlEvent(node, "call pack_symmetric.setValue(null)", false, -1L, "corp");
                        }
                    }
                }
                catch (Exception ex) {
                    output.append("\n");
                    output.append(ExceptionUtils.getFullStackTrace((Throwable)ex));
                }
                response = output.toString();
            } else {
                response = String.format("The store, %s, is already assigned to %s", storeId, regionNodeId);
            }
        } else {
            response = this.getUnconfiguredRegionMessage(regionNodeId);
        }
        return this.wrapPreformattedText(response);
    }

    public List<UdaStoreData> findStoresWithNoRegion() {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List stores = template.query(this.sql.get("findStoresWithNoRegion"), (RowMapper)new AnfStoreDataRowMapper());
        return stores;
    }

    public List<RegionDef> findRegionsForTimezone(String timezone) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List regions = template.query(this.sql.get("findRegionsForTimeZone"), (RowMapper)new RegionDefRowMapper(), new Object[]{timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone, timezone});
        return regions;
    }

    public List<RegionDef> findRegionForFlagship(String storeId) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List regions = template.query(this.sql.get("findRegionForFlagship"), (RowMapper)new RegionDefRowMapper(), new Object[]{"%" + storeId + "%"});
        return regions;
    }

    public void assignStoresToRegionJob() {
        int numberOfStoresAssigned;
        this.logger.info((Object)"Calling assignStoresToRegionJob.");
        if (this.runRegionalAssignmentJob() && (numberOfStoresAssigned = this.assignStoresToRegion()) > 0) {
            this.logger.info((Object)("Number of stores assigned " + numberOfStoresAssigned));
            this.touchStoreRecordsToSync();
            this.createReturnReasonCodesForNewStores();
        }
    }

    @Transactional
    public void createReturnReasonCodesForNewStores() {
        this.logger.info((Object)"Calling createReturnReasonCodesForNewStores.");
        List<String> stores = this.findStoresToTouch();
        for (String store : stores) {
            this.logger.info((Object)("Creating return reason codes for store  " + store));
            this.createReturnReasonCodesForNewStore(store);
        }
    }

    public void createReturnReasonCodesForNewStore(String store) {
        this.logger.info((Object)"Calling createReturnReasonCodesForNewStore.");
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        int rowsAffected = template.update(this.sql.get("insertReturnReasonCodesForNewStore"), new Object[]{store, store});
        this.logger.info((Object)("Creating return reason codes for store  " + store + ", rows affected: " + rowsAffected));
    }

    @Transactional
    public void touchStoreRecordsToSync() {
        this.logger.info((Object)"Calling touchStoreRecordsToSync.");
        List<String> stores = this.findStoresToTouch();
        for (String store : stores) {
            this.logger.info((Object)("Touching records for store  " + store));
            this.touchParameters(store);
            this.touchGiftCardSKUs(store, GC_SKUS_TO_TOUCH_PREFIX);
            this.touchPromotions(store);
            if (!this.isAJBPXERecordNeeded(store)) continue;
            this.insertAJBGiftCardPXEParameter(store);
        }
    }

    public List<String> findStoresToTouch() {
        this.logger.info((Object)"Calling findStoresToTouch.");
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List stores = template.query(this.sql.get("findStoresToTouch"), (RowMapper)new StoreRowMapper(), new Object[]{MSG_SUCCESS});
        return stores;
    }

    protected void touchParameters(String store) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("touchParameters"), new Object[]{"%" + store + "%"});
    }

    protected void touchGCSKUsIdentityTable(String store, String gcSkus) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("touchIdentityTable"), new Object[]{store, "%" + gcSkus});
    }

    protected void touchGCSKUsStoreRetailTable(String store, String gcSkus) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("touchStoreRetail"), new Object[]{store, "%" + gcSkus});
    }

    protected void touchGiftCardSKUs(String store, String gcSkus) {
        this.touchGCSKUsIdentityTable(store, gcSkus);
        this.touchGCSKUsStoreRetailTable(store, gcSkus);
    }

    protected void touchPromotions(String store) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("touchPromotions"), new Object[]{store});
    }

    protected String getStoreCountry(String storeId) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List countryCode = template.query(this.sql.get("getStoreCountry"), (RowMapper)new StoreCountryRowMapper(), new Object[]{storeId});
        return (String)countryCode.get(0);
    }

    protected List<String> getNoPXERecordCountryList() {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List countryCodeList = template.query(this.sql.get("getNoPXERecordCountryList"), (RowMapper)new StoreCountryRowMapper(), new Object[]{"Location", "Config", "NoPXERecordCountry"});
        return countryCodeList;
    }

    protected boolean isAJBPXERecordNeeded(String store) {
        String country = this.getStoreCountry(store);
        List<String> noPXERecordCountryList = this.getNoPXERecordCountryList();
        return !StringUtils.isBlank((String)country) && !noPXERecordCountryList.isEmpty() && !noPXERecordCountryList.contains(country);
    }

    protected void insertAJBGiftCardPXEParameter(String store) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("insertAJBGiftCardPXEParameter"), new Object[]{"Location", "Config", "UseAJBGiftCards", "STORE_REG", store + "-001", "ANY", 1, "true"});
    }

    protected boolean runRegionalAssignmentJob() {
        boolean runJob = true;
        if (this.isRegionalAssignmentJobEnabled()) {
            Date currentTime;
            long timeSinceLastRunMinutes;
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            Date lastRunDate = (Date)template.queryForObject(this.sql.get("getLastRegionAssignmentRun"), Date.class, new Object[]{MSG_RUN});
            if (lastRunDate != null && (timeSinceLastRunMinutes = ((currentTime = new Date()).getTime() - lastRunDate.getTime()) / 60000L) < this.minMinutesBetweenRegionAssignmentRuns) {
                runJob = false;
            }
        } else {
            runJob = false;
        }
        return runJob;
    }

    @Transactional
    public int assignStoresToRegion() {
        this.logger.info((Object)"Calling assignStoresToRegion.");
        IClusterService clusterService = this.engine.getClusterService();
        int numAssigned = 0;
        this.initLockTable();
        if (clusterService.lock(ASSIGN_RGN_ACTION)) {
            try {
                Date runDate = new Date();
                List<UdaStoreData> unassignedStores = this.findStoresWithNoRegion();
                this.logRegionAssignmentResult(runDate, MSG_RUN, LEVEL_INFO, "Number of unassigned stores: " + unassignedStores.size() + ". Max number of stores that will assigned: " + this.maxStoresToAssignToRegion, null);
                boolean assignedStore = false;
                for (UdaStoreData store : unassignedStores) {
                    assignedStore = this.isFlagship(store) ? this.assignFlagshipToRegion(store, runDate) : this.assignNonFlagshipToRegion(store, runDate);
                    if (assignedStore) {
                        ++numAssigned;
                    }
                    if (numAssigned < this.maxStoresToAssignToRegion) continue;
                }
            }
            catch (RuntimeException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                clusterService.unlock(ASSIGN_RGN_ACTION);
            }
        } else {
            this.logger.info((Object)"Skipping assignment of stores to region because the service is locked.");
        }
        return numAssigned;
    }

    private boolean isFlagship(UdaStoreData store) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        return (Integer)template.queryForObject(this.sql.get("findFlagshipCount"), Integer.class, new Object[]{"%" + store.getStoreId() + "%"}) > 0;
    }

    protected boolean assignNonFlagshipToRegion(UdaStoreData store, Date runDate) {
        boolean assignedStore = false;
        if (StringUtils.isBlank((String)store.getTimeZone())) {
            this.logRegionAssignmentResult(runDate, MSG_MISSING_TIMEZONE, LEVEL_ERROR, "Store has no timezone assigned: " + store.getStoreId(), null);
        } else {
            List<RegionDef> regions = this.findRegionsForTimezone(store.getTimeZone());
            if (regions.size() == 0) {
                this.logRegionAssignmentResult(runDate, MSG_NO_RGN, LEVEL_ERROR, "No region setup for timezone <" + store.getTimeZone() + ">. Unable to assign store " + store.getStoreId(), null);
            } else {
                StringBuffer messageBuffer = new StringBuffer();
                for (RegionDef regionDef : regions) {
                    if (regionDef.getNumAssignedStores() < regionDef.getMaxStores()) {
                        assignedStore = true;
                        this.assignStoreToRegion(store.getStoreId(), regionDef.getRegionId());
                        this.logSuccessfulRegionAssignment(store, runDate, regionDef, null);
                        break;
                    }
                    messageBuffer.append(" <Region: ").append(regionDef.getRegionId()).append(" Max Stores: ").append(regionDef.getMaxStores()).append(" Assigned Stores: ").append(regionDef.getNumAssignedStores()).append(">");
                }
                if (!assignedStore) {
                    String msg = "No region available for timezone <" + store.getTimeZone() + ">. Unable to assign store " + store.getStoreId() + ". Region Information: " + messageBuffer.toString();
                    this.logRegionAssignmentResult(new Date(), MSG_NO_RGN, LEVEL_ERROR, msg, null);
                }
            }
        }
        return assignedStore;
    }

    protected boolean assignFlagshipToRegion(UdaStoreData store, Date runDate) {
        boolean assignedStore = false;
        List<RegionDef> regions = this.findRegionForFlagship(store.getStoreId());
        if (regions.size() == 0) {
            this.logRegionAssignmentResult(runDate, MSG_NO_RGN, LEVEL_ERROR, "No region setup for flagship " + store.getStoreId(), null);
        } else {
            if (regions.size() > 1) {
                StringBuffer messageBuffer = new StringBuffer();
                for (RegionDef regionDef : regions) {
                    messageBuffer.append(" Region: ").append(regionDef.getRegionId()).append(" Flagship Store Ids: ").append(regionDef.getFlagshipStoreIds()).append(".");
                }
                this.logRegionAssignmentResult(runDate, MSG_MULTIPLE_FLAGSHIP_REGIONS, LEVEL_WARN, "Multiple flagship regions for store: " + store.getStoreId(), messageBuffer.toString());
            }
            RegionDef regionDef = regions.get(0);
            this.assignStoreToRegion(store.getStoreId(), regionDef.getRegionId());
            assignedStore = true;
            this.logSuccessfulRegionAssignment(store, runDate, regionDef, null);
        }
        return assignedStore;
    }

    protected void logSuccessfulRegionAssignment(UdaStoreData store, Date runDate, RegionDef regionDef, String messageDetail) {
        int numAssigned = regionDef.getNumAssignedStores() + 1;
        String flagship = store.isFlagship() ? "Flagship " : "";
        this.logRegionAssignmentResult(runDate, MSG_SUCCESS, LEVEL_INFO, flagship + "Store " + store.getStoreId() + " assigned to region " + regionDef.getRegionId() + " for timezone " + store.getTimeZone() + ". Region capacity: " + regionDef.getMaxStores() + ". Currently Assigned: " + numAssigned, messageDetail);
    }

    protected void logRegionAssignmentResult(Date jobTime, String msgId, String logLevel, String message, String messageDetail) {
        if (LEVEL_INFO.equals(logLevel)) {
            this.logger.info((Object)message);
        } else if (LEVEL_WARN.equals(logLevel)) {
            this.logger.warn((Object)message);
        } else if (LEVEL_ERROR.equals(logLevel)) {
            this.logger.error((Object)message);
        }
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.update(this.sql.get("insertRegionAssignmentLog"), new Object[]{jobTime, msgId, logLevel, StringUtils.abbreviate((String)message, (int)500), StringUtils.abbreviate((String)messageDetail, (int)1000)});
    }

    protected boolean isRegionConfigured(String regionNodeId) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        return (Integer)template.queryForObject(this.sql.get("isRegionConfiguredSql"), Integer.class, new Object[]{regionNodeId}) > 0;
    }

    protected boolean isStoreAssignedToARegion(String storeId) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        return (Integer)template.queryForObject(this.sql.get("isStoreAssignedToARegionSql"), Integer.class, new Object[]{storeId}) > 0;
    }

    protected static String getRegionNodeId(int regionNumber) {
        return String.format("rgn%1$02d", regionNumber);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSql(Map<String, String> sql) {
        this.sql = sql;
    }

    public void setStoreSpecificTables(String[] storeSpecificTables) {
        this.storeSpecificTables = storeSpecificTables;
    }

    public void setMaxStoresToAssignToRegion(int maxStoresToAssignToRegion) {
        this.maxStoresToAssignToRegion = maxStoresToAssignToRegion;
    }

    protected void initLockTable() {
        if (!this.lockTableInitialized) {
            this.lockTableInitialized = true;
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            try {
                template.update("insert into sym_lock (lock_action, lock_type) values(?,?)", new Object[]{ASSIGN_RGN_ACTION, "CLUSTER"});
            }
            catch (DataAccessException dataAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isRegionalAssignmentJobEnabled() {
        return this.regionalAssignmentJobEnabled;
    }

    public void setRegionalAssignmentJobEnabled(boolean regionalAssignmentJobEnabled) {
        this.regionalAssignmentJobEnabled = regionalAssignmentJobEnabled;
    }

    public void setMinMinutesBetweenRegionAssignmentRuns(long minMinutesBetweenRegionAssignmentRuns) {
        this.minMinutesBetweenRegionAssignmentRuns = minMinutesBetweenRegionAssignmentRuns;
    }

    public static void main(String[] args) {
        System.out.println(new Date());
    }

    class AnfStoreDataRowMapper
    implements RowMapper<UdaStoreData> {
        AnfStoreDataRowMapper() {
        }

        public UdaStoreData mapRow(ResultSet rs, int num) throws SQLException {
            UdaStoreData store = new UdaStoreData();
            store.setStoreId(rs.getString(1));
            store.setTimeZone(rs.getString(2));
            store.setFlagship(rs.getString(3));
            return store;
        }
    }

    class RegionDefRowMapper
    implements RowMapper<RegionDef> {
        RegionDefRowMapper() {
        }

        public RegionDef mapRow(ResultSet rs, int num) throws SQLException {
            RegionDef store = new RegionDef();
            store.setRegionId(rs.getString(1));
            store.setMaxStores(rs.getInt(2));
            store.setFlagshipStoreIds(rs.getString(3));
            store.setNumAssignedStores(rs.getInt(4));
            return store;
        }
    }

    class StoreRowMapper
    implements RowMapper<String> {
        StoreRowMapper() {
        }

        public String mapRow(ResultSet rs, int num) throws SQLException {
            return rs.getString(1);
        }
    }

    class StoreCountryRowMapper
    implements RowMapper<String> {
        StoreCountryRowMapper() {
        }

        public String mapRow(ResultSet rs, int num) throws SQLException {
            return rs.getString(1);
        }
    }
}

