/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.mail;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailSender {
    private static Log logger = LogFactory.getLog(MailSender.class);
    private JavaMailSenderImpl mailSender;
    private String from;
    private String subject;
    private String to;
    private String cc;
    private String body;
    private static String serverName;

    public String getBody() {
        return this.body;
    }

    public void sendMail(String errorMessage, String errorType) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from);
            String[] toList = this.to.split(",");
            helper.setTo(toList);
            String[] ccList = this.cc.split(",");
            helper.setCc(ccList);
            if (errorType != null) {
                this.subject = errorType;
            }
            helper.setSubject(this.subject + " on" + serverName);
            helper.setText(errorMessage);
            this.mailSender.send(message);
        }
        catch (MessagingException e) {
            String errorMsg = "Could not email the exception.";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg);
        }
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    static {
        try {
            serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception x) {
            serverName = "unknown";
            logger.error((Object)"Unable to determine local hostname", (Throwable)x);
        }
    }
}

