/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.router;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class StoreInfoDataRouter
extends AbstractDataRouter
implements ISymmetricEngineAware {
    private static final String ANY = "ANY";
    private static final Log log = LogFactory.getLog(StoreInfoDataRouter.class);
    private Map<String, String> sql;
    private ISymmetricEngine engine;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        HashSet<String> nodeIds = new HashSet<String>();
        this.routeDeploymentPackages(dataMetaData, nodes, nodeIds);
        this.routeParameters(dataMetaData, nodes, nodeIds);
        log.debug((Object)("Routed " + dataMetaData.getData().getTableName() + " to " + nodeIds));
        return nodeIds;
    }

    protected void routeParameters(DataMetaData dataMetaData, Set<Node> nodes, Set<String> nodeIds) {
        Data data = dataMetaData.getData();
        if (data.getTableName().equalsIgnoreCase("ANF_PARAMETER")) {
            Map columnValues = this.getDataMap(dataMetaData, this.engine.getSymmetricDialect());
            this.routeParametersUsing("", columnValues, nodes, nodeIds);
            this.routeParametersUsing("OLD_", columnValues, nodes, nodeIds);
        }
    }

    protected void routeParametersUsing(String columnPrefix, Map<String, String> columnValues, Set<Node> nodes, Set<String> nodeIds) {
        block10: {
            String levelId = columnValues.get(columnPrefix + "PARAM_LEVEL_ID");
            String levelValue = columnValues.get(columnPrefix + "PARAM_LEVEL_VALUE");
            String brandId = columnValues.get(columnPrefix + "BRAND");
            if (levelId == null || levelValue == null || brandId == null) break block10;
            Set<String> storesForBrand = null;
            storesForBrand = !brandId.equals(ANY) ? this.getStoresForBrands(new String[]{brandId}) : this.toExternalIds(nodes);
            if ("STORE".equals(levelId)) {
                for (Node node : nodes) {
                    if (!node.getExternalId().equals(levelValue)) continue;
                    nodeIds.add(node.getNodeId());
                }
            } else if ("COUNTRY".equals(levelId)) {
                Set<String> stores = this.getStoresForCountry(levelValue);
                for (Node node : nodes) {
                    if (!stores.contains(node.getExternalId()) || !storesForBrand.contains(node.getExternalId())) continue;
                    nodeIds.add(node.getNodeId());
                }
            } else if ("COUNTRY_STATE".equals(levelId)) {
                Set<String> stores = this.getStoresForCountryState(levelValue);
                for (Node node : nodes) {
                    if (!stores.contains(node.getExternalId()) || !storesForBrand.contains(node.getExternalId())) continue;
                    nodeIds.add(node.getNodeId());
                }
            } else {
                for (Node node : nodes) {
                    if (!storesForBrand.contains(node.getExternalId())) continue;
                    nodeIds.add(node.getNodeId());
                }
            }
        }
    }

    protected void routeDeploymentPackages(DataMetaData dataMetaData, Set<Node> nodes, Set<String> nodeIds) {
        Data data = dataMetaData.getData();
        if (data.getTableName().equalsIgnoreCase("ANF_DEPLOYMENT_PACKAGE")) {
            Map columnValues = this.getDataMap(dataMetaData, this.engine.getSymmetricDialect());
            this.routeDeploymentPackagesUsing("", columnValues, nodes, nodeIds);
            this.routeDeploymentPackagesUsing("OLD_", columnValues, nodes, nodeIds);
        }
    }

    protected void routeDeploymentPackagesUsing(String columnPrefix, Map<String, String> columnValues, Set<Node> nodes, Set<String> nodeIds) {
        String brands = columnValues.get(columnPrefix + "ALLOWED_BRAND_LIST");
        if (brands != null) {
            if (brands.equals(ANY)) {
                nodeIds = this.toNodeIds(nodes, nodeIds);
            } else {
                String[] brandIds = brands.split(",");
                Set<String> stores = this.getStoresForBrands(brandIds);
                for (Node node : nodes) {
                    if (!stores.contains(node.getExternalId())) continue;
                    nodeIds.add(node.getNodeId());
                }
            }
        }
    }

    protected Set<String> getStoresForBrands(String[] brands) {
        HashSet<String> stores = new HashSet<String>();
        DataSource ds = (DataSource)this.engine.getDatabasePlatform().getDataSource();
        for (String id : brands) {
            stores.addAll(new JdbcTemplate(ds).queryForList(this.sql.get("selectStoresForBrand"), new Object[]{id}, String.class));
        }
        return stores;
    }

    protected Set<String> getStoresForCountry(String country) {
        HashSet<String> stores = new HashSet<String>();
        DataSource ds = (DataSource)this.engine.getDatabasePlatform().getDataSource();
        stores.addAll(new JdbcTemplate(ds).queryForList(this.sql.get("selectStoresForCountry"), new Object[]{country}, String.class));
        return stores;
    }

    protected Set<String> getStoresForCountryState(String countryState) {
        HashSet<String> stores = new HashSet<String>();
        DataSource ds = (DataSource)this.engine.getDatabasePlatform().getDataSource();
        stores.addAll(new JdbcTemplate(ds).queryForList(this.sql.get("selectStoresForCountryState"), new Object[]{countryState}, String.class));
        return stores;
    }

    public void setSql(Map<String, String> sql) {
        this.sql = sql;
    }
}

