/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.router;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;

public class DmlStatement {
    protected DmlStatement.DmlType dmlType;
    protected String sql;
    protected int[] types;
    protected String quote;
    protected Column[] keys;
    protected Column[] columns;
    protected boolean[] nullKeyValues;

    public DmlStatement(DmlStatement.DmlType type, String catalogName, String schemaName, String tableName, Column[] keysColumns, Column[] columns, boolean isDateOverrideToTimestamp, String identifierQuoteString, boolean[] nullKeyValues) {
        this.columns = columns;
        if (nullKeyValues == null || keysColumns == null || nullKeyValues.length != keysColumns.length) {
            this.keys = keysColumns;
            this.nullKeyValues = keysColumns == null ? null : new boolean[keysColumns.length];
        } else {
            ArrayList<Column> cols = new ArrayList<Column>(keysColumns.length);
            for (int i = 0; i < keysColumns.length; ++i) {
                if (nullKeyValues[i]) continue;
                cols.add(keysColumns[i]);
            }
            this.keys = cols.toArray(new Column[cols.size()]);
            this.nullKeyValues = nullKeyValues;
        }
        String string = this.quote = identifierQuoteString == null ? "" : identifierQuoteString;
        if (type == DmlStatement.DmlType.INSERT) {
            this.sql = this.buildInsertSql(DmlStatement.getFullyQualifiedTableName(catalogName, schemaName, tableName, identifierQuoteString), keysColumns, columns);
        } else if (type == DmlStatement.DmlType.UPDATE) {
            this.sql = this.buildUpdateSql(DmlStatement.getFullyQualifiedTableName(catalogName, schemaName, tableName, identifierQuoteString), keysColumns, columns);
        } else if (type == DmlStatement.DmlType.DELETE) {
            this.sql = this.buildDeleteSql(DmlStatement.getFullyQualifiedTableName(catalogName, schemaName, tableName, identifierQuoteString), keysColumns);
        } else {
            throw new NotImplementedException("Unimplemented SQL type: " + type);
        }
        this.dmlType = type;
        this.types = this.buildTypes(this.keys, columns, isDateOverrideToTimestamp);
    }

    public static String getFullyQualifiedTableName(String catalogName, String schemaName, String tableName, String quoteString) {
        if (quoteString == null) {
            quoteString = "";
        }
        return DmlStatement.getQualifiedTablePrefix(catalogName, schemaName, quoteString) + quoteString + tableName + quoteString;
    }

    public static String getQualifiedTablePrefix(String catalogName, String schemaName, String quoteString) {
        if (quoteString == null) {
            quoteString = "";
        }
        Object fullyQualified = "";
        if (!StringUtils.isBlank((String)schemaName)) {
            fullyQualified = quoteString + schemaName + quoteString + "." + (String)fullyQualified;
        }
        if (!StringUtils.isBlank((String)catalogName)) {
            fullyQualified = quoteString + catalogName + quoteString + "." + (String)fullyQualified;
        }
        return fullyQualified;
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        switch (this.dmlType) {
            case UPDATE: {
                int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
                int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
                return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
            }
            case INSERT: {
                return this.buildTypes(columns, isDateOverrideToTimestamp);
            }
            case DELETE: {
                return this.buildTypes(keys, isDateOverrideToTimestamp);
            }
        }
        return null;
    }

    protected int getTypeCode(Column column, boolean isDateOverrideToTimestamp) {
        int type = column.getMappedTypeCode();
        if (type == 91 && isDateOverrideToTimestamp) {
            type = 93;
        } else if (type == 6 || type == 8 || type == 7) {
            type = 3;
        }
        return type;
    }

    protected int[] buildTypes(Column[] columns, boolean isDateOverrideToTimestamp) {
        if (columns != null) {
            ArrayList<Integer> list = new ArrayList<Integer>(columns.length);
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                list.add(this.getTypeCode(columns[i], isDateOverrideToTimestamp));
            }
            int[] types = new int[list.size()];
            for (int index = 0; index < list.size(); ++index) {
                types[index] = (Integer)list.get(index);
            }
            return types;
        }
        return null;
    }

    protected String buildInsertSql(String tableName, Column[] keys, Column[] columns) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + " (");
        this.appendColumns(sql, columns, false);
        sql.append(") values (");
        this.appendColumnQuestions(sql, columns);
        sql.append(")");
        return sql.toString();
    }

    protected String buildUpdateSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnEquals(sql, columns, ", ");
        if (keyColumns != null && keyColumns.length > 0) {
            sql.append(" where ");
            this.appendColumnEquals(sql, keyColumns, this.nullKeyValues, " and ");
        }
        return sql.toString();
    }

    protected String buildDeleteSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildFromSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder(" from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildCountSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("select count(*) from ").append(tableName);
        if (keyColumns != null && keyColumns.length > 0) {
            sql.append(" where ");
            this.appendColumnEquals(sql, keyColumns, this.nullKeyValues, " and ");
        }
        return sql.toString();
    }

    protected String buildSelectSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumns(sql, columns, true);
        sql.append(" from ").append(tableName).append(" where ");
        this.appendColumnEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildSelectSqlAll(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumns(sql, columns, true);
        sql.append(" from ").append(tableName);
        return sql.toString();
    }

    protected void appendColumnEquals(StringBuilder sql, Column[] columns, String separator) {
        this.appendColumnEquals(sql, columns, new boolean[columns.length], separator);
    }

    protected void appendColumnEquals(StringBuilder sql, Column[] columns, boolean[] nullColumns, String separator) {
        int existingCount = 0;
        if (columns != null) {
            for (int i = 0; i < columns.length && i < nullColumns.length; ++i) {
                if (columns[i] == null) continue;
                if (existingCount++ > 0) {
                    sql.append(separator);
                }
                if (!nullColumns[i]) {
                    sql.append(this.quote).append(columns[i].getName()).append(this.quote).append(" = ?");
                    continue;
                }
                sql.append(this.quote).append(columns[i].getName()).append(this.quote).append(" is NULL");
            }
        }
    }

    protected int appendColumns(StringBuilder sql, Column[] columns, boolean select) {
        int existingCount = 0;
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                if (existingCount++ > 0) {
                    sql.append(", ");
                }
                this.appendColumnNameForSql(sql, columns[i], select);
            }
        }
        return existingCount;
    }

    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        sql.append(this.quote).append(columnName).append(this.quote);
    }

    protected void appendColumnQuestions(StringBuilder sql, Column[] columns) {
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                sql.append("?").append(",");
            }
            if (columns.length > 0) {
                sql.replace(sql.length() - 1, sql.length(), "");
            }
        }
    }

    public String getColumnsSql(Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumns(sql, columns, true);
        sql.append(this.getSql());
        return sql.toString();
    }

    public String getSql() {
        return this.sql;
    }

    public DmlStatement.DmlType getDmlType() {
        return this.dmlType;
    }

    public int[] getTypes() {
        return this.types;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Column[] getColumnKeyMetaData() {
        return (Column[])ArrayUtils.addAll((Object[])this.columns, (Object[])this.keys);
    }

    public Column[] getMetaData() {
        switch (this.dmlType) {
            case UPDATE: {
                return this.getColumnKeyMetaData();
            }
            case INSERT: {
                return this.getColumns();
            }
            case DELETE: {
                return this.getKeys();
            }
        }
        return null;
    }

    public Column[] getKeys() {
        return this.keys;
    }

    public <T> T[] getValueArray(T[] columnValues, T[] keyValues) {
        switch (this.dmlType) {
            case UPDATE: {
                return ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
            }
            case INSERT: {
                return columnValues;
            }
            case DELETE: {
                return keyValues;
            }
        }
        return null;
    }

    public Object[] getValueArray(Map<String, Object> params) {
        Object[] args = null;
        if (params != null) {
            int index = 0;
            switch (this.dmlType) {
                case INSERT: {
                    args = new Object[this.columns.length];
                    for (Column column : this.columns) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                case UPDATE: {
                    args = new Object[this.columns.length + this.keys.length];
                    for (Column column : this.columns) {
                        args[index++] = params.get(column.getName());
                    }
                    for (Column column : this.keys) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                case DELETE: {
                    args = new Object[this.keys.length];
                    for (Column column : this.keys) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return args;
    }
}

