/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.model;

import com.anfcorp.stores.symmetric.corp.OutboundSalesXmlPublisherFilter;
import com.anfcorp.stores.symmetric.corp.model.CurrencyBean;
import java.math.BigDecimal;
import java.util.Map;

public class TrRtl {
    private String idStrRt = null;
    private String idWs = null;
    private String dcDyBsn = null;
    private String aiTrn = null;
    private BigDecimal extdPriceTotal = null;
    private BigDecimal discPriceTotal = null;
    private BigDecimal retailPriceTotal = null;
    private BigDecimal discountAmount = null;

    public TrRtl() {
    }

    public TrRtl(Map<String, String> myExtdItemPriceMap, Map<String, String> myDiscItemPriceMap, Map<String, String> myRetailItemPriceMap, CurrencyBean currencyBean) {
        this.initialize(myExtdItemPriceMap, myDiscItemPriceMap, myRetailItemPriceMap, currencyBean);
    }

    public void setTrRtlTotals(Map<String, String> myExtdItemPriceMap, Map<String, String> myDiscItemPriceMap, Map<String, String> myRetailItemPriceMap, CurrencyBean currencyBean) {
        this.initialize(myExtdItemPriceMap, myDiscItemPriceMap, myRetailItemPriceMap, currencyBean);
    }

    public void initialize(Map<String, String> myExtdItemPriceMap, Map<String, String> myDiscItemPriceMap, Map<String, String> myRetailItemPriceMap, CurrencyBean currencyBean) {
        this.extdPriceTotal = new BigDecimal("0.00");
        this.discPriceTotal = new BigDecimal("0.00");
        this.retailPriceTotal = new BigDecimal("0.00");
        this.discountAmount = new BigDecimal("0.00");
        for (String key : myExtdItemPriceMap.keySet()) {
            if (myExtdItemPriceMap != null && myExtdItemPriceMap.get(key) != null) {
                this.extdPriceTotal = this.extdPriceTotal.add(new BigDecimal(myExtdItemPriceMap.get(key)));
            }
            if (myDiscItemPriceMap != null && myDiscItemPriceMap.get(key) != null) {
                this.discPriceTotal = this.discPriceTotal.add(new BigDecimal(myDiscItemPriceMap.get(key)));
            }
            if (myRetailItemPriceMap == null || myRetailItemPriceMap.get(key) == null) continue;
            this.retailPriceTotal = this.retailPriceTotal.add(new BigDecimal(myRetailItemPriceMap.get(key)));
        }
        this.discountAmount = OutboundSalesXmlPublisherFilter.round(this.extdPriceTotal, currencyBean.getCurrencyScale()).subtract(OutboundSalesXmlPublisherFilter.round(this.discPriceTotal, currencyBean.getCurrencyScale()));
    }

    public String getIdStrRt() {
        return this.idStrRt;
    }

    public String getIdWs() {
        return this.idWs;
    }

    public String getDcDyBsn() {
        return this.dcDyBsn;
    }

    public String getAiTrn() {
        return this.aiTrn;
    }

    public void setIdStrRt(String idStrRt) {
        this.idStrRt = idStrRt;
    }

    public void setIdWs(String idWs) {
        this.idWs = idWs;
    }

    public void setDcDyBsn(String dcDyBsn) {
        this.dcDyBsn = dcDyBsn;
    }

    public void setAiTrn(String aiTrn) {
        this.aiTrn = aiTrn;
    }

    public BigDecimal getExtdPriceTotal() {
        return this.extdPriceTotal;
    }

    public BigDecimal getDiscPriceTotal() {
        return this.discPriceTotal;
    }

    public BigDecimal getRetailPriceTotal() {
        return this.retailPriceTotal;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setExtdPriceTotal(BigDecimal extdPriceTotal) {
        this.extdPriceTotal = extdPriceTotal;
    }

    public void setDiscPriceTotal(BigDecimal discPriceTotal) {
        this.discPriceTotal = discPriceTotal;
    }

    public void setRetailPriceTotal(BigDecimal retailPriceTotal) {
        this.retailPriceTotal = retailPriceTotal;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }
}

