/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.format;

import com.anfcorp.stores.symmetric.corp.TemplatedPublisherFilter;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.model.Table;

public class PeoplesoftStoreIdFormat
implements TemplatedPublisherFilter.IFormat {
    static final Log logger = LogFactory.getLog(PeoplesoftStoreIdFormat.class);
    boolean useOldPeoplesoftStoreIdFormat;

    @Override
    public String format(Table table, String[] allData, String data) throws ParseException {
        return this.toPeoplesoftStoreIdFormat(data);
    }

    public String toPeoplesoftStoreIdFormat(String storeId) {
        if (this.useOldPeoplesoftStoreIdFormat) {
            char brandId = ((String)storeId).charAt(0);
            storeId = ((String)storeId).substring(1);
            int numericId = Integer.parseInt((String)storeId);
            switch (brandId) {
                case '1': {
                    storeId = "A" + numericId;
                    break;
                }
                case '2': {
                    storeId = "K" + numericId;
                    break;
                }
                case '3': {
                    storeId = "H" + numericId;
                    break;
                }
                case '4': {
                    storeId = "R" + numericId;
                    break;
                }
                case '5': {
                    storeId = "G" + numericId;
                    break;
                }
                default: {
                    logger.error((Object)("Unrecognized brand id: " + brandId));
                }
            }
        }
        return storeId;
    }

    public void setUseOldPeoplesoftStoreIdFormat(boolean useOldPeoplesoftStoreIdFormat) {
        this.useOldPeoplesoftStoreIdFormat = useOldPeoplesoftStoreIdFormat;
    }
}

