/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TimeZoneCache {
    final Log logger = LogFactory.getLog(this.getClass());
    protected Map<String, String> TIMEZONE_CACHE = new HashMap<String, String>();
    protected Calendar lastBuildDate = null;
    protected String timeZoneLookupSql;
    protected DataSource dataSource;

    public synchronized String lookupTimeZoneOffSet(String storeId) {
        if (!this.TIMEZONE_CACHE.containsKey(storeId) || this.lastBuildDate == null || Calendar.getInstance().get(6) != this.lastBuildDate.get(6)) {
            this.TIMEZONE_CACHE.clear();
            this.logger.info((Object)"Building the timezone cache");
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            template.query(this.timeZoneLookupSql, (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    String offset = TimeZoneCache.this.getTimeZoneOffset(rs.getString(2));
                    if (offset != null) {
                        TimeZoneCache.this.TIMEZONE_CACHE.put(rs.getString(1), offset);
                    }
                    return null;
                }
            });
            this.lastBuildDate = Calendar.getInstance();
        }
        return TimeZoneCache.sanitizeOffsetForPeoplesoft(this.TIMEZONE_CACHE.get(storeId));
    }

    protected String getTimeZoneOffset(String timezoneName) {
        String retVal = null;
        if (StringUtils.isNotBlank((String)timezoneName)) {
            TimeZone timezone = TimeZone.getTimeZone(timezoneName);
            Integer offset = timezone.getRawOffset();
            Integer hours = offset / 1000 / 3600;
            DecimalFormat format = new DecimalFormat("+00.00;-00.00");
            String value = format.format(hours);
            retVal = value.replace(".", ":");
        }
        return retVal;
    }

    public static String sanitizeOffsetForPeoplesoft(String offset) {
        if (!StringUtils.isBlank((String)offset) && offset.indexOf(":") >= 0) {
            offset = offset.replace(":", "");
        }
        return offset;
    }

    public void addTimeZone(String storeId, String timeZoneOffset) {
        this.lastBuildDate = Calendar.getInstance();
        this.TIMEZONE_CACHE.put(storeId, timeZoneOffset);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTimeZoneLookupSql(String timeZoneLookupSql) {
        this.timeZoneLookupSql = timeZoneLookupSql;
    }
}

