/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.symmetric.corp.model.ReturnTransaction;
import com.anfcorp.stores.symmetric.corp.model.TransactionId;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class ReturnSaleFilter
extends DatabaseWriterFilterAdapter
implements INodeGroupExtensionPoint {
    static final Log logger = LogFactory.getLog(ReturnSaleFilter.class);
    private Map<String, String> sql;
    private DataSource dataSource;
    private final String CTX_CACHE_RETURN_TRANSACTIONS_IN_BATCH = "RETURN_TRANSACTIONS_IN_BATCH-" + ((Object)((Object)this)).hashCode();

    public String[] getNodeGroupIdsToApplyTo() {
        return new String[]{"corp"};
    }

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        if (data.getDataEventType() == DataEventType.UPDATE && table.getName().equalsIgnoreCase("TR_LTM_SLS_RTN")) {
            return false;
        }
        if (data.getDataEventType() == DataEventType.UPDATE && context != null && table.getName().equalsIgnoreCase("TR_LTM_CRDB_CRD_TN")) {
            String[] values = data.getParsedData("rowData");
            boolean dcReturn = StringUtils.equalsIgnoreCase((String)values[table.getColumnIndex("TY_AUTH_ENC")], (String)"W");
            context.put("DC_RETURN", (Object)(dcReturn ? Boolean.TRUE : Boolean.FALSE));
        } else if (data.getDataEventType() == DataEventType.INSERT) {
            String[] columnValues = data.getParsedData("rowData");
            if (table.getName().equalsIgnoreCase("TR_TRN") && ("2".equals(columnValues[table.getColumnIndex("TY_TRN")]) || "1".equals(columnValues[table.getColumnIndex("TY_TRN")])) && "2".equals(columnValues[table.getColumnIndex("SC_TRN")])) {
                TransactionId id = this.getTransactionId(table, context, columnValues);
                this.getReturnTransactionList(context).put(id, new ReturnTransaction(id));
            } else if (table.getName().equalsIgnoreCase("TR_LTM_TND")) {
                this.addTenderLineItems(table, context, columnValues);
            } else if (table.getName().equalsIgnoreCase("TR_LTM_SLS_RTN") && "1".equals(columnValues[table.getColumnIndex("FL_RTN_MR")]) && this.isNotVoided(table, context, columnValues)) {
                this.updateOriginalLineItems(table, context, columnValues);
            }
        }
        return true;
    }

    public void batchComplete(DataContext context) {
        this.updateOriginalTenderBuckets(context);
        context.remove(this.CTX_CACHE_RETURN_TRANSACTIONS_IN_BATCH);
    }

    private void addOriginalTransactionId(Table table, DataContext context, String[] columnValues, TransactionId originalId) {
        ReturnTransaction tx = this.getReturnTransactionList(context).get(this.getTransactionId(table, context, columnValues));
        if (tx != null) {
            tx.getOriginalTransactions().add(originalId);
        }
    }

    private void updateOriginalLineItems(Table table, DataContext context, String[] columnValues) {
        TransactionId originalId;
        ReturnTransaction tx = this.getReturnTransactionList(context).get(this.getTransactionId(table, context, columnValues));
        if (tx != null && (originalId = this.getOriginalTransactionId(table, context, columnValues)) != null) {
            this.addOriginalTransactionId(table, context, columnValues, originalId);
            BigDecimal quantityReturned = this.getQuantityReturned(table, context, columnValues);
            String originalLnItmSeqNum = null;
            if (table.getColumnIndex("AI_LN_ITM_ORG") >= 0) {
                originalLnItmSeqNum = columnValues[table.getColumnIndex("AI_LN_ITM_ORG")];
            }
            this.updateOriginalTransactionLineItem(context, originalId, originalLnItmSeqNum, quantityReturned);
        }
    }

    private TransactionId getOriginalTransactionId(Table table, DataContext context, String[] columnValues) {
        String orgBusDate = columnValues[table.getColumnIndex("DC_DY_BSN_ORG")];
        String orgTransID = columnValues[table.getColumnIndex("ID_TRN_ORG")];
        if (orgTransID == null || orgTransID.length() <= 8) {
            return null;
        }
        String orgStoreID = orgTransID.substring(0, 5);
        String orgWorkstationId = orgTransID.substring(5, 8);
        String orgTrnSeqNum = orgTransID.substring(8);
        Integer iorgTrnSeqNum = Integer.valueOf(orgTrnSeqNum);
        return new TransactionId(orgStoreID, orgBusDate, orgWorkstationId, iorgTrnSeqNum);
    }

    private TransactionId getTransactionId(Table table, DataContext context, String[] columnValues) {
        return new TransactionId(columnValues[table.getColumnIndex("ID_STR_RT")], columnValues[table.getColumnIndex("DC_DY_BSN")], columnValues[table.getColumnIndex("ID_WS")], Integer.parseInt(columnValues[table.getColumnIndex("AI_TRN")]));
    }

    private void addTenderLineItems(Table table, DataContext context, String[] columnValues) {
        ReturnTransaction tx = this.getReturnTransactionList(context).get(this.getTransactionId(table, context, columnValues));
        if (tx != null) {
            String tenderType = columnValues[table.getColumnIndex("TY_TND")];
            BigDecimal tenderAmount = new BigDecimal(columnValues[table.getColumnIndex("MO_ITM_LN_TND")]);
            if (tenderType.equals("CASH")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CASH, tenderAmount);
            } else if (tenderType.equals("CRDT")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CREDIT, tenderAmount);
            } else if (tenderType.equals("CHCK")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("PPAL")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.PAYPAL, tenderAmount);
            } else if (tenderType.equals("TRAV")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CASH, tenderAmount);
            } else if (tenderType.equals("GICT")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("MBCK")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("DBIT")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.DEBIT, tenderAmount);
            } else if (tenderType.equals("QPON")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("GCRD")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("STCR")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("MACT")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CASH, tenderAmount);
            } else if (tenderType.equals("PRCH")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("MNYO")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("ECHK")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CHECK, tenderAmount);
            } else if (tenderType.equals("MERD")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("MARD")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.CASH, tenderAmount);
            } else if (tenderType.equals("CCSH")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            } else if (tenderType.equals("CCHK")) {
                tx.addToBucket(ReturnTransaction.TenderBucketType.OTHER, tenderAmount);
            }
        }
    }

    private Map<TransactionId, ReturnTransaction> getReturnTransactionList(DataContext context) {
        HashMap cached = (HashMap)context.get(this.CTX_CACHE_RETURN_TRANSACTIONS_IN_BATCH);
        if (cached == null) {
            cached = new HashMap();
            context.put(this.CTX_CACHE_RETURN_TRANSACTIONS_IN_BATCH, cached);
        }
        return cached;
    }

    private BigDecimal getQuantityReturned(Table table, DataContext context, String[] columnValues) {
        BigDecimal quantityReturned = new BigDecimal(columnValues[table.getColumnIndex("QU_ITM_LM_RTN_SLS")]);
        quantityReturned = quantityReturned.abs();
        return quantityReturned;
    }

    private void updateOriginalTransactionLineItem(DataContext context, TransactionId originalId, String orgLnItmSeqNum, BigDecimal quantityReturned) {
        ISqlTransaction transaction = context.findTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returned item " + originalId + ":" + orgLnItmSeqNum + ":" + quantityReturned));
        }
        if (0 == transaction.prepareAndExecute(this.sql.get("updateOriginalLineItemSql"), new Object[]{quantityReturned, originalId.getStoreId(), originalId.getWorkstationId(), originalId.getTransactionId(), originalId.getBusinessDay(), orgLnItmSeqNum}) && orgLnItmSeqNum != null && !orgLnItmSeqNum.equals("-1")) {
            logger.error((Object)("Could not find the original transaction id of " + originalId + " and line item sequence number of " + orgLnItmSeqNum + " to update."));
        }
    }

    private boolean isNotVoided(Table table, DataContext context, String[] columnValues) {
        boolean ret = true;
        if (table.getColumnIndex("FL_VD_LN_ITM") >= 0) {
            ret = "0".equals(columnValues[table.getColumnIndex("FL_VD_LN_ITM")]);
        }
        return ret;
    }

    private void updateOriginalTenderBuckets(DataContext context) {
        Collection<ReturnTransaction> txs = this.getReturnTransactionList(context).values();
        if (txs.size() > 0) {
            NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(this.dataSource);
            ISqlTransaction transaction = context.findTransaction();
            for (ReturnTransaction returnTransaction : txs) {
                if (!returnTransaction.isRefund()) continue;
                if (context.get("DC_RETURN") != Boolean.TRUE) {
                    Map<ReturnTransaction.TenderBucketType, BigDecimal> buckets = returnTransaction.getTenderBuckets();
                    Set<TransactionId> originalIds = returnTransaction.getOriginalTransactions();
                    for (TransactionId transactionId : originalIds) {
                        try {
                            Map<String, Object> values = this.toMap(transactionId);
                            values.putAll(template.queryForMap(this.sql.get("selectOriginalRetailTransactionSql"), values));
                            this.updateTenderBucketType(buckets, values, ReturnTransaction.TenderBucketType.CASH, "ANF_TRN_CSH_TOT");
                            this.updateTenderBucketType(buckets, values, ReturnTransaction.TenderBucketType.CHECK, "ANF_TRN_ECHK_TOT");
                            this.updateTenderBucketType(buckets, values, ReturnTransaction.TenderBucketType.CREDIT, "ANF_TRN_CRDT_TOT");
                            this.updateTenderBucketType(buckets, values, ReturnTransaction.TenderBucketType.DEBIT, "ANF_TRN_DBT_TOT");
                            this.updateTenderBucketType(buckets, values, ReturnTransaction.TenderBucketType.PAYPAL, "ANF_TRN_PPAL_TOT");
                            transaction.prepareAndExecute(this.sql.get("updateOriginalRetailTransactionSql"), new Object[]{values.get("ANF_TRN_CSH_TOT"), values.get("ANF_TRN_DBT_TOT"), values.get("ANF_TRN_ECHK_TOT"), values.get("ANF_TRN_CRDT_TOT"), values.get("ANF_TRN_PPAL_TOT"), values.get("ID_STR_RT"), values.get("ID_WS"), values.get("AI_TRN"), values.get("DC_DY_BSN")});
                        }
                        catch (EmptyResultDataAccessException ex) {
                            logger.warn((Object)("Could not find the original transaction that was in the barcode: " + transactionId));
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex, (Throwable)ex);
                        }
                    }
                    continue;
                }
                logger.info((Object)("Original Tender Buckets not updated TransactionId :" + returnTransaction.getId() + " : DC_RETURN:" + context.get("DC_RETURN")));
            }
        }
    }

    private void updateTenderBucketType(Map<ReturnTransaction.TenderBucketType, BigDecimal> buckets, Map<String, Object> values, ReturnTransaction.TenderBucketType bucketType, String bucketField) {
        BigDecimal bucketValue;
        BigDecimal amount = buckets.get((Object)bucketType);
        if (amount != null && (bucketValue = (BigDecimal)values.get(bucketField)) != null) {
            if ((bucketValue = bucketValue.add(amount)).compareTo(BigDecimal.ZERO) >= 0) {
                buckets.put(bucketType, BigDecimal.ZERO);
                values.put(bucketField, bucketValue);
            } else {
                buckets.put(bucketType, bucketValue);
                values.put(bucketField, BigDecimal.ZERO);
            }
        }
    }

    private Map<String, Object> toMap(TransactionId id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DC_DY_BSN", id.getBusinessDay());
        map.put("ID_STR_RT", id.getStoreId());
        map.put("ID_WS", id.getWorkstationId());
        map.put("AI_TRN", id.getTransactionId());
        return map;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSql(Map<String, String> sql) {
        this.sql = sql;
    }
}

