/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.util.Context;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class OutboundSalesPublisher
implements IPublisher,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private boolean enabled = true;
    static final Log logger = LogFactory.getLog(OutboundSalesPublisher.class);

    public void publish(Context context, final String text) {
        if (this.enabled) {
            final DataContext ctx = (DataContext)context;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"About to get a JMS template to send transaction");
            }
            JmsTemplate jmsTemplate = (JmsTemplate)this.beanFactory.getBean("outboundJmsTemplate");
            jmsTemplate.send(new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    ObjectMessage objectMessage = session.createObjectMessage((Serializable)((Object)text));
                    objectMessage.setStringProperty("NODE_ID", ctx.getBatch().getSourceNodeId());
                    String type = (String)ctx.get("TY_TRN");
                    objectMessage.setStringProperty("TY_TRN", type == null ? "?" : type);
                    objectMessage.setLongProperty("BATCH_ID", ctx.getBatch().getBatchId());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("NODE_ID :: " + objectMessage.getStringProperty("NODE_ID")));
                        logger.debug((Object)("TY_TRN :: " + objectMessage.getStringProperty("TY_TRN")));
                        logger.debug((Object)("BATCH_ID :: " + objectMessage.getLongProperty("BATCH_ID")));
                    }
                    return objectMessage;
                }
            });
        } else {
            logger.info((Object)("Publishing not enabled.  Would have published: \n" + text));
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

