/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.symmetric.corp.IAuditMessageHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.symmetric.integrate.SimpleJmsPublisher;
import org.jumpmind.util.Context;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.core.JmsTemplate;

public class JmsPublisher
implements IPublisher,
BeanFactoryAware {
    static final Log logger = LogFactory.getLog(SimpleJmsPublisher.class);
    private BeanFactory beanFactory;
    private String jmsTemplateBeanName;
    protected boolean enabled = true;
    protected IAuditMessageHandler auditMessageHandler;
    protected String queueName;

    public void publish(Context context, String text) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)text);
        }
        if (this.enabled) {
            JmsTemplate jmsTemplate = (JmsTemplate)this.beanFactory.getBean(this.jmsTemplateBeanName);
            jmsTemplate.convertAndSend((Object)text);
            if (this.auditMessageHandler != null) {
                this.auditMessageHandler.auditMessage("SYMMETRICDS", this.queueName, text);
            }
        } else {
            logger.warn((Object)"Message was not published because the publisher is not enabled.");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void setAuditMessageHandler(IAuditMessageHandler auditMessageHandler) {
        this.auditMessageHandler = auditMessageHandler;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setJmsTemplateBeanName(String jmsTemplateBeanName) {
        this.jmsTemplateBeanName = jmsTemplateBeanName;
    }
}

