/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.symmetric.corp;

import com.anfcorp.stores.symmetric.corp.IAuditMessageHandler;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class AuditMessageHandler
implements IAuditMessageHandler {
    protected static final Log logger = LogFactory.getLog(AuditMessageHandler.class);
    protected boolean enabled = true;
    protected String auditSql;
    protected DataSource dataSource;
    private final int MAX_STRING_SIZE = 32765;

    @Override
    public void auditMessage(String appId, String queueId, String message) {
        if (this.enabled) {
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            if (message.length() > 32765) {
                message = message.substring(0, 32765);
                logger.warn((Object)"Truncating message for auditing purposes.");
            }
            try {
                template.update(this.auditSql, new Object[]{appId, queueId, message});
            }
            catch (Exception ex) {
                logger.warn((Object)("Failed to audit message for queue " + queueId + "\n" + message));
            }
        }
    }

    public void setAuditSql(String auditSql) {
        this.auditSql = auditSql;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

