/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.kmclient;

import com.rsa.kmc.HeaderFormat;
import com.rsa.kmc.KMConfig;
import com.rsa.kmc.KMContext;
import com.rsa.kmc.KMException;
import com.rsa.kmc.KMKey;
import com.rsa.kmc.x.K;
import com.rsa.kmclient.KMSConfig;
import com.rsa.kmclient.KMSException;
import com.rsa.kmclient.KMSKey;
import java.security.InvalidKeyException;
import org.apache.log4j.Logger;

public class KMClient {
    private KMContext a;
    private KMSConfig b;
    private static Logger c = K.b();
    private KMConfig d;

    public KMClient() {
    }

    public KMClient(String string, char[] cArray) throws KMSException {
        this.initialize(string, cArray);
    }

    public KMClient(String string) throws KMSException {
        this.initialize(string);
    }

    public KMSConfig getKMSConfig() {
        return this.b;
    }

    public int initialize(String string) throws KMSException {
        return this.initialize(string, null);
    }

    public int initialize(String string, char[] cArray) throws KMSException {
        try {
            this.b = new KMSConfig(string);
            this.b.loadConfig();
            if (cArray == null) {
                cArray = this.b.getP12KeyStorePwd();
            }
            this.d = new KMConfig(cArray, cArray, string);
            this.a = this.d.newKMContext();
            return 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KMSException("KMS Client initialization failed : " + illegalArgumentException.getMessage());
        }
        catch (KMException kMException) {
            throw new KMSException("KMS Client initialization failed : " + kMException.getMessage());
        }
    }

    public KMSKey getKey(String string, String string2) throws KMSException {
        if (string == null) {
            throw new KMSException("getKey error : keyClass cannot be null");
        }
        this.a();
        try {
            KMKey kMKey = null;
            kMKey = string2 == null ? this.a.getKeyByKeyClassName(string) : this.a.getKeyById(Integer.parseInt(string2));
            if (kMKey != null) {
                KMSKey kMSKey = new KMSKey();
                kMSKey.setKeyID("" + kMKey.getId());
                kMSKey.setKeyData(kMKey.getKeyData());
                return kMSKey;
            }
            throw new KMSException("getKey : Unable to get a valid key");
        }
        catch (NumberFormatException numberFormatException) {
            throw new KMSException("getKey error : invalid keyId format");
        }
        catch (KMException kMException) {
            throw new KMSException("getKey error : " + kMException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KMSException("getKey error : " + invalidKeyException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KMSException("getKey error : " + illegalArgumentException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new KMSException("getKey error : " + illegalStateException.getMessage());
        }
    }

    public byte[] hmacData(String string, byte[] byArray, boolean bl) throws KMSException {
        if (string == null) {
            throw new KMSException("encryptData error : keyClass cannot be null");
        }
        if (byArray == null) {
            throw new KMSException("encryptData error : input data cannot be null");
        }
        this.a();
        HeaderFormat headerFormat = bl ? HeaderFormat.VERSION_1_5_BASE64 : HeaderFormat.VERSION_1_5;
        try {
            return this.a.computeMAC(string, byArray, headerFormat);
        }
        catch (KMException kMException) {
            throw new KMSException("hmacData error : " + kMException.getMessage());
        }
    }

    public byte[] encryptData(String string, byte[] byArray, boolean bl) throws KMSException {
        if (string == null) {
            throw new KMSException("encryptData error : keyClass cannot be null");
        }
        if (byArray == null) {
            throw new KMSException("encryptData error : input data cannot be null");
        }
        this.a();
        HeaderFormat headerFormat = bl ? HeaderFormat.VERSION_1_5_BASE64 : HeaderFormat.VERSION_1_5;
        try {
            return this.a.encrypt(string, byArray, headerFormat);
        }
        catch (KMException kMException) {
            throw new KMSException("encryptData error : " + kMException.getMessage());
        }
    }

    public byte[] decryptData(String string, byte[] byArray) throws KMSException {
        if (byArray == null) {
            throw new KMSException("Unable to perfrom decryption : error : Received NULL or invalid data to decrypt");
        }
        this.a();
        try {
            return this.a.decrypt(byArray);
        }
        catch (KMException kMException) {
            throw new KMSException("decryptData error: " + kMException.getMessage());
        }
    }

    public void flushCache() {
        try {
            this.a();
            try {
                this.a.purgeCache();
            }
            catch (IllegalStateException illegalStateException) {
                throw new KMSException(illegalStateException.getMessage());
            }
        }
        catch (KMSException kMSException) {
            c.debug((Object)"flushCache error : KMClient not initialized properly", (Throwable)kMSException);
        }
    }

    public void shutdown() {
        try {
            if (this.d != null) {
                this.d.shutdown();
            }
        }
        catch (KMException kMException) {
            c.debug((Object)"Shutdown error : ", (Throwable)kMException);
        }
    }

    public void displayCache() {
    }

    private void a() throws KMSException {
        if (this.a == null || !this.a.isOpen()) {
            throw new KMSException("error : KMClient not initialized properly");
        }
    }
}

